/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.doubled;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.FastColor;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.block.blockentity.IFramedDoubleBlockEntity;
import xfacthd.framedblocks.api.blueprint.BlueprintData;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContainerHelper;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.camo.empty.EmptyCamoContainer;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.config.DevToolsConfig;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockSoundType;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockStateCache;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;

public class FramedDoubleBlockEntity
extends FramedBlockEntity
implements IFramedDoubleBlockEntity {
    private final boolean[] culledFaces = new boolean[6];
    private final DoubleBlockSoundType soundType = new DoubleBlockSoundType(this);
    private CamoContainer<?, ?> camoContainer = EmptyCamoContainer.EMPTY;

    public FramedDoubleBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)FBContent.BE_TYPE_FRAMED_DOUBLE_BLOCK.value(), pos, state);
    }

    protected FramedDoubleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void setCamoInternal(CamoContainer<?, ?> camo, boolean secondary) {
        if (secondary) {
            this.camoContainer = camo;
        } else {
            super.setCamoInternal(camo, false);
        }
    }

    @Override
    public CamoContainer<?, ?> getCamo(BlockState state) {
        Tuple<BlockState, BlockState> blockPair = this.getStateCache().getBlockPair();
        if (state == blockPair.getA()) {
            return this.getCamo();
        }
        if (state == blockPair.getB()) {
            return this.getCamoTwo();
        }
        return EmptyCamoContainer.EMPTY;
    }

    @Override
    protected CamoContainer<?, ?> getCamo(boolean secondary) {
        return secondary ? this.camoContainer : this.getCamo();
    }

    @Override
    public final CamoContainer<?, ?> getCamoTwo() {
        return this.camoContainer;
    }

    @Override
    protected int getLightValue() {
        return Math.max(((CamoContent)this.camoContainer.getContent()).getLightEmission(), super.getLightValue());
    }

    @Override
    protected boolean isValidRemovalToolForAnyCamo(ItemStack stack) {
        return super.isValidRemovalToolForAnyCamo(stack) || CamoContainerHelper.isValidRemovalTool(this.camoContainer, stack);
    }

    @Override
    public IFramedDoubleBlock getBlock() {
        return (IFramedDoubleBlock)super.getBlock();
    }

    @Override
    public DoubleBlockStateCache getStateCache() {
        return (DoubleBlockStateCache)super.getStateCache();
    }

    @Override
    public boolean canAutoApplyCamoOnPlacement() {
        return false;
    }

    @Override
    public boolean canTriviallyDropAllCamos() {
        return super.canTriviallyDropAllCamos() && this.camoContainer.canTriviallyConvertToItemStack();
    }

    @Override
    public void addCamoDrops(List<ItemStack> drops) {
        ItemStack stack;
        super.addCamoDrops(drops);
        if (!this.camoContainer.isEmpty() && !(stack = CamoContainerHelper.dropCamo(this.camoContainer)).isEmpty()) {
            drops.add(stack);
        }
    }

    @Override
    public MapColor getMapColor() {
        return switch (this.getStateCache().getTopInteractionMode()) {
            default -> throw new MatchException(null, null);
            case DoubleBlockTopInteractionMode.FIRST -> super.getMapColor();
            case DoubleBlockTopInteractionMode.SECOND -> this.camoContainer.getMapColor((BlockGetter)this.level(), this.worldPosition);
            case DoubleBlockTopInteractionMode.EITHER -> {
                MapColor color = super.getMapColor();
                if (color != null) {
                    yield color;
                }
                yield this.camoContainer.getMapColor((BlockGetter)this.level(), this.worldPosition);
            }
        };
    }

    @Override
    public Integer getCamoBeaconColorMultiplier(LevelReader level, BlockPos pos, BlockPos beaconPos) {
        Integer superMult = super.getCamoBeaconColorMultiplier(level, pos, beaconPos);
        Integer localMult = this.camoContainer.getBeaconColorMultiplier(level, pos, beaconPos);
        if (superMult == null) {
            return localMult;
        }
        if (localMult == null) {
            return superMult;
        }
        return FastColor.ARGB32.multiply((int)superMult, (int)localMult);
    }

    @Override
    public boolean shouldCamoDisplayFluidOverlay(BlockAndTintGetter level, BlockPos pos, FluidState fluid) {
        if (((CamoContent)this.camoContainer.getContent()).shouldDisplayFluidOverlay(level, pos, fluid)) {
            return true;
        }
        return super.shouldCamoDisplayFluidOverlay(level, pos, fluid);
    }

    @Override
    public float getCamoFriction(BlockState state, @Nullable Entity entity, float frameFriction) {
        return switch (this.getStateCache().getTopInteractionMode()) {
            default -> throw new MatchException(null, null);
            case DoubleBlockTopInteractionMode.FIRST -> ((CamoContent)this.getCamo().getContent()).getFriction((LevelReader)this.level, this.worldPosition, entity, frameFriction);
            case DoubleBlockTopInteractionMode.SECOND -> ((CamoContent)this.getCamoTwo().getContent()).getFriction((LevelReader)this.level, this.worldPosition, entity, frameFriction);
            case DoubleBlockTopInteractionMode.EITHER -> Math.max(((CamoContent)this.getCamo().getContent()).getFriction((LevelReader)this.level, this.worldPosition, entity, frameFriction), ((CamoContent)this.getCamoTwo().getContent()).getFriction((LevelReader)this.level, this.worldPosition, entity, frameFriction));
        };
    }

    @Override
    public TriState canCamoSustainPlant(Direction side, BlockState plant) {
        return this.getStateCache().getSolidityCheck(side).canSustainPlant(this, side, plant);
    }

    @Override
    public boolean canEntityDestroyCamo(Entity entity) {
        if (super.canEntityDestroyCamo(entity)) {
            return true;
        }
        return ((CamoContent)this.camoContainer.getContent()).canEntityDestroy((BlockGetter)this.level(), this.worldPosition, entity);
    }

    @Override
    protected boolean isCamoSolid() {
        return super.isCamoSolid() && ((CamoContent)this.camoContainer.getContent()).isSolid((BlockGetter)this.level(), this.worldPosition);
    }

    @Override
    protected boolean doesCamoPropagateSkylightDown() {
        if (!((CamoContent)this.camoContainer.getContent()).propagatesSkylightDown((BlockGetter)this.level(), this.worldPosition)) {
            return false;
        }
        return super.doesCamoPropagateSkylightDown();
    }

    @Override
    public float getCamoExplosionResistance(Explosion explosion) {
        return Math.max(super.getCamoExplosionResistance(explosion), ((CamoContent)this.camoContainer.getContent()).getExplosionResistance((BlockGetter)this.level(), this.worldPosition, explosion));
    }

    @Override
    public boolean isCamoFlammable(Direction face) {
        CamoContainer<?, ?> camo = this.getCamo(face);
        if (!(!camo.isEmpty() || this.getCamo().isEmpty() && this.camoContainer.isEmpty())) {
            return !(!this.getCamo().isEmpty() && !((CamoContent)this.getCamo().getContent()).isFlammable((BlockGetter)this.level(), this.worldPosition, face) || !this.camoContainer.isEmpty() && !((CamoContent)this.camoContainer.getContent()).isFlammable((BlockGetter)this.level(), this.worldPosition, face));
        }
        if (!camo.isEmpty()) {
            return ((CamoContent)camo.getContent()).isFlammable((BlockGetter)this.level(), this.worldPosition, face);
        }
        return true;
    }

    @Override
    public int getCamoFlammability(Direction face) {
        int flammabilityOne = super.getCamoFlammability(face);
        int flammabilityTwo = ((CamoContent)this.camoContainer.getContent()).getFlammability((BlockGetter)this.level(), this.worldPosition, face);
        if (flammabilityOne == -1) {
            return flammabilityTwo;
        }
        if (flammabilityTwo == -1) {
            return flammabilityOne;
        }
        return Math.min(flammabilityOne, flammabilityTwo);
    }

    @Override
    public int getCamoFireSpreadSpeed(Direction face) {
        int spreadSpeedOne = super.getCamoFireSpreadSpeed(face);
        int spreadSpeedTwo = ((CamoContent)this.camoContainer.getContent()).getFireSpreadSpeed((BlockGetter)this.level(), this.worldPosition, face);
        if (spreadSpeedOne == -1) {
            return spreadSpeedOne;
        }
        if (spreadSpeedTwo == -1) {
            return spreadSpeedTwo;
        }
        return Math.min(spreadSpeedOne, spreadSpeedTwo);
    }

    @Override
    public float getCamoShadeBrightness(float ownShade) {
        return Math.max(super.getCamoShadeBrightness(ownShade), ((CamoContent)this.camoContainer.getContent()).getShadeBrightness((BlockGetter)this.level(), this.worldPosition, ownShade));
    }

    public final DoubleBlockSoundType getSoundType() {
        return this.soundType;
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit, Vec3 lookVec, Vec3 eyePos) {
        lookVec = lookVec.normalize().multiply(0.0625, 0.0625, 0.0625);
        Vec3 vecStart = hit.getLocation().subtract(lookVec);
        Vec3 vecEnd = hit.getLocation().add(lookVec);
        VoxelShape shapeSec = ((BlockState)this.getBlockPair().getB()).getShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
        BlockHitResult clipSec = shapeSec.clip(vecStart, vecEnd, this.worldPosition);
        if (clipSec == null) {
            return false;
        }
        VoxelShape shapePri = ((BlockState)this.getBlockPair().getA()).getShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
        BlockHitResult clipPri = shapePri.clip(vecStart, vecEnd, this.worldPosition);
        if (clipPri == null) {
            return true;
        }
        return eyePos.distanceToSqr(clipSec.getLocation()) < eyePos.distanceToSqr(clipPri.getLocation());
    }

    public final DoubleBlockTopInteractionMode getTopInteractionMode() {
        return this.getStateCache().getTopInteractionMode();
    }

    @Override
    public final CamoContainer<?, ?> getCamo(Direction side) {
        return this.getCamo(side, null);
    }

    @Override
    public final CamoContainer<?, ?> getCamo(Direction side, @Nullable Direction edge) {
        return this.getStateCache().getCamoGetter(side, edge).getCamo(this);
    }

    @Override
    public final boolean isSolidSide(Direction side) {
        return this.getStateCache().getSolidityCheck(side).isSolid(this);
    }

    @Override
    protected boolean updateCulling(Direction side, BlockState state, boolean rerender) {
        Tuple<BlockState, BlockState> blockPair = this.getStateCache().getBlockPair();
        boolean changed = super.updateCulling(side, (BlockState)blockPair.getA(), rerender);
        return changed |= this.updateCulling(this.culledFaces, (BlockState)blockPair.getB(), side, rerender);
    }

    public boolean hasCustomOutlineRendering(Player player) {
        return !FMLEnvironment.production && DevToolsConfig.VIEW.isDoubleBlockPartHitDebugRendererEnabled();
    }

    public final Tuple<BlockState, BlockState> getBlockPair() {
        return this.getStateCache().getBlockPair();
    }

    public final boolean debugHitSecondary(BlockHitResult hit, Player player) {
        return this.hitSecondary(hit, player);
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        super.writeToDataPacket(nbt, lookupProvider);
        nbt.put("camo_two", (Tag)CamoContainerHelper.writeToNetwork(this.camoContainer));
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        boolean needUpdate = false;
        CamoContainer<?, ?> newCamo = CamoContainerHelper.readFromNetwork(nbt.getCompound("camo_two"));
        if (!newCamo.equals(this.camoContainer)) {
            int oldLight = this.getLightValue();
            this.camoContainer = newCamo;
            if (oldLight != this.getLightValue()) {
                this.doLightUpdate();
            }
            needUpdate = true;
            this.updateCulling(true, false);
        }
        return super.readFromDataPacket(nbt, lookupProvider) || needUpdate;
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        nbt.put("camo_two", (Tag)CamoContainerHelper.writeToNetwork(this.camoContainer));
        return nbt;
    }

    @Override
    protected boolean readCamoFromUpdateTag(CompoundTag nbt, HolderLookup.Provider provider) {
        boolean changed = super.readCamoFromUpdateTag(nbt, provider);
        CamoContainer<?, ?> newCamo = CamoContainerHelper.readFromNetwork(nbt.getCompound("camo_two"));
        if (!newCamo.equals(this.camoContainer)) {
            this.camoContainer = newCamo;
            changed = true;
        }
        return changed;
    }

    @Override
    public ModelData getModelData(boolean includeCullInfo) {
        boolean[] cullData = includeCullInfo ? this.culledFaces : FramedBlockData.NO_CULLED_FACES;
        FramedBlockData modelData = new FramedBlockData((CamoContent<?>)this.camoContainer.getContent(), cullData, true, this.isReinforced());
        return ModelData.builder().with(DATA_ONE, (Object)super.getModelData(includeCullInfo)).with(DATA_TWO, (Object)ModelData.builder().with(FramedBlockData.PROPERTY, (Object)modelData).build()).build();
    }

    @Override
    protected CamoList collectCamosForBlueprint() {
        return CamoList.of(this.getCamo(), this.camoContainer);
    }

    @Override
    protected void applyCamosFromBlueprint(BlueprintData blueprintData) {
        super.applyCamosFromBlueprint(blueprintData);
        this.setCamo(blueprintData.camos().getCamo(1), true);
    }

    @Override
    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("camo_two");
    }

    @Override
    protected void collectCamoComponents(DataComponentMap.Builder builder) {
        builder.set(FBContent.DC_TYPE_CAMO_LIST, (Object)CamoList.of(this.getCamo(), this.camoContainer));
    }

    @Override
    protected void applyCamoComponents(BlockEntity.DataComponentInput input) {
        super.applyCamoComponents(input);
        this.setCamo(((CamoList)input.getOrDefault(Utils.DC_TYPE_CAMO_LIST, (Object)CamoList.EMPTY)).getCamo(1), true);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.put("camo_two", CamoContainerHelper.writeToDisk(this.camoContainer));
        super.saveAdditional(nbt, provider);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.camoContainer = this.loadAndValidateCamo(nbt, "camo_two");
    }
}

