/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.special;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.menu.FramingSawMenu;

public class FramingSawBlock
extends Block {
    public static final Component SAW_MENU_TITLE = Utils.translate("title", "framing_saw");
    protected static final VoxelShape SHAPE = FramingSawBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);

    public FramingSawBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f));
        if (this.defaultBlockState().hasProperty((Property)PropertyHolder.SAW_ENCODER)) {
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PropertyHolder.SAW_ENCODER, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.SAW_ENCODER});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)context.getHorizontalDirection());
    }

    protected InteractionResult useWithoutItem(BlockState state, final Level level, final BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide()) {
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return FramingSawBlock.this.getSawMenuTitle();
                }

                public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                    return FramingSawBlock.this.createSawMenu(containerId, inventory, level, pos);
                }
            }, pos);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        Direction dir = rotation.rotate((Direction)state.getValue((Property)FramedProperties.FACING_HOR));
        return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir);
    }

    protected Component getSawMenuTitle() {
        return SAW_MENU_TITLE;
    }

    protected AbstractContainerMenu createSawMenu(int containerId, Inventory inventory, Level level, BlockPos pos) {
        return FramingSawMenu.create(containerId, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos));
    }
}

