/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanelcorner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedCornerSlopePanelWallBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedInverseDoubleCornerSlopePanelWallBlock
extends AbstractFramedDoubleBlock {
    public FramedInverseDoubleCornerSlopePanelWallBlock() {
        super(BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL_W);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.Y_SLOPE, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return FramedCornerSlopePanelWallBlock.getStateForPlacement(this, ctx, true);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction side = hit.getDirection();
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(dir);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
        if (side == rotDir.getOpposite() || side == perpRotDir.getOpposite()) {
            side = dir;
        } else if (side == rotDir || side == perpRotDir) {
            Vec3 hitVec = hit.getLocation();
            double paralell = Utils.fractionInDir(hitVec, dir.getOpposite());
            double perp = Utils.fractionInDir(hitVec, side == rotDir ? perpRotDir : rotDir) - 0.5;
            if (perp * 2.0 > paralell) {
                side = dir;
            }
        }
        return this.rotate(state, side, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (face.getAxis() == dir.getAxis()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            return (BlockState)state.setValue(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, (Direction)state.getValue((Property)FramedProperties.FACING_HOR), rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return FramedCornerSlopePanelWallBlock.mirrorCornerPanel(state, mirror);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        HorizontalRotation rot;
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation backRot = rot.rotate((rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION))).isVertical() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_LARGE_CORNER_SLOPE_PANEL_WALL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue(PropertyHolder.ROTATION, (Comparable)((Object)rot))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_WALL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getOpposite())).setValue(PropertyHolder.ROTATION, (Comparable)((Object)backRot))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        if (rot == HorizontalRotation.UP || rot == HorizontalRotation.RIGHT) {
            return DoubleBlockTopInteractionMode.EITHER;
        }
        return DoubleBlockTopInteractionMode.FIRST;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        Direction rotDir = rot.withFacing(dir).getOpposite();
        Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir).getOpposite();
        if (side == dir && (edge == rotDir || edge == perpRotDir)) {
            return CamoGetter.FIRST;
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        return SolidityCheck.NONE;
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return ((IFramedBlock)FBContent.BLOCK_FRAMED_INVERSE_DOUBLE_CORNER_SLOPE_PANEL.value()).getJadeRenderState(state);
    }
}

