/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slab;

import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.item.FramedSpecialDoubleBlockItem;

public class FramedPanelBlock
extends FramedBlock {
    public FramedPanelBlock() {
        super(BlockType.FRAMED_PANEL);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, BlockStateProperties.WATERLOGGED, FramedProperties.SOLID});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withTargetOrHorizontalFacing()).withWater()).build();
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext ctx) {
        if (ctx.getPlayer() != null && !ctx.getPlayer().isShiftKeyDown() && ctx.getItemInHand().is(this.asItem())) {
            if (!ctx.replacingClickedOnBlock()) {
                return true;
            }
            Direction innerFace = ((Direction)state.getValue((Property)FramedProperties.FACING_HOR)).getOpposite();
            return ctx.getClickedFace() == innerFace || Utils.fractionInDir(ctx.getClickLocation(), innerFace) > 0.5;
        }
        return false;
    }

    @Override
    public BlockItem createBlockItem() {
        return new FramedSpecialDoubleBlockItem(this, this, new Item.Properties()){

            @Override
            protected BlockState getReplacementState(BlockPlaceContext ctx, BlockState originalState) {
                Direction facing = (Direction)originalState.getValue((Property)FramedProperties.FACING_HOR);
                return (BlockState)((Block)FBContent.BLOCK_FRAMED_DOUBLE_PANEL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing);
            }

            @Override
            protected boolean shouldWriteToCamoTwo(BlockPlaceContext ctx, BlockState originalState) {
                return false;
            }
        };
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

