/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive;

import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedChiseledBookshelfBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedChiseledBookshelfBlock
extends FramedBlock {
    public FramedChiseledBookshelfBlock() {
        super(BlockType.FRAMED_CHISELED_BOOKSHELF);
        BlockState state = this.defaultBlockState();
        for (BooleanProperty prop : ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES) {
            state = (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(state);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, FramedProperties.SOLID});
        ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.forEach(xva$0 -> builder.add(new Property[]{xva$0}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHorizontalFacing(true)).build();
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (level.isClientSide() || stack.get(DataComponents.BLOCK_ENTITY_DATA) == null) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedChiseledBookshelfBlockEntity) {
            FramedChiseledBookshelfBlockEntity be = (FramedChiseledBookshelfBlockEntity)blockEntity;
            be.forceStateUpdate();
        }
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemInteractionResult result = super.useItemOn(stack, state, level, pos, player, hand, hit);
        if (result.consumesAction()) {
            return result;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedChiseledBookshelfBlockEntity) {
            FramedChiseledBookshelfBlockEntity be = (FramedChiseledBookshelfBlockEntity)blockEntity;
            if (!stack.is(ItemTags.BOOKSHELF_BOOKS)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            OptionalInt slot = ((ChiseledBookShelfBlock)Blocks.CHISELED_BOOKSHELF).getHitSlot(hit, state);
            if (slot.isEmpty()) {
                return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
            }
            if (((Boolean)state.getValue((Property)ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(slot.getAsInt()))).booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            FramedChiseledBookshelfBlock.placeBook(level, pos, player, be, stack, slot.getAsInt());
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedChiseledBookshelfBlockEntity) {
            FramedChiseledBookshelfBlockEntity be = (FramedChiseledBookshelfBlockEntity)blockEntity;
            OptionalInt slot = ((ChiseledBookShelfBlock)Blocks.CHISELED_BOOKSHELF).getHitSlot(hit, state);
            if (slot.isEmpty()) {
                return InteractionResult.PASS;
            }
            if (!((Boolean)state.getValue((Property)ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(slot.getAsInt()))).booleanValue()) {
                return InteractionResult.CONSUME;
            }
            FramedChiseledBookshelfBlock.takeBook(level, pos, player, be, slot.getAsInt());
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    private static void placeBook(Level level, BlockPos pos, Player player, FramedChiseledBookshelfBlockEntity be, ItemStack stack, int slot) {
        if (level.isClientSide()) {
            return;
        }
        be.placeBook(stack.split(1), slot);
        if (player.isCreative()) {
            stack.grow(1);
        }
        SoundEvent sound = stack.is(Items.ENCHANTED_BOOK) ? SoundEvents.CHISELED_BOOKSHELF_INSERT_ENCHANTED : SoundEvents.CHISELED_BOOKSHELF_INSERT;
        level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
    }

    private static void takeBook(Level level, BlockPos pos, Player player, FramedChiseledBookshelfBlockEntity be, int slot) {
        if (level.isClientSide()) {
            return;
        }
        ItemStack stack = be.takeBook(slot);
        Utils.giveToPlayer(player, stack, true);
        SoundEvent sound = stack.is(Items.ENCHANTED_BOOK) ? SoundEvents.CHISELED_BOOKSHELF_PICKUP_ENCHANTED : SoundEvents.CHISELED_BOOKSHELF_PICKUP;
        level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (newState.getBlock() != state.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof FramedChiseledBookshelfBlockEntity) {
            FramedChiseledBookshelfBlockEntity be = (FramedChiseledBookshelfBlockEntity)blockEntity;
            be.getDrops().forEach(stack -> FramedChiseledBookshelfBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack));
            be.clearContents();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedChiseledBookshelfBlockEntity) {
            FramedChiseledBookshelfBlockEntity be = (FramedChiseledBookshelfBlockEntity)blockEntity;
            return be.getAnalogOutputSignal();
        }
        return 0;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedChiseledBookshelfBlockEntity(pos, state);
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.NORTH);
    }
}

