/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen.overlay;

import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.fml.loading.FMLEnvironment;
import xfacthd.framedblocks.client.screen.overlay.BlockInteractOverlay;
import xfacthd.framedblocks.client.screen.overlay.CamoRotationOverlay;
import xfacthd.framedblocks.client.screen.overlay.FrameBackgroundOverlay;
import xfacthd.framedblocks.client.screen.overlay.OneWayWindowOverlay;
import xfacthd.framedblocks.client.screen.overlay.PrismOffsetOverlay;
import xfacthd.framedblocks.client.screen.overlay.ReinforcementOverlay;
import xfacthd.framedblocks.client.screen.overlay.SplitLineOverlay;
import xfacthd.framedblocks.client.screen.overlay.StateLockOverlay;
import xfacthd.framedblocks.client.screen.overlay.ToggleWaterloggableOverlay;
import xfacthd.framedblocks.client.screen.overlay.ToggleYSlopeOverlay;

public final class BlockInteractOverlayLayer
implements LayeredDraw.Layer {
    private static final List<BlockInteractOverlay> OVERLAYS = List.of(new StateLockOverlay(), new ToggleWaterloggableOverlay(), new ToggleYSlopeOverlay(), new ReinforcementOverlay(), new PrismOffsetOverlay(), new SplitLineOverlay(), new OneWayWindowOverlay(), new FrameBackgroundOverlay(), new CamoRotationOverlay());

    public void render(GuiGraphics graphics, DeltaTracker delta) {
        String renderedOverlay = null;
        for (BlockInteractOverlay overlay : OVERLAYS) {
            if (!overlay.render(graphics)) continue;
            if (FMLEnvironment.production) break;
            if (renderedOverlay != null) {
                String msg = "Only one overlay may be active at any time, encountered collision between '%s' and '%s'".formatted(renderedOverlay, overlay.getName());
                throw new IllegalStateException(msg);
            }
            renderedOverlay = overlay.getName();
        }
    }

    public static void onResourceReload(ResourceManager manager) {
        OVERLAYS.forEach(overlay -> {
            overlay.textWidthValid = false;
        });
    }
}

