/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.Optionull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.FramingSawScreen;
import xfacthd.framedblocks.common.compat.ae2.AppliedEnergisticsCompat;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeMatchResult;
import xfacthd.framedblocks.common.menu.FramingSawMenu;
import xfacthd.framedblocks.common.menu.FramingSawWithEncoderMenu;
import xfacthd.framedblocks.common.net.payload.ServerboundEncodeFramingSawPatternPayload;
import xfacthd.framedblocks.common.util.ArrayBackedRecipeInput;

public class FramingSawWithEncoderScreen
extends FramingSawScreen {
    public static final Component TOOLTIP_TAB_CRAFTING = Utils.translate("tooltip", "framing_saw.mode.crafting");
    public static final Component TOOLTIP_TAB_PATTERN = Utils.translate("tooltip", "framing_saw.mode.pattern_encode");
    private static final ResourceLocation BACKGROUND_ENCODER = Utils.rl("textures/gui/framing_saw_encoder.png");
    private static final ResourceLocation TAB_ICON = Utils.rl("minecraft", "advancements/tab_left_middle");
    private static final ResourceLocation TAB_SELECTED_ICON = Utils.rl("minecraft", "advancements/tab_left_middle_selected");
    private static final WidgetSprites ENCODE_BTN_SPRITES = new WidgetSprites(Utils.rl("button_encode"), Utils.rl("button_encode_disabled"), Utils.rl("button_encode_focused"));
    public static final int TAB_WIDTH = 32;
    public static final int TAB_HEIGHT = 28;
    public static final int TAB_X = -28;
    public static final int TAB_TOP_Y = 4;
    private static final int TAB_BOT_Y = 32;
    private static final int TAB_ICON_X = -18;
    private static final int TAB_ICON_TOP_Y = 10;
    private static final int TAB_ICON_BOT_Y = 38;
    private static final int ENCODER_RESULT_SLOT_Y = 31;
    private final ItemStack tableStack = new ItemStack((ItemLike)Items.CRAFTING_TABLE);
    private final ItemStack blankPatternStack = AppliedEnergisticsCompat.makeBlankPatternStack();
    private final ItemStack sawPatternStack = AppliedEnergisticsCompat.makeSawPatternStack();
    private final ItemStack[] encodingInputs = new ItemStack[4];
    private final RecipeInput encodingRecipeInput = new ArrayBackedRecipeInput(this.encodingInputs);
    private Button encodeButton = null;
    private boolean encoding = false;
    private FramingSawRecipeCalculation encoderCalculation = null;
    private FramingSawRecipeMatchResult encoderMatchResult = null;

    FramingSawWithEncoderScreen(FramingSawMenu menu, Inventory inv, Component title) {
        super(menu, inv, title);
        Preconditions.checkState((boolean)AppliedEnergisticsCompat.isLoaded(), (Object)"FramingSawWithEncoderScreen requires AE2, how did we get here???");
        this.resetEncoderInputs(((FramingSawWithEncoderMenu)menu).isInEncoderMode());
    }

    @Override
    protected void init() {
        super.init();
        this.encodeButton = (Button)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 224, this.topPos + 92, 14, 14, ENCODE_BTN_SPRITES, this::onEncodePressed));
        ((FramingSawWithEncoderMenu)this.menu).setEncoderModeListener(encoder -> {
            this.encoding = encoder;
            this.encodeButton.visible = encoder;
            this.resetEncoderInputs(encoder);
            if (encoder) {
                this.updateEncoderCalculation();
            } else {
                this.encoderCalculation = null;
                this.encoderMatchResult = null;
            }
        });
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTick, mouseX, mouseY);
        ResourceLocation rlTop = this.encoding ? TAB_ICON : TAB_SELECTED_ICON;
        graphics.blitSprite(rlTop, this.leftPos + -28, this.topPos + 4, 32, 28);
        graphics.renderFakeItem(this.tableStack, this.leftPos + -18, this.topPos + 10);
        ResourceLocation rlBot = this.encoding ? TAB_SELECTED_ICON : TAB_ICON;
        graphics.blitSprite(rlBot, this.leftPos + -28, this.topPos + 32, 32, 28);
        graphics.renderFakeItem(this.sawPatternStack, this.leftPos + -18, this.topPos + 38);
        if (this.encoding) {
            FramingSawRecipe recipe = (FramingSawRecipe)this.cache.getRecipes().get(((FramingSawMenu)this.menu).getSelectedRecipeIndex()).value();
            ClientUtils.renderTransparentFakeItem(graphics, recipe.getResult(), this.leftPos + 223, this.topPos + 31);
            int count = (Integer)Optionull.mapOrDefault((Object)this.encoderCalculation, FramingSawRecipeCalculation::getOutputCount, (Object)1);
            this.drawItemCount(graphics, count, this.leftPos + 223, this.topPos + 31);
            if (!((FramingSawMenu)this.menu).getSlot(41).hasItem()) {
                ClientUtils.renderTransparentFakeItem(graphics, this.blankPatternStack, this.leftPos + 223, this.topPos + 73);
            }
            if (!((FramingSawMenu)this.menu).getSlot(42).hasItem()) {
                ClientUtils.renderTransparentFakeItem(graphics, this.sawPatternStack, this.leftPos + 223, this.topPos + 109);
            }
        }
    }

    @Override
    protected ResourceLocation getBackground() {
        return this.encoding ? BACKGROUND_ENCODER : super.getBackground();
    }

    @Override
    public ItemStack getInputStack() {
        return this.encoding ? this.encodingInputs[0] : super.getInputStack();
    }

    @Override
    public ItemStack getAdditiveStack(int slot) {
        return this.encoding ? this.encodingInputs[slot + 1] : super.getAdditiveStack(slot);
    }

    @Override
    public RecipeInput getRecipeInput() {
        return this.encoding ? this.encodingRecipeInput : super.getRecipeInput();
    }

    @Override
    protected void handleRecipeChange() {
        super.handleRecipeChange();
        if (this.encoding) {
            this.resetEncoderInputs(true);
            this.updateEncoderCalculation();
        }
    }

    @Override
    protected boolean drawInputStackHint(GuiGraphics graphics, ItemStack input) {
        if (!super.drawInputStackHint(graphics, input) && this.encoding) {
            graphics.renderFakeItem(input, this.leftPos + 20, this.topPos + 28);
            int count = (Integer)Optionull.mapOrDefault((Object)this.encoderCalculation, FramingSawRecipeCalculation::getInputCount, (Object)1);
            this.drawItemCount(graphics, count, this.leftPos + 20, this.topPos + 28);
        }
        return true;
    }

    @Override
    protected boolean drawAdditiveStackHint(GuiGraphics graphics, int index, ItemStack additive, List<FramingSawRecipeAdditive> additives, int y) {
        boolean superResult = super.drawAdditiveStackHint(graphics, index, additive, additives, y);
        if (this.encoding) {
            if (!superResult) {
                graphics.renderFakeItem(additive, this.leftPos + 20, y);
            }
            int count = (Integer)Optionull.mapOrDefault((Object)this.encoderCalculation, calc -> calc.getAdditiveCount(index), (Object)1);
            this.drawItemCount(graphics, count, this.leftPos + 20, y);
        }
        return true;
    }

    @Override
    protected boolean displayRecipeErrors() {
        return !this.encoding;
    }

    private void drawItemCount(GuiGraphics graphics, int count, int x, int y) {
        if (count != 1) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 200.0f);
            String text = String.valueOf(count);
            graphics.drawString(this.font, text, x + 19 - 2 - this.font.width(text), y + 6 + 3, 0xFFFFFF, true);
            graphics.pose().popPose();
        }
    }

    @Override
    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        block10: {
            block8: {
                block9: {
                    super.renderTooltip(graphics, mouseX, mouseY);
                    if (mouseX < this.leftPos + -28 || mouseX > this.leftPos) break block8;
                    if (mouseY < this.topPos + 4 || mouseY > this.topPos + 32) break block9;
                    graphics.renderTooltip(this.font, TOOLTIP_TAB_CRAFTING, mouseX, mouseY);
                    break block10;
                }
                if (mouseY < this.topPos + 32 || mouseY > this.topPos + 60) break block10;
                graphics.renderTooltip(this.font, TOOLTIP_TAB_PATTERN, mouseX, mouseY);
                break block10;
            }
            if (this.encodeButton.isMouseOver((double)mouseX, (double)mouseY) && this.encoderMatchResult != null && !this.encoderMatchResult.success()) {
                ArrayList<Component> lines = new ArrayList<Component>();
                FramingSawMenu.FramedRecipeHolder recipe = ((FramingSawMenu)this.menu).getRecipes().get(((FramingSawMenu)this.menu).getSelectedRecipeIndex());
                FramingSawWithEncoderScreen.appendRecipeFailure(lines, this.cache, recipe.getRecipe(), this.encoderMatchResult, this);
                graphics.renderTooltip(this.font, lines, Optional.empty(), mouseX, mouseY);
            } else if (this.encoding) {
                for (int i = 0; i <= 4; ++i) {
                    ItemStack stack;
                    int sy;
                    Slot slot = ((FramingSawMenu)this.menu).getSlot(i);
                    int n = sy = i == 4 ? 31 : slot.y;
                    if (!this.isHovering(slot.x, sy, 16, 16, mouseX, mouseY)) continue;
                    switch (i) {
                        case 0: {
                            ItemStack itemStack = this.getInputStack();
                            break;
                        }
                        case 4: {
                            ItemStack itemStack = ((FramingSawMenu)this.menu).getRecipes().get(((FramingSawMenu)this.menu).getSelectedRecipeIndex()).getRecipe().getResult();
                            break;
                        }
                        default: {
                            ItemStack itemStack = stack = this.getAdditiveStack(i - 1);
                        }
                    }
                    if (stack.isEmpty()) break;
                    this.renderItemTooltip(graphics, mouseX, mouseY, stack, null);
                    break;
                }
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (mouseX >= (double)(this.leftPos + -28) && mouseX <= (double)this.leftPos) {
                int value = 0;
                boolean hit = false;
                if (mouseY >= (double)(this.topPos + 4) && mouseY <= (double)(this.topPos + 32)) {
                    value = -1;
                    hit = true;
                } else if (mouseY >= (double)(this.topPos + 32) && mouseY <= (double)(this.topPos + 60)) {
                    value = -2;
                    hit = true;
                }
                if (hit) {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    this.minecraft.gameMode.handleInventoryButtonClick(((FramingSawMenu)this.menu).containerId, value);
                    return true;
                }
            } else if (this.encoding) {
                ItemStack carried = ((FramingSawMenu)this.menu).getCarried();
                FramingSawRecipe recipe = (FramingSawRecipe)this.cache.getRecipes().get(((FramingSawMenu)this.menu).getSelectedRecipeIndex()).value();
                for (int i = 0; i < 1 + recipe.getAdditives().size(); ++i) {
                    Slot slot = ((FramingSawMenu)this.menu).getSlot(i);
                    if (!this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY)) continue;
                    if (i == 0 || recipe.getAdditives().get(i - 1).ingredient().test(carried)) {
                        this.acceptEncodingInput(i, carried.copyWithCount(1));
                    }
                    return true;
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void acceptEncodingInput(int slot, ItemStack stack) {
        this.encodingInputs[slot] = stack;
        if (slot == 0) {
            if (stack.isEmpty()) {
                this.encodingInputs[0] = this.cubeStack.copyWithCount(1);
            }
            this.updateEncoderCalculation();
        }
    }

    private void resetEncoderInputs(boolean encoding) {
        Arrays.fill(this.encodingInputs, ItemStack.EMPTY);
        if (encoding) {
            this.encodingInputs[0] = this.cubeStack.copyWithCount(1);
            List<FramingSawRecipeAdditive> additives = ((FramingSawRecipe)this.cache.getRecipes().get(((FramingSawMenu)this.menu).getSelectedRecipeIndex()).value()).getAdditives();
            for (int i = 0; i < additives.size(); ++i) {
                this.encodingInputs[i + 1] = additives.get(i).ingredient().getItems()[0].copyWithCount(1);
            }
        }
    }

    private void updateEncoderCalculation() {
        FramingSawRecipe recipe = (FramingSawRecipe)this.cache.getRecipes().get(((FramingSawMenu)this.menu).getSelectedRecipeIndex()).value();
        this.encoderCalculation = recipe.makeCraftingCalculation(this.encodingRecipeInput, true);
        this.encodingInputs[0].setCount(this.encoderCalculation.getInputCount());
        for (int i = 0; i < recipe.getAdditives().size(); ++i) {
            this.encodingInputs[i + 1].setCount(this.encoderCalculation.getAdditiveCount(i));
        }
        this.encoderMatchResult = recipe.matchWithResult(this.encodingRecipeInput, (Level)this.minecraft.level);
    }

    private void onEncodePressed(Button btn) {
        if (this.encoderMatchResult == null || !this.encoderMatchResult.success()) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundEncodeFramingSawPatternPayload(((FramingSawMenu)this.menu).containerId, this.cache.getRecipes().get(((FramingSawMenu)this.menu).getSelectedRecipeIndex()).id(), (ItemStack[])Arrays.stream(this.encodingInputs).filter(stack -> !stack.isEmpty()).toArray(ItemStack[]::new)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public int getInputSlotX() {
        return this.leftPos + ((FramingSawMenu)this.menu).getSlot((int)0).x;
    }

    public int getInputSlotY(int slot) {
        return this.topPos + ((FramingSawMenu)this.menu).getSlot((int)slot).y;
    }

    public FramingSawWithEncoderMenu getMenu() {
        return (FramingSawWithEncoderMenu)super.getMenu();
    }
}

