/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import xfacthd.framedblocks.api.render.OutlineRenderer;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.render.util.FramedRenderTypes;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.NullableDirection;

public final class CollapsibleBlockIndicatorRenderer {
    private static final float[] VERTEX_NO_OFFSET = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public static void onRenderBlockHighlight(RenderHighlightEvent.Block event) {
        ItemStack heldItem = Minecraft.getInstance().player.getMainHandItem();
        if (heldItem.getItem() != FBContent.ITEM_FRAMED_HAMMER.value()) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        BlockHitResult hit = event.getTarget();
        BlockState state = level.getBlockState(hit.getBlockPos());
        if (state.getBlock() != FBContent.BLOCK_FRAMED_COLLAPSIBLE_BLOCK.value()) {
            return;
        }
        NullableDirection face = (NullableDirection)((Object)state.getValue(PropertyHolder.NULLABLE_FACE));
        Direction faceDir = hit.getDirection();
        if (face != NullableDirection.NONE && face.toDirection() != faceDir) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Vec3 offset = Vec3.atLowerCornerOf((Vec3i)hit.getBlockPos()).subtract(event.getCamera().getPosition());
        VertexConsumer builder = event.getMultiBufferSource().getBuffer(FramedRenderTypes.LINES_NO_DEPTH);
        poseStack.pushPose();
        poseStack.translate(offset.x + 0.5, offset.y + 0.5, offset.z + 0.5);
        if (faceDir == Direction.DOWN) {
            poseStack.mulPose(Quaternions.XP_180);
        } else if (faceDir != Direction.UP) {
            poseStack.mulPose(OutlineRenderer.YN_DIR[faceDir.get2DDataValue()]);
            poseStack.mulPose(Quaternions.XP_90);
        }
        poseStack.translate(-0.5, -0.5, -0.5);
        float[] vY = CollapsibleBlockIndicatorRenderer.getVertexHeights((Level)level, hit.getBlockPos(), face);
        CollapsibleBlockIndicatorRenderer.drawSectionOverlay(builder, poseStack, vY);
        CollapsibleBlockIndicatorRenderer.drawCornerMarkers(builder, poseStack, faceDir, hit, vY);
        poseStack.popPose();
        ((MultiBufferSource.BufferSource)event.getMultiBufferSource()).endBatch(FramedRenderTypes.LINES_NO_DEPTH);
    }

    private static float[] getVertexHeights(Level level, BlockPos pos, NullableDirection face) {
        BlockEntity blockEntity;
        if (face == NullableDirection.NONE || !((blockEntity = level.getBlockEntity(pos)) instanceof FramedCollapsibleBlockEntity)) {
            return VERTEX_NO_OFFSET;
        }
        FramedCollapsibleBlockEntity be = (FramedCollapsibleBlockEntity)blockEntity;
        return new float[]{1.0f - (float)be.getVertexOffset(0) / 16.0f, 1.0f - (float)be.getVertexOffset(1) / 16.0f, 1.0f - (float)be.getVertexOffset(2) / 16.0f, 1.0f - (float)be.getVertexOffset(3) / 16.0f};
    }

    private static void drawSectionOverlay(VertexConsumer builder, PoseStack poseStack, float[] vY) {
        float cenx = Mth.lerp((float)0.5f, (float)vY[0], (float)vY[1]);
        float cepx = Mth.lerp((float)0.5f, (float)vY[3], (float)vY[2]);
        float cenz = Mth.lerp((float)0.5f, (float)vY[0], (float)vY[3]);
        float cepz = Mth.lerp((float)0.5f, (float)vY[1], (float)vY[2]);
        float cinx = Mth.lerp((float)0.25f, (float)cenx, (float)cepx);
        float cipx = Mth.lerp((float)0.75f, (float)cenx, (float)cepx);
        float cinz = Mth.lerp((float)0.25f, (float)cenz, (float)cepz);
        float cipz = Mth.lerp((float)0.75f, (float)cenz, (float)cepz);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.5f, cenz, 0.0f, 0.5f, cinz, 0.25f);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.5f, cipz, 0.75f, 0.5f, cepz, 1.0f);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.0f, cenx, 0.5f, 0.25f, cinx, 0.5f);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.75f, cipx, 0.5f, 1.0f, cepx, 0.5f);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.5f, cinz, 0.25f, 0.25f, cinx, 0.5f);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.5f, cinz, 0.25f, 0.75f, cipx, 0.5f);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.5f, cipz, 0.75f, 0.25f, cinx, 0.5f);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, 0.5f, cipz, 0.75f, 0.75f, cipx, 0.5f);
    }

    private static void drawCornerMarkers(VertexConsumer builder, PoseStack poseStack, Direction faceDir, BlockHitResult hit, float[] vY) {
        int vert = FramedCollapsibleBlockEntity.vertexFromHit(faceDir, Utils.fraction(hit.getLocation()));
        if (vert == 0 || vert == 4) {
            CollapsibleBlockIndicatorRenderer.drawCubeFrame(builder, poseStack, 0.015625f, 0.015625f, vY[0]);
        }
        if (vert == 1 || vert == 4) {
            CollapsibleBlockIndicatorRenderer.drawCubeFrame(builder, poseStack, 0.015625f, 0.984375f, vY[1]);
        }
        if (vert == 2 || vert == 4) {
            CollapsibleBlockIndicatorRenderer.drawCubeFrame(builder, poseStack, 0.984375f, 0.984375f, vY[2]);
        }
        if (vert == 3 || vert == 4) {
            CollapsibleBlockIndicatorRenderer.drawCubeFrame(builder, poseStack, 0.984375f, 0.015625f, vY[3]);
        }
    }

    private static void drawCubeFrame(VertexConsumer builder, PoseStack poseStack, float x, float z, float vY) {
        float minX = x - 0.03125f;
        float maxX = x + 0.03125f;
        float minZ = z - 0.03125f;
        float maxZ = z + 0.03125f;
        float minY = vY - 0.046875f;
        float maxY = vY + 0.015625f;
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, minY, minZ, minX, minY, maxZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, minY, minZ, maxX, minY, minZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, maxX, minY, minZ, maxX, minY, maxZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, minY, maxZ, maxX, minY, maxZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, maxY, minZ, minX, maxY, maxZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, maxY, minZ, maxX, maxY, minZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, maxX, maxY, minZ, maxX, maxY, maxZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, maxY, maxZ, maxX, maxY, maxZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, minY, minZ, minX, maxY, minZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, minX, minY, maxZ, minX, maxY, maxZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, maxX, minY, minZ, maxX, maxY, minZ);
        CollapsibleBlockIndicatorRenderer.drawLine(builder, poseStack, maxX, minY, maxZ, maxX, maxY, maxZ);
    }

    private static void drawLine(VertexConsumer builder, PoseStack poseStack, float x1, float y1, float z1, float x2, float y2, float z2) {
        float nX = x2 - x1;
        float nY = y2 - y1;
        float nZ = z2 - z1;
        float nLen = Mth.sqrt((float)(nX * nX + nY * nY + nZ * nZ));
        PoseStack.Pose pose = poseStack.last();
        builder.addVertex(pose, x1, y1, z1).setColor(255, 0, 0, 153).setNormal(pose, nX /= nLen, nY /= nLen, nZ /= nLen);
        builder.addVertex(pose, x2, y2, z2).setColor(255, 0, 0, 153).setNormal(pose, nX, nY, nZ);
    }

    private CollapsibleBlockIndicatorRenderer() {
    }
}

