/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopeedge.modern;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.client.model.slopeedge.legacy.LegacyFramedThreewayCornerSlopeEdgeGeometry;
import xfacthd.framedblocks.common.config.ClientConfig;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedThreewayCornerSlopeEdgeGeometry
extends Geometry {
    private final Direction dir;
    private final boolean top;
    private final boolean right;
    private final boolean altType;
    private final boolean ySlope;

    private FramedThreewayCornerSlopeEdgeGeometry(GeometryFactory.Context ctx) {
        Direction dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
        this.right = (Boolean)ctx.state().getValue((Property)PropertyHolder.RIGHT);
        this.dir = this.right ? dir.getClockWise() : dir;
        this.altType = (Boolean)ctx.state().getValue((Property)PropertyHolder.ALT_TYPE);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction yBackFace;
        Direction quadDir = quad.getDirection();
        Direction direction = yBackFace = this.top ? Direction.UP : Direction.DOWN;
        if (this.altType) {
            if (quadDir == this.dir) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getCounterClockWise(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getCounterClockWise(), 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), this.top ? 1.5f : 0.5f, this.top ? 0.5f : 1.5f)).export(quadMap.get(quadDir));
            } else if (quadDir == this.dir.getCounterClockWise()) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), this.top ? 1.5f : 0.5f, this.top ? 0.5f : 1.5f)).export(quadMap.get(quadDir));
            } else if (quadDir == yBackFace) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getCounterClockWise(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f, 1.5f)).apply(Modifiers.cutTopBottom(this.dir.getCounterClockWise(), 0.5f)).export(quadMap.get(quadDir));
            } else if (quadDir == this.dir.getOpposite()) {
                if (!this.right) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), 0.25f)).apply(Modifiers.cutSideUpDown(this.top, 0.5f, 1.5f)).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).apply(Modifiers.offset(this.dir.getClockWise(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getCounterClockWise(), 0.25f)).apply(Modifiers.cutSideUpDown(this.top, 1.5f, 0.5f)).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
                }
                if (!this.ySlope) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.25f)).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), this.top ? 0.5f : 1.5f, this.top ? 1.5f : 0.5f)).apply(Modifiers.makeVerticalSlope(!this.top, 45.0f)).apply(Modifiers.offset(yBackFace.getOpposite(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.25f)).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), this.top ? 1.5f : 0.5f, this.top ? 0.5f : 1.5f)).apply(Modifiers.makeVerticalSlope(!this.top, 45.0f)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
                }
            } else if (quadDir == this.dir.getClockWise()) {
                if (this.right) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.25f)).apply(Modifiers.cutSideUpDown(this.top, 0.5f, 1.5f)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).apply(Modifiers.offset(this.dir.getClockWise(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.25f)).apply(Modifiers.cutSideUpDown(this.top, 1.5f, 0.5f)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
                }
                if (!this.ySlope) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.25f)).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), this.top ? 0.5f : 1.5f, this.top ? 1.5f : 0.5f)).apply(Modifiers.makeVerticalSlope(!this.top, 45.0f)).apply(Modifiers.offset(yBackFace.getOpposite(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.25f)).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), this.top ? 1.5f : 0.5f, this.top ? 0.5f : 1.5f)).apply(Modifiers.makeVerticalSlope(!this.top, 45.0f)).apply(Modifiers.offset(this.dir.getClockWise(), 0.5f)).export(quadMap.get(null));
                }
            } else if (this.ySlope && quadDir == yBackFace.getOpposite()) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.25f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f, 1.5f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).apply(Modifiers.offset(yBackFace.getOpposite(), 0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.25f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 1.5f, 0.5f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getCounterClockWise(), 0.25f)).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 1.5f, 0.5f)).apply(Modifiers.makeVerticalSlope(this.dir.getClockWise(), 45.0f)).apply(Modifiers.offset(yBackFace.getOpposite(), 0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.25f)).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f, 1.5f)).apply(Modifiers.makeVerticalSlope(this.dir.getClockWise(), 45.0f)).apply(Modifiers.offset(this.dir.getClockWise(), 0.5f)).export(quadMap.get(null));
            }
        } else if (quadDir == this.dir) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), this.top ? 0.5f : -0.5f, this.top ? -0.5f : 0.5f)).export(quadMap.get(quadDir));
        } else if (quadDir == this.dir.getCounterClockWise()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), this.top ? 0.5f : -0.5f, this.top ? -0.5f : 0.5f)).export(quadMap.get(quadDir));
        } else if (quadDir == yBackFace) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), -0.5f, 0.5f)).export(quadMap.get(quadDir));
        } else if (quadDir == this.dir.getOpposite()) {
            if (!this.right) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), 0.25f)).apply(Modifiers.cutSideUpDown(this.top, 0.0f, 1.0f)).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).apply(Modifiers.offset(this.dir, 0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getCounterClockWise(), 0.25f)).apply(Modifiers.cutSideUpDown(this.top, 1.0f, 0.0f)).apply(Modifiers.makeHorizontalSlope(false, 45.0f)).apply(Modifiers.offset(this.dir.getCounterClockWise(), 0.5f)).export(quadMap.get(null));
            }
            if (!this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.25f)).apply(Modifiers.cutSideLeftRight(false, this.top ? 0.0f : 1.0f, this.top ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(!this.top, 45.0f)).apply(Modifiers.offset(this.dir, 0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.25f)).apply(Modifiers.cutSideLeftRight(false, this.top ? 1.0f : 0.0f, this.top ? 0.0f : 1.0f)).apply(Modifiers.makeVerticalSlope(!this.top, 45.0f)).apply(Modifiers.offset(yBackFace, 0.5f)).export(quadMap.get(null));
            }
        } else if (quadDir == this.dir.getClockWise()) {
            if (this.right) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.25f)).apply(Modifiers.cutSideUpDown(this.top, 1.0f, 0.0f)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).apply(Modifiers.offset(this.dir.getCounterClockWise(), 0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.25f)).apply(Modifiers.cutSideUpDown(this.top, 0.0f, 1.0f)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).apply(Modifiers.offset(this.dir, 0.5f)).export(quadMap.get(null));
            }
            if (!this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.25f)).apply(Modifiers.cutSideLeftRight(true, this.top ? 0.0f : 1.0f, this.top ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(!this.top, 45.0f)).apply(Modifiers.offset(this.dir.getCounterClockWise(), 0.5f)).export(quadMap.get(null));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.25f)).apply(Modifiers.cutSideLeftRight(true, this.top ? 1.0f : 0.0f, this.top ? 0.0f : 1.0f)).apply(Modifiers.makeVerticalSlope(!this.top, 45.0f)).apply(Modifiers.offset(yBackFace, 0.5f)).export(quadMap.get(null));
            }
        } else if (this.ySlope && quadDir == yBackFace.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.25f)).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getClockWise(), 45.0f)).apply(Modifiers.offset(yBackFace, 0.5f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getCounterClockWise(), 0.25f)).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getClockWise(), 45.0f)).apply(Modifiers.offset(this.dir.getCounterClockWise(), 0.5f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.25f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).apply(Modifiers.offset(yBackFace, 0.5f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.25f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).apply(Modifiers.offset(this.dir, 0.5f)).export(quadMap.get(null));
        }
    }

    public static Geometry create(GeometryFactory.Context ctx) {
        if (ClientConfig.VIEW.useLegacySlopeEdgeModel()) {
            return new LegacyFramedThreewayCornerSlopeEdgeGeometry(ctx);
        }
        return new FramedThreewayCornerSlopeEdgeGeometry(ctx);
    }
}

