/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopeedge.modern;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.client.model.slopeedge.legacy.LegacyFramedElevatedInnerCornerSlopeEdgeGeometry;
import xfacthd.framedblocks.common.config.ClientConfig;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;

public class FramedElevatedInnerCornerSlopeEdgeGeometry
extends Geometry {
    private final Direction dir;
    private final CornerType type;
    private final boolean ySlope;

    private FramedElevatedInnerCornerSlopeEdgeGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.type = (CornerType)((Object)ctx.state().getValue(PropertyHolder.CORNER_TYPE));
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (this.type.isHorizontal()) {
            Direction yBackFace;
            boolean top = this.type.isTop();
            boolean right = this.type.isRight();
            Direction xBackFace = right ? this.dir.getClockWise() : this.dir.getCounterClockWise();
            Direction direction = yBackFace = top ? Direction.UP : Direction.DOWN;
            if (quadDir == this.dir.getOpposite()) {
                if (!this.ySlope) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!top, 0.25f)).apply(Modifiers.cutSideLeftRight(xBackFace, top ? 1.0f : 0.0f, top ? 0.0f : 1.0f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(top, 0.25f)).apply(Modifiers.cutSideLeftRight(xBackFace, top ? 0.5f : -0.5f, top ? -0.5f : 0.5f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).apply(Modifiers.offset(yBackFace.getOpposite(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(xBackFace, 0.25f)).apply(Modifiers.cutSideUpDown(!top, right ? 0.0f : 1.0f, right ? 1.0f : 0.0f)).apply(Modifiers.makeHorizontalSlope(right, 45.0f)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(xBackFace.getOpposite(), 0.25f)).apply(Modifiers.cutSideUpDown(!top, right ? -0.5f : 0.5f, right ? 0.5f : -0.5f)).apply(Modifiers.makeHorizontalSlope(right, 45.0f)).apply(Modifiers.offset(xBackFace.getOpposite(), 0.5f)).export(quadMap.get(null));
                }
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(top, 0.5f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!top, 0.5f)).apply(Modifiers.cutSideLeftRight(xBackFace.getOpposite(), 0.5f)).export(quadMap.get(quadDir));
            } else if (quadDir == xBackFace.getOpposite()) {
                if (this.ySlope) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.25f)).apply(Modifiers.cutSideUpDown(!top, right ? -0.5f : 0.5f, right ? 0.5f : -0.5f)).apply(Modifiers.makeHorizontalSlope(!right, 45.0f)).apply(Modifiers.offset(xBackFace.getOpposite(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.25f)).apply(Modifiers.cutSideUpDown(!top, right ? 0.0f : 1.0f, right ? 1.0f : 0.0f)).apply(Modifiers.makeHorizontalSlope(!right, 45.0f)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
                }
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), top ? 1.5f : 0.5f, top ? 0.5f : 1.5f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(top, 0.5f)).export(quadMap.get(quadDir));
            } else if (quadDir == yBackFace.getOpposite()) {
                if (this.ySlope) {
                    QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.25f)).apply(Modifiers.cutTopBottom(xBackFace, right ? 0.5f : -0.5f, right ? -0.5f : 0.5f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).apply(Modifiers.offset(yBackFace.getOpposite(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.25f)).apply(Modifiers.cutTopBottom(xBackFace, right ? 1.0f : 0.0f, right ? 0.0f : 1.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
                }
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(xBackFace, 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), right ? 0.5f : 1.5f, right ? 1.5f : 0.5f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(xBackFace.getOpposite(), 0.5f)).export(quadMap.get(quadDir));
            }
        } else {
            Direction topDir;
            boolean top = this.type == CornerType.TOP;
            Direction direction = topDir = top ? Direction.DOWN : Direction.UP;
            if (quadDir == this.dir.getOpposite()) {
                if (!this.ySlope) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!top, 0.25f)).apply(Modifiers.cutSideLeftRight(this.dir.getCounterClockWise(), top ? -0.5f : 0.5f, top ? 0.5f : -0.5f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(top, 0.25f)).apply(Modifiers.cutSideLeftRight(this.dir.getCounterClockWise(), top ? 0.0f : 1.0f, top ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).apply(Modifiers.offset(topDir, 0.5f)).export(quadMap.get(null));
                }
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), top ? 1.5f : 0.5f, top ? 0.5f : 1.5f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(top, 0.5f)).export(quadMap.get(quadDir));
            } else if (quadDir == this.dir.getClockWise()) {
                if (!this.ySlope) {
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!top, 0.25f)).apply(Modifiers.cutSideLeftRight(this.dir, top ? -0.5f : 0.5f, top ? 0.5f : -0.5f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).apply(Modifiers.offset(this.dir.getClockWise(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(top, 0.25f)).apply(Modifiers.cutSideLeftRight(this.dir, top ? 0.0f : 1.0f, top ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).apply(Modifiers.offset(topDir, 0.5f)).export(quadMap.get(null));
                }
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), top ? 1.5f : 0.5f, top ? 0.5f : 1.5f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(top, 0.5f)).export(quadMap.get(quadDir));
            } else if (quadDir == topDir) {
                if (this.ySlope) {
                    QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getCounterClockWise(), 0.25f)).apply(Modifiers.cutTopBottom(this.dir, 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getClockWise(), 45.0f)).apply(Modifiers.offset(topDir, 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.25f)).apply(Modifiers.cutTopBottom(this.dir, -0.5f, 0.5f)).apply(Modifiers.makeVerticalSlope(this.dir.getClockWise(), 45.0f)).apply(Modifiers.offset(this.dir.getClockWise(), 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.25f)).apply(Modifiers.cutTopBottom(this.dir.getCounterClockWise(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).apply(Modifiers.offset(topDir, 0.5f)).export(quadMap.get(null));
                    QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.25f)).apply(Modifiers.cutTopBottom(this.dir.getCounterClockWise(), 0.5f, -0.5f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).apply(Modifiers.offset(this.dir.getOpposite(), 0.5f)).export(quadMap.get(null));
                }
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f)).export(quadMap.get(quadDir));
            }
        }
    }

    public static Geometry create(GeometryFactory.Context ctx) {
        if (ClientConfig.VIEW.useLegacySlopeEdgeModel()) {
            return new LegacyFramedElevatedInnerCornerSlopeEdgeGeometry(ctx);
        }
        return new FramedElevatedInnerCornerSlopeEdgeGeometry(ctx);
    }
}

