/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slab;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;

public class FramedMasonryCornerSegmentGeometry
extends Geometry {
    private final Direction dir;
    private final boolean top;

    public FramedMasonryCornerSegmentGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (!this.top && quadDir == Direction.UP || this.top && quadDir == Direction.DOWN) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getCounterClockWise(), 0.5f)).export(quadMap.get(quadDir));
        } else if (!this.top && quadDir == Direction.DOWN || this.top && quadDir == Direction.UP) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getCounterClockWise(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).export(quadMap.get(quadDir));
        } else if (quadDir.getAxis() == this.dir.getAxis()) {
            boolean inDir = quadDir == this.dir;
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).applyIf(Modifiers.setPosition(0.5f), inDir).export(quadMap.get(inDir ? null : quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir.getCounterClockWise(), 0.5f)).export(quadMap.get(quadDir));
        } else if (quadDir.getAxis() == this.dir.getClockWise().getAxis()) {
            boolean inDir = quadDir == this.dir.getCounterClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(!this.top, 0.5f)).applyIf(Modifiers.setPosition(0.5f), inDir).export(quadMap.get(inDir ? null : quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.top, 0.5f)).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).export(quadMap.get(quadDir));
        }
    }
}

