/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pillar;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedFenceGeometry
extends Geometry {
    private final boolean north;
    private final boolean east;
    private final boolean south;
    private final boolean west;

    public FramedFenceGeometry(GeometryFactory.Context ctx) {
        this.north = (Boolean)ctx.state().getValue((Property)BlockStateProperties.NORTH);
        this.east = (Boolean)ctx.state().getValue((Property)BlockStateProperties.EAST);
        this.south = (Boolean)ctx.state().getValue((Property)BlockStateProperties.SOUTH);
        this.west = (Boolean)ctx.state().getValue((Property)BlockStateProperties.WEST);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.375f, 0.375f, 0.625f, 0.625f)).export(quadMap.get(quadDir));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(quadDir.getClockWise(), 0.625f)).apply(Modifiers.cutSideLeftRight(quadDir.getCounterClockWise(), 0.625f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
        }
        FramedFenceGeometry.createFenceBars(quadMap, quad, Direction.NORTH, this.north);
        FramedFenceGeometry.createFenceBars(quadMap, quad, Direction.EAST, this.east);
        FramedFenceGeometry.createFenceBars(quadMap, quad, Direction.SOUTH, this.south);
        FramedFenceGeometry.createFenceBars(quadMap, quad, Direction.WEST, this.west);
    }

    private static void createFenceBars(QuadMap quadMap, BakedQuad quad, Direction dir, boolean active) {
        if (!active) {
            return;
        }
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            QuadModifier mod = QuadModifier.of(quad).apply(Modifiers.cutTopBottom(dir.getOpposite(), 0.375f)).apply(Modifiers.cutTopBottom(dir.getClockWise(), 0.5625f)).apply(Modifiers.cutTopBottom(dir.getCounterClockWise(), 0.5625f));
            mod.derive().apply(Modifiers.setPosition(quadDir == Direction.UP ? 0.9375f : 0.25f)).export(quadMap.get(null));
            mod.apply(Modifiers.setPosition(quadDir == Direction.UP ? 0.5625f : 0.625f)).export(quadMap.get(null));
        } else if (quadDir == dir.getClockWise() || quadDir == dir.getCounterClockWise()) {
            boolean neg = !Utils.isPositive(dir);
            QuadModifier.of(quad).apply(Modifiers.cutSide(neg ? 0.0f : 0.625f, 0.375f, neg ? 0.375f : 1.0f, 0.5625f)).apply(Modifiers.setPosition(0.5625f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutSide(neg ? 0.0f : 0.625f, 0.75f, neg ? 0.375f : 1.0f, 0.9375f)).apply(Modifiers.setPosition(0.5625f)).export(quadMap.get(null));
        } else if (quadDir == dir) {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.4375f, 0.375f, 0.5625f, 0.5625f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.4375f, 0.75f, 0.5625f, 0.9375f)).export(quadMap.get(quadDir));
        }
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }
}

