/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedTubeGeometry
extends Geometry {
    private final Direction.Axis axis;

    public FramedTubeGeometry(GeometryFactory.Context ctx) {
        this.axis = (Direction.Axis)ctx.state().getValue((Property)BlockStateProperties.AXIS);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (this.axis == Direction.Axis.Y) {
            if (quadDir.getAxis() == this.axis) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.NORTH, 0.125f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.SOUTH, 0.125f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.EAST, 0.125f)).apply(Modifiers.cutTopBottom(Direction.Axis.Z, 0.875f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.WEST, 0.125f)).apply(Modifiers.cutTopBottom(Direction.Axis.Z, 0.875f)).export(quadMap.get(quadDir));
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(0.875f)).apply(Modifiers.setPosition(0.125f)).export(quadMap.get(null));
            }
        } else if (quadDir.getAxis() == this.axis) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.125f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.125f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(quadDir.getClockWise(), 0.125f)).apply(Modifiers.cutSideUpDown(0.875f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(quadDir.getCounterClockWise(), 0.125f)).apply(Modifiers.cutSideUpDown(0.875f)).export(quadMap.get(quadDir));
        } else if (Utils.isY(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Utils.nextAxisNotEqualTo(this.axis, Direction.Axis.Y), 0.875f)).apply(Modifiers.setPosition(0.125f)).export(quadMap.get(null));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(0.875f)).apply(Modifiers.setPosition(0.125f)).export(quadMap.get(null));
        }
    }

    @Override
    public boolean transformAllQuads() {
        return true;
    }
}

