/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.test;

import com.mojang.logging.LogUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.gametest.framework.GameTestAssertPosException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.common.CommonHooks;
import org.slf4j.Logger;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.block.render.FramedBlockRenderProperties;
import xfacthd.framedblocks.api.test.TestDelay;
import xfacthd.framedblocks.api.test.TestRunnable;
import xfacthd.framedblocks.api.util.ConfigView;
import xfacthd.framedblocks.api.util.Utils;

public final class TestUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final BlockPos OCCLUSION_BLOCK_TOP_BOTTOM = new BlockPos(1, 3, 1);
    private static final BlockPos OCCLUSION_BLOCK_SIDE = new BlockPos(1, 2, 2);
    private static final BlockPos OCCLUSION_LIGHT_TOP = new BlockPos(1, 4, 1);
    private static final BlockPos OCCLUSION_LIGHT_BOTTOM = new BlockPos(1, 2, 1);
    private static final BlockPos OCCLUSION_LIGHT_SIDE = new BlockPos(1, 2, 3);
    private static final BlockPos EMISSION_BLOCK = new BlockPos(1, 2, 1);
    private static final BlockPos EMISSION_LIGHT = new BlockPos(1, 3, 1);
    private static final BlockPos INTANGIBILITY_BLOCK = new BlockPos(0, 2, 0);
    private static final BlockPos BEACON_TINT_BLOCK = new BlockPos(0, 2, 0);
    private static final BlockPos BEACON_TINT_BEACON = new BlockPos(0, 0, 0);
    private static final Predicate<Integer> BEACON_PREDICATE_RED = color -> Objects.equals(color, DyeColor.RED.getTextureDiffuseColor());
    private static final String BEACON_COLOR_TEXT_RED = Objects.toString(DyeColor.RED.getTextureDiffuseColor());

    public static boolean assertFramedBlock(GameTestHelper helper, Block block) {
        if (!(block instanceof IFramedBlock)) {
            helper.fail(String.format("Expected instance of IFramedBlock, got %s", BuiltInRegistries.BLOCK.getKey((Object)block)));
            return false;
        }
        return true;
    }

    public static void applyCamo(GameTestHelper helper, BlockPos pos, Block camo, List<Direction> camoSides) {
        LinkedHashMap<Direction, Block> camos = new LinkedHashMap<Direction, Block>();
        camoSides.forEach(side -> camos.put((Direction)side, camo));
        TestUtils.applyCamo(helper, pos, camos);
    }

    public static void applyCamo(GameTestHelper helper, BlockPos pos, Map<Direction, Block> camos) {
        BlockPos absPos = helper.absolutePos(pos);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        int count = 0;
        for (Map.Entry<Direction, Block> entry : camos.entrySet()) {
            Direction side = entry.getKey();
            Block camo = entry.getValue();
            BlockState state = helper.getBlockState(pos);
            Item item = camo == Blocks.AIR ? (Item)Utils.FRAMED_HAMMER.value() : camo.asItem();
            ItemStack stack = new ItemStack((ItemLike)item);
            player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            player.setPos(absPos.relative(side, 2).below().getBottomCenter());
            player.lookAt(EntityAnchorArgument.Anchor.EYES, absPos.getCenter());
            VoxelShape shape = state.getShape((BlockGetter)helper.getLevel(), absPos);
            Vec3 start = player.getEyePosition();
            Vec3 end = start.add(player.getViewVector(1.0f).scale(5.0));
            BlockHitResult hit = shape.clip(start, end, absPos);
            if (hit == null) {
                helper.fail(String.format("Camo application on side '%s' of block '%s' failed", side, state), pos);
                return;
            }
            Vec3i normal = side.getNormal();
            Vec3 hitVec = switch (count) {
                case 0 -> hit.getLocation().add(-0.1 * (double)(1 - Math.abs(normal.getX())), -0.1 * (double)(1 - Math.abs(normal.getY())), -0.1 * (double)(1 - Math.abs(normal.getZ())));
                case 1 -> hit.getLocation().add(0.1 * (double)(1 - Math.abs(normal.getX())), 0.1 * (double)(1 - Math.abs(normal.getY())), 0.1 * (double)(1 - Math.abs(normal.getZ())));
                default -> hit.getLocation();
            };
            ItemInteractionResult result = helper.getBlockState(pos).useItemOn(stack, (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(hitVec, hit.getDirection(), hit.getBlockPos(), hit.isInside()));
            ++count;
            if (result.consumesAction()) continue;
            helper.fail(String.format("Camo application on side '%s' of block '%s' failed with result '%s'", side, state, result), pos);
        }
    }

    public static void clickWithItem(GameTestHelper helper, BlockPos pos, ItemLike item) {
        TestUtils.clickWithItem(helper, pos, item, Direction.UP, false);
    }

    public static void clickWithItem(GameTestHelper helper, BlockPos pos, ItemLike item, boolean sneak) {
        TestUtils.clickWithItem(helper, pos, item, Direction.UP, sneak);
    }

    public static void clickWithItem(GameTestHelper helper, BlockPos pos, ItemLike item, Direction side) {
        TestUtils.clickWithItem(helper, pos, item, side, false);
    }

    public static void clickWithItem(GameTestHelper helper, BlockPos pos, ItemLike item, Direction side, boolean sneak) {
        BlockPos absPos = helper.absolutePos(pos);
        BlockState state = helper.getBlockState(pos);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setPos(absPos.relative(side).getCenter());
        player.setShiftKeyDown(sneak);
        ItemStack stack = new ItemStack(item);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack(item));
        player.setPos(absPos.relative(side, 2).below().getBottomCenter());
        player.lookAt(EntityAnchorArgument.Anchor.EYES, absPos.getCenter());
        VoxelShape shape = state.getShape((BlockGetter)helper.getLevel(), absPos);
        Vec3 start = player.getEyePosition();
        Vec3 end = start.add(player.getViewVector(1.0f).scale(5.0));
        BlockHitResult hit = shape.clip(start, end, absPos);
        if (hit == null) {
            helper.fail(String.format("Interaction with block '%s' on side '%s' failed", helper.getBlockState(pos), side), pos);
            return;
        }
        ItemInteractionResult result = helper.getBlockState(pos).useItemOn(stack, (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, hit);
        if (!result.consumesAction()) {
            helper.fail(String.format("Interaction with block '%s' on side '%s' failed with result '%s'", helper.getBlockState(pos), side, result), pos);
        }
    }

    public static void attackWithItem(GameTestHelper helper, BlockPos pos, ItemLike item) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack(item));
        CommonHooks.onLeftClickBlock((Player)player, (BlockPos)helper.absolutePos(pos), (Direction)Direction.UP, (ServerboundPlayerActionPacket.Action)ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK);
    }

    public static int chainTasks(GameTestHelper helper, List<TestRunnable> tasks) {
        return TestUtils.chainTasks(helper, tasks, 0);
    }

    public static int chainTasks(GameTestHelper helper, List<TestRunnable> tasks, int initialDelay) {
        int delay = initialDelay;
        for (TestRunnable task : tasks) {
            helper.runAfterDelay((long)delay, (Runnable)task);
            delay += task.getDuration();
        }
        return delay;
    }

    public static <T extends BlockEntity> T getBlockEntity(GameTestHelper helper, BlockPos relPos, Class<T> beClass) {
        BlockEntity be = helper.getBlockEntity(relPos);
        if (!beClass.isInstance(be)) {
            throw new GameTestAssertPosException(String.format("Expected %s, got %s", beClass.getSimpleName(), be.getClass().getSimpleName()), helper.absolutePos(relPos), relPos, helper.getTick());
        }
        return (T)((BlockEntity)beClass.cast(be));
    }

    public static void assertTrue(GameTestHelper helper, BlockPos relPos, boolean value, Supplier<String> message) {
        if (!value) {
            throw new GameTestAssertPosException(message.get(), helper.absolutePos(relPos), relPos, helper.getTick());
        }
    }

    public static void spawnItemCentered(GameTestHelper helper, Item item, BlockPos relPos) {
        helper.spawnItem(item, (float)relPos.getX() + 0.5f, (float)relPos.getY(), (float)relPos.getZ() + 0.5f);
    }

    public static boolean assertCanOcclude(GameTestHelper helper, Block block) {
        if (!TestUtils.assertFramedBlock(helper, block)) {
            return false;
        }
        if (!((IFramedBlock)block).getBlockType().canOccludeWithSolidCamo()) {
            helper.fail(String.format("Block %s can not occlude with a solid camo", BuiltInRegistries.BLOCK.getKey((Object)block)));
            return false;
        }
        return true;
    }

    public static void testBlockOccludesLightBelow(GameTestHelper helper, BlockState state) {
        TestUtils.testBlockOccludesLight(helper, OCCLUSION_BLOCK_TOP_BOTTOM, OCCLUSION_LIGHT_TOP, state, List.of(Direction.UP));
    }

    public static void testBlockOccludesLightAbove(GameTestHelper helper, BlockState state) {
        TestUtils.testBlockOccludesLight(helper, OCCLUSION_BLOCK_TOP_BOTTOM, OCCLUSION_LIGHT_BOTTOM, state, List.of(Direction.DOWN));
    }

    public static void testBlockOccludesLightNorth(GameTestHelper helper, BlockState state) {
        TestUtils.testBlockOccludesLight(helper, OCCLUSION_BLOCK_SIDE, OCCLUSION_LIGHT_SIDE, state, List.of(Direction.SOUTH));
    }

    public static void testDoubleBlockOccludesLightBelow(GameTestHelper helper, BlockState state, List<Direction> camoSides) {
        TestUtils.testBlockOccludesLight(helper, OCCLUSION_BLOCK_TOP_BOTTOM, OCCLUSION_LIGHT_TOP, state, camoSides);
    }

    public static void testDoubleBlockOccludesLightAbove(GameTestHelper helper, BlockState state, List<Direction> camoSides) {
        TestUtils.testBlockOccludesLight(helper, OCCLUSION_BLOCK_TOP_BOTTOM, OCCLUSION_LIGHT_BOTTOM, state, camoSides);
    }

    public static void testDoubleBlockOccludesLightNorth(GameTestHelper helper, BlockState state, List<Direction> camoSides) {
        TestUtils.testBlockOccludesLight(helper, OCCLUSION_BLOCK_SIDE, OCCLUSION_LIGHT_SIDE, state, camoSides);
    }

    private static void testBlockOccludesLight(GameTestHelper helper, BlockPos blockPos, BlockPos lightPos, BlockState state, List<Direction> camoSides) {
        if (!TestUtils.assertCanOcclude(helper, state.getBlock())) {
            return;
        }
        helper.assertBlockPresent(Blocks.AIR, blockPos);
        helper.assertBlockPresent(Blocks.GLASS, lightPos);
        TestRunnable[] testRunnableArray = new TestRunnable[11];
        testRunnableArray[0] = () -> helper.setBlock(blockPos, state);
        testRunnableArray[1] = new TestDelay(5);
        testRunnableArray[2] = () -> {
            helper.assertBlockProperty(blockPos, (Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false));
            TestUtils.assertBlockLight(helper, blockPos, lightPos, 13);
        };
        testRunnableArray[3] = () -> TestUtils.applyCamo(helper, blockPos, Blocks.GLASS, camoSides);
        testRunnableArray[4] = new TestDelay(5);
        testRunnableArray[5] = () -> {
            helper.assertBlockProperty(blockPos, (Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false));
            TestUtils.assertBlockLight(helper, blockPos, lightPos, 13);
        };
        testRunnableArray[6] = () -> TestUtils.applyCamo(helper, blockPos, Blocks.AIR, camoSides);
        testRunnableArray[7] = () -> TestUtils.applyCamo(helper, blockPos, Blocks.GRANITE, camoSides);
        testRunnableArray[8] = new TestDelay(5);
        testRunnableArray[9] = () -> {
            helper.assertBlockProperty(blockPos, (Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(true));
            TestUtils.assertBlockLight(helper, blockPos, lightPos, 0);
        };
        testRunnableArray[10] = () -> ((GameTestHelper)helper).succeed();
        TestUtils.chainTasks(helper, List.of(testRunnableArray));
    }

    public static void testBlockLightEmission(GameTestHelper helper, BlockState state, List<Direction> camoSides) {
        TestUtils.testBlockLightEmission(helper, state, camoSides, 0);
    }

    public static void testBlockLightEmission(GameTestHelper helper, BlockState state, List<Direction> camoSides, int baseEmission) {
        int glowstoneLight = Blocks.GLOWSTONE.defaultBlockState().getLightEmission();
        TestRunnable[] testRunnableArray = new TestRunnable[24];
        testRunnableArray[0] = () -> helper.setBlock(EMISSION_BLOCK, state);
        testRunnableArray[1] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, baseEmission);
        testRunnableArray[2] = () -> TestUtils.applyCamo(helper, EMISSION_BLOCK, Blocks.GLOWSTONE, camoSides);
        testRunnableArray[3] = new TestDelay(5);
        testRunnableArray[4] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, glowstoneLight);
        testRunnableArray[5] = () -> TestUtils.applyCamo(helper, EMISSION_BLOCK, Blocks.AIR, camoSides);
        testRunnableArray[6] = new TestDelay(5);
        testRunnableArray[7] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, baseEmission);
        testRunnableArray[8] = () -> TestUtils.clickWithItem(helper, EMISSION_BLOCK, (ItemLike)Items.GLOWSTONE_DUST);
        testRunnableArray[9] = new TestDelay(5);
        testRunnableArray[10] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, 15);
        testRunnableArray[11] = () -> TestUtils.applyCamo(helper, EMISSION_BLOCK, Blocks.GLASS, camoSides);
        testRunnableArray[12] = new TestDelay(5);
        testRunnableArray[13] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, 15);
        testRunnableArray[14] = () -> TestUtils.applyCamo(helper, EMISSION_BLOCK, Blocks.AIR, camoSides);
        testRunnableArray[15] = new TestDelay(5);
        testRunnableArray[16] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, 15);
        testRunnableArray[17] = () -> TestUtils.applyCamo(helper, EMISSION_BLOCK, Blocks.GRANITE, camoSides);
        testRunnableArray[18] = new TestDelay(5);
        testRunnableArray[19] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, 15);
        testRunnableArray[20] = () -> TestUtils.applyCamo(helper, EMISSION_BLOCK, Blocks.AIR, camoSides);
        testRunnableArray[21] = new TestDelay(5);
        testRunnableArray[22] = () -> TestUtils.assertBlockLightEmission(helper, EMISSION_BLOCK, EMISSION_LIGHT, 15);
        testRunnableArray[23] = () -> ((GameTestHelper)helper).succeed();
        TestUtils.chainTasks(helper, List.of(testRunnableArray));
    }

    public static void assertBlockLightEmission(GameTestHelper helper, BlockPos blockPos, BlockPos lightPos, int light) {
        int emission = helper.getLevel().getLightEmission(helper.absolutePos(blockPos));
        if (emission != light) {
            BlockState state = helper.getBlockState(blockPos);
            throw new GameTestAssertPosException(String.format("Incorrect light emission for %s, expected %d, got %d", state, light, emission), helper.absolutePos(lightPos), lightPos, helper.getTick());
        }
        TestUtils.assertBlockLight(helper, blockPos, lightPos, Math.max(light - 1, 0));
    }

    private static void assertBlockLight(GameTestHelper helper, BlockPos blockPos, BlockPos lightPos, int light) {
        int actualLight = helper.getLevel().getLightEngine().getRawBrightness(helper.absolutePos(lightPos), 15);
        if (actualLight != light) {
            BlockState state = helper.getBlockState(blockPos);
            throw new GameTestAssertPosException(String.format("Incorrect light level for %s, expected %d, got %d", state, light, actualLight), helper.absolutePos(lightPos), lightPos, helper.getTick());
        }
    }

    public static void testBlockIntangibility(GameTestHelper helper, BlockState state) {
        if (!ConfigView.Server.INSTANCE.enableIntangibility()) {
            helper.fail("Intangibility is not enabled in the ServerConfig");
        }
        TestUtils.chainTasks(helper, List.of(() -> helper.setBlock(INTANGIBILITY_BLOCK, state), () -> {
            FramedBlockEntity be = TestUtils.getBlockEntity(helper, INTANGIBILITY_BLOCK, FramedBlockEntity.class);
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, !be.isIntangible(CollisionContext.empty()), () -> String.format("Block '%s' is intangible without interaction", state.getBlock()));
            BlockPos pos = helper.absolutePos(INTANGIBILITY_BLOCK);
            BlockState currState = helper.getBlockState(INTANGIBILITY_BLOCK);
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, !currState.getShape((BlockGetter)helper.getLevel(), pos, CollisionContext.empty()).isEmpty(), () -> String.format("Block '%s' returns an empty shape when not intangible", state.getBlock()));
        }, () -> TestUtils.clickWithItem(helper, INTANGIBILITY_BLOCK, (ItemLike)Utils.PHANTOM_PASTE.value()), () -> {
            FramedBlockEntity be = TestUtils.getBlockEntity(helper, INTANGIBILITY_BLOCK, FramedBlockEntity.class);
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, be.isIntangible(CollisionContext.empty()), () -> String.format("Block '%s' is not intangible after interaction", state.getBlock()));
            BlockPos pos = helper.absolutePos(INTANGIBILITY_BLOCK);
            BlockState currState = helper.getBlockState(INTANGIBILITY_BLOCK);
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, currState.getShape((BlockGetter)helper.getLevel(), pos, CollisionContext.empty()).isEmpty(), () -> String.format("Block '%s' does not return an empty shape when intangible", state.getBlock()));
            Player player = helper.makeMockPlayer(GameType.SURVIVAL);
            CollisionContext ctx = CollisionContext.of((Entity)player);
            BuiltInRegistries.ITEM.getTag(Utils.DISABLE_INTANGIBLE).stream().flatMap(HolderSet::stream).forEach(item -> {
                player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack(item));
                TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, !be.isIntangible(ctx), () -> String.format("Block '%s' is intangible when targetted by item '%s' which is tagged with 'framedblocks:disable_intangible'", state.getBlock(), item));
                TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, !currState.getShape((BlockGetter)helper.getLevel(), pos, ctx).isEmpty(), () -> String.format("Block '%s' is intangible when targetted by item '%s' which is tagged with 'framedblocks:disable_intangible'", state.getBlock(), item));
            });
            if (FMLEnvironment.dist.isClient()) {
                ClientGuard.testHasParticleOverride(helper, state);
            } else {
                LOGGER.warn("Can't test particle override of block '{}', running on dedicated server", (Object)state.getBlock());
            }
        }, () -> TestUtils.clickWithItem(helper, INTANGIBILITY_BLOCK, (ItemLike)Utils.FRAMED_SCREWDRIVER.value(), true), () -> {
            FramedBlockEntity be = TestUtils.getBlockEntity(helper, INTANGIBILITY_BLOCK, FramedBlockEntity.class);
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, !be.isIntangible(CollisionContext.empty()), () -> String.format("Block '%s' is intangible after removing marker", state.getBlock()));
            BlockPos pos = helper.absolutePos(INTANGIBILITY_BLOCK);
            BlockState currState = helper.getBlockState(INTANGIBILITY_BLOCK);
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, !currState.getShape((BlockGetter)helper.getLevel(), pos, CollisionContext.empty()).isEmpty(), () -> String.format("Block '%s' does returns an empty shape after removing marker", state.getBlock()));
        }, () -> ((GameTestHelper)helper).succeed()));
    }

    public static void testBeaconBeamTinting(GameTestHelper helper, BlockState state, List<Direction> camoSides) {
        TestUtils.chainTasks(helper, List.of(() -> helper.setBlock(BEACON_TINT_BLOCK, state), () -> TestUtils.assertBeaconTint(helper, Blocks.AIR, Objects::isNull, "null"), () -> TestUtils.applyCamo(helper, BEACON_TINT_BLOCK, Blocks.RED_STAINED_GLASS, camoSides), () -> TestUtils.assertBeaconTint(helper, Blocks.RED_STAINED_GLASS, BEACON_PREDICATE_RED, BEACON_COLOR_TEXT_RED), () -> ((GameTestHelper)helper).succeed()));
    }

    private static void assertBeaconTint(GameTestHelper helper, Block camo, Predicate<Integer> predicate, String expected) {
        BlockState state = helper.getBlockState(BEACON_TINT_BLOCK);
        TestUtils.assertFramedBlock(helper, state.getBlock());
        Integer tint = state.getBeaconColorMultiplier((LevelReader)helper.getLevel(), helper.absolutePos(BEACON_TINT_BLOCK), helper.absolutePos(BEACON_TINT_BEACON));
        TestUtils.assertTrue(helper, BEACON_TINT_BLOCK, predicate.test(tint), () -> String.format("Block '%s' applies incorrect beacon color multiplier for camo '%s', expected %s, got %s", state.getBlock(), camo, expected, tint));
    }

    private TestUtils() {
    }

    private static final class ClientGuard {
        private ClientGuard() {
        }

        public static void testHasParticleOverride(GameTestHelper helper, BlockState state) {
            IClientBlockExtensions blockExt = IClientBlockExtensions.of((BlockState)state);
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, blockExt instanceof FramedBlockRenderProperties, () -> String.format("Block '%s' doesn't have required IClientBlockExtensions", state.getBlock()));
            BlockPos pos = helper.absolutePos(INTANGIBILITY_BLOCK);
            BlockHitResult miss = BlockHitResult.miss((Vec3)Vec3.ZERO, (Direction)Direction.UP, (BlockPos)pos);
            boolean hit = false;
            boolean destroy = false;
            try {
                ParticleEngine engine = Minecraft.getInstance().particleEngine;
                hit = blockExt.addHitEffects(state, (Level)helper.getLevel(), (HitResult)miss, engine);
                destroy = blockExt.addDestroyEffects(state, (Level)helper.getLevel(), pos, engine);
            }
            catch (Throwable e) {
                helper.fail(String.format("Error while testing particle overrides, likely caused by a misconfigured particle override:\n%s", e));
            }
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, hit, () -> String.format("Block '%s' doesn't handle hit particles", state.getBlock()));
            TestUtils.assertTrue(helper, INTANGIBILITY_BLOCK, destroy, () -> String.format("Block '%s' doesn't handle destroy particles", state.getBlock()));
        }
    }
}

