/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.blueprint;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import xfacthd.framedblocks.api.blueprint.AuxBlueprintData;
import xfacthd.framedblocks.api.util.CamoList;

public record BlueprintData(Block block, CamoList camos, boolean glowing, boolean intangible, boolean reinforced, Optional<AuxBlueprintData<?>> auxData) {
    public static final Codec<BlueprintData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(BlueprintData::block), (App)CamoList.CODEC.fieldOf("camos").forGetter(BlueprintData::camos), (App)Codec.BOOL.fieldOf("glowing").forGetter(BlueprintData::glowing), (App)Codec.BOOL.fieldOf("intangible").forGetter(BlueprintData::intangible), (App)Codec.BOOL.fieldOf("reinforced").forGetter(BlueprintData::reinforced), (App)AuxBlueprintData.CODEC.optionalFieldOf("aux_data").forGetter(BlueprintData::auxData)).apply((Applicative)inst, BlueprintData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlueprintData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK), BlueprintData::block, CamoList.STREAM_CODEC, BlueprintData::camos, (StreamCodec)ByteBufCodecs.BOOL, BlueprintData::glowing, (StreamCodec)ByteBufCodecs.BOOL, BlueprintData::intangible, (StreamCodec)ByteBufCodecs.BOOL, BlueprintData::reinforced, (StreamCodec)ByteBufCodecs.optional(AuxBlueprintData.STREAM_CODEC), BlueprintData::auxData, BlueprintData::new);
    public static final BlueprintData EMPTY = new BlueprintData(Blocks.AIR, CamoList.EMPTY, false, false, false, Optional.empty());

    public <T extends AuxBlueprintData<T>> T getAuxDataOrDefault(T _default) {
        if (this.auxData.isPresent() && _default.type() == this.auxData.get().type()) {
            return (T)this.auxData.get();
        }
        return _default;
    }

    public boolean isEmpty() {
        return this.block.defaultBlockState().isAir();
    }

    public BlueprintData withAuxData(AuxBlueprintData<?> newAuxData) {
        return new BlueprintData(this.block, this.camos, this.glowing, this.intangible, this.reinforced, Optional.of(newAuxData));
    }
}

