/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block.blockentity;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.cache.StateCache;
import xfacthd.framedblocks.api.block.render.CullingHelper;
import xfacthd.framedblocks.api.blueprint.AuxBlueprintData;
import xfacthd.framedblocks.api.blueprint.BlueprintData;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContainerFactory;
import xfacthd.framedblocks.api.camo.CamoContainerHelper;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.camo.empty.EmptyCamoContainer;
import xfacthd.framedblocks.api.component.FrameConfig;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.api.util.ConfigView;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.registration.DeferredBlockEntity;

public class FramedBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DeferredBlockEntity<FramedBlockEntity> DEFAULT_TYPE = DeferredBlockEntity.createBlockEntity(Utils.rl("framed_tile"));
    public static final Component MSG_BLACKLISTED = Utils.translate("msg", "camo.blacklisted");
    public static final Component MSG_BLOCK_ENTITY = Utils.translate("msg", "camo.block_entity");
    public static final Component MSG_NON_SOLID = Utils.translate("msg", "camo.non_solid");
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final int DATA_VERSION = 3;
    protected static final int FLAG_GLOWING = 1;
    protected static final int FLAG_INTANGIBLE = 2;
    protected static final int FLAG_REINFORCED = 4;
    private final boolean[] culledFaces = new boolean[6];
    private StateCache stateCache;
    private CamoContainer<?, ?> camoContainer = EmptyCamoContainer.EMPTY;
    private boolean glowing = false;
    private boolean intangible = false;
    private boolean reinforced = false;
    private boolean recheckStates = false;
    private boolean forceLightUpdate = false;
    private boolean cullStateDirty = false;

    @ApiStatus.Internal
    public FramedBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)DEFAULT_TYPE.value(), pos, state);
    }

    public FramedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.stateCache = ((IFramedBlock)state.getBlock()).getCache(state);
    }

    public final ItemInteractionResult handleInteraction(Player player, InteractionHand hand, BlockHitResult hit) {
        CamoContainerFactory<?> camoFactory;
        ItemStack stack = player.getItemInHand(hand);
        boolean secondary = this.hitSecondary(hit, player);
        CamoContainer<?, ?> camo = this.getCamo(secondary);
        if (camo.isEmpty() && (camoFactory = CamoContainerHelper.findCamoFactory(stack)) != null) {
            return this.setCamo(player, stack, camoFactory, secondary);
        }
        if (!camo.isEmpty() && CamoContainerHelper.isValidRemovalTool(camo, stack)) {
            return this.clearCamo(player, stack, camo, secondary);
        }
        if (stack.is(Tags.Items.DUSTS_GLOWSTONE) && !this.glowing) {
            return this.applyGlowstone(player, stack);
        }
        if (!camo.isEmpty() && !player.isShiftKeyDown() && Utils.isConfigurationTool(stack)) {
            return this.rotateCamo(camo, secondary);
        }
        if (!this.intangible && this.canMakeIntangible(stack)) {
            return this.applyIntangibility(player, stack);
        }
        if (this.intangible && player.isShiftKeyDown() && Utils.isConfigurationTool(stack)) {
            return this.removeIntangibility(player);
        }
        if (!this.reinforced && stack.is((Item)Utils.FRAMED_REINFORCEMENT.value())) {
            return this.applyReinforcement(player, stack);
        }
        if (this.reinforced && FramedBlockEntity.canRemoveReinforcement(stack)) {
            return this.removeReinforcement(player, stack, hand);
        }
        CamoContainer<?, ?> newCamo = CamoContainerHelper.handleCamoInteraction(this.level(), this.worldPosition, player, camo, stack, hand);
        if (camo != newCamo) {
            if (!this.level().isClientSide()) {
                this.setCamo(newCamo, secondary);
            }
            return ItemInteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private boolean canMakeIntangible(ItemStack stack) {
        if (!ConfigView.Server.INSTANCE.enableIntangibility()) {
            return false;
        }
        return stack.is(Utils.PHANTOM_PASTE) && this.getBlockType().allowMakingIntangible();
    }

    private static boolean canRemoveReinforcement(ItemStack stack) {
        if (stack.getItem().canPerformAction(stack, ItemAbilities.PICKAXE_DIG)) {
            return stack.isCorrectToolForDrops(Blocks.OBSIDIAN.defaultBlockState());
        }
        return false;
    }

    private ItemInteractionResult setCamo(Player player, ItemStack stack, CamoContainerFactory<?> factory, boolean secondary) {
        BlockItem item;
        Item item2 = stack.getItem();
        if (item2 instanceof BlockItem && (item = (BlockItem)item2).getBlock() instanceof IFramedBlock) {
            return ItemInteractionResult.FAIL;
        }
        Object camo = factory.applyCamo(this.level(), this.worldPosition, player, stack);
        if (camo != null) {
            if (!this.level().isClientSide()) {
                this.setCamo((CamoContainer<?, ?>)camo, secondary);
            }
            return ItemInteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return ItemInteractionResult.CONSUME_PARTIAL;
    }

    private ItemInteractionResult clearCamo(Player player, ItemStack stack, CamoContainer<?, ?> camo, boolean secondary) {
        if (CamoContainerHelper.removeCamo(camo, this.level(), this.worldPosition, player, stack)) {
            if (!this.level().isClientSide()) {
                this.setCamo(EmptyCamoContainer.EMPTY, secondary);
            }
            return ItemInteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return ItemInteractionResult.CONSUME_PARTIAL;
    }

    private ItemInteractionResult applyGlowstone(Player player, ItemStack stack) {
        if (!this.level().isClientSide()) {
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            this.setGlowing(true);
        }
        return ItemInteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    private ItemInteractionResult rotateCamo(CamoContainer<?, ?> camo, boolean secondary) {
        if (camo.canRotateCamo()) {
            if (!this.level().isClientSide()) {
                Object newCamo = camo.rotateCamo();
                Objects.requireNonNull(newCamo, "CamoContainer#rotateCamo() must not return null if CamoContainer#canRotateCamo() returns true");
                this.setCamo((CamoContainer<?, ?>)newCamo, secondary);
                this.setChangedWithoutSignalUpdate();
                this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
            return ItemInteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return ItemInteractionResult.FAIL;
    }

    private ItemInteractionResult applyIntangibility(Player player, ItemStack stack) {
        if (!this.level().isClientSide()) {
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            this.setIntangible(true);
        }
        return ItemInteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    private ItemInteractionResult removeIntangibility(Player player) {
        if (!this.level().isClientSide()) {
            this.setIntangible(false);
            Utils.giveToPlayer(player, new ItemStack(Utils.PHANTOM_PASTE), true);
        }
        return ItemInteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    private ItemInteractionResult applyReinforcement(Player player, ItemStack stack) {
        if (!this.level().isClientSide()) {
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            this.setReinforced(true);
        }
        return ItemInteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    private ItemInteractionResult removeReinforcement(Player player, ItemStack stack, InteractionHand hand) {
        if (!this.level().isClientSide()) {
            this.setReinforced(false);
            if (!player.isCreative()) {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            Utils.giveToPlayer(player, new ItemStack((ItemLike)Utils.FRAMED_REINFORCEMENT.value()), true);
        }
        return ItemInteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    protected final boolean hitSecondary(BlockHitResult hit, Player player) {
        return this.hitSecondary(hit, player.getLookAngle(), player.getEyePosition());
    }

    protected boolean hitSecondary(BlockHitResult hit, Vec3 lookVec, Vec3 eyePos) {
        return false;
    }

    public final void setCamo(CamoContainer<?, ?> camo, BlockHitResult hit, Player player) {
        this.setCamo(camo, this.hitSecondary(hit, player));
    }

    public final void setCamo(CamoContainer<?, ?> camo, boolean secondary) {
        int light = this.getLightValue();
        this.setCamoInternal(camo, secondary);
        this.setChangedWithoutSignalUpdate();
        if (this.getLightValue() != light) {
            this.doLightUpdate();
        }
        if (!this.updateDynamicStates(true, true, true)) {
            this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void setCamoInternal(CamoContainer<?, ?> camo, boolean secondary) {
        this.camoContainer = camo;
    }

    public boolean isSolidSide(Direction side) {
        if (this.camoContainer.isEmpty()) {
            return false;
        }
        return this.stateCache.isFullFace(side) && ((CamoContent)this.camoContainer.getContent()).isSolid((BlockGetter)this.level(), this.worldPosition);
    }

    public CamoContainer<?, ?> getCamo(BlockState state) {
        return this.camoContainer;
    }

    public CamoContainer<?, ?> getCamo(Direction side) {
        return this.camoContainer;
    }

    public CamoContainer<?, ?> getCamo(Direction side, @Nullable Direction edge) {
        return this.getCamo(side);
    }

    public final CamoContainer<?, ?> getCamo(BlockHitResult hit, Player player) {
        return this.getCamo(this.hitSecondary(hit, player));
    }

    public final CamoContainer<?, ?> getCamo(BlockHitResult hit, Vec3 lookVec, Vec3 eyePos) {
        return this.getCamo(this.hitSecondary(hit, lookVec, eyePos));
    }

    protected CamoContainer<?, ?> getCamo(boolean secondary) {
        return this.camoContainer;
    }

    public final CamoContainer<?, ?> getCamo() {
        return this.camoContainer;
    }

    protected boolean isCamoSolid() {
        return ((CamoContent)this.camoContainer.getContent()).isSolid((BlockGetter)this.level(), this.worldPosition);
    }

    protected boolean doesCamoPropagateSkylightDown() {
        return ((CamoContent)this.camoContainer.getContent()).propagatesSkylightDown((BlockGetter)this.level(), this.worldPosition);
    }

    public final void checkCamoSolid() {
        boolean checkSolid = this.getBlock().getBlockType().canOccludeWithSolidCamo();
        this.updateDynamicStates(checkSolid, true, true);
    }

    protected final boolean updateDynamicStates(boolean updateSolid, boolean updateLight, boolean updateSkylight) {
        boolean propagatesSkylight;
        BlockState state = this.getBlockState();
        boolean changed = false;
        if (updateSolid && this.getBlock().getBlockType().canOccludeWithSolidCamo()) {
            boolean solid;
            boolean wasSolid = (Boolean)this.getBlockState().getValue((Property)FramedProperties.SOLID);
            boolean bl = solid = !this.intangible && this.isCamoSolid();
            if (solid != wasSolid) {
                state = (BlockState)state.setValue((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(solid));
                changed = true;
            }
        }
        if (updateLight) {
            boolean isGlowing;
            boolean bl = isGlowing = this.getLightValue() > 0;
            if (isGlowing != (Boolean)state.getValue((Property)FramedProperties.GLOWING)) {
                state = (BlockState)state.setValue((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(isGlowing));
                changed = true;
            }
        }
        if (updateSkylight && (propagatesSkylight = this.doesCamoPropagateSkylightDown()) != (Boolean)state.getValue((Property)FramedProperties.PROPAGATES_SKYLIGHT)) {
            state = (BlockState)state.setValue((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(propagatesSkylight));
            changed = true;
        }
        if (changed) {
            this.level().setBlock(this.worldPosition, state, 3);
        }
        return changed;
    }

    public final void updateCulling(boolean neighbors, boolean rerender) {
        boolean changed = false;
        for (Direction dir : DIRECTIONS) {
            BlockEntity blockEntity;
            BlockState state = this.getBlockState();
            changed |= this.updateCulling(dir, state, false);
            if (!neighbors || !((blockEntity = this.level().getBlockEntity(this.worldPosition.relative(dir))) instanceof FramedBlockEntity)) continue;
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            be.updateCulling(dir.getOpposite(), be.getBlockState(), true);
        }
        if (changed) {
            this.requestModelDataUpdate();
            if (rerender) {
                this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    protected boolean updateCulling(Direction side, BlockState state, boolean rerender) {
        return this.updateCulling(this.culledFaces, state, side, rerender);
    }

    protected final boolean updateCulling(boolean[] culledFaces, BlockState testState, Direction side, boolean rerender) {
        boolean hidden;
        boolean wasHidden = culledFaces[side.ordinal()];
        if (wasHidden != (hidden = CullingHelper.isSideHidden((BlockGetter)this.level(), this.worldPosition, testState, side))) {
            culledFaces[side.ordinal()] = hidden;
            this.requestModelDataUpdate();
            if (rerender) {
                this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
            return true;
        }
        return false;
    }

    public float getCamoExplosionResistance(Explosion explosion) {
        float camoRes = ((CamoContent)this.camoContainer.getContent()).getExplosionResistance((BlockGetter)this.level(), this.worldPosition, explosion);
        if (this.reinforced) {
            camoRes = Math.max(camoRes, Blocks.OBSIDIAN.getExplosionResistance());
        }
        return camoRes;
    }

    public boolean isCamoFlammable(Direction face) {
        if (this.reinforced) {
            return false;
        }
        return this.camoContainer.isEmpty() || ((CamoContent)this.camoContainer.getContent()).isFlammable((BlockGetter)this.level(), this.worldPosition, face);
    }

    public int getCamoFlammability(Direction face) {
        if (this.reinforced) {
            return 0;
        }
        return this.camoContainer.isEmpty() ? -1 : ((CamoContent)this.camoContainer.getContent()).getFlammability((BlockGetter)this.level(), this.worldPosition, face);
    }

    public int getCamoFireSpreadSpeed(Direction face) {
        if (this.reinforced) {
            return 0;
        }
        return this.camoContainer.isEmpty() ? -1 : ((CamoContent)this.camoContainer.getContent()).getFireSpreadSpeed((BlockGetter)this.level(), this.worldPosition, face);
    }

    public float getCamoShadeBrightness(float ownShade) {
        return ((CamoContent)this.camoContainer.getContent()).getShadeBrightness((BlockGetter)this.level(), this.worldPosition, ownShade);
    }

    public final void setGlowing(boolean glowing) {
        if (this.glowing != glowing) {
            int oldLight = this.getLightValue();
            this.glowing = glowing;
            if (oldLight != this.getLightValue()) {
                this.doLightUpdate();
            }
            this.setChangedWithoutSignalUpdate();
            if (!this.updateDynamicStates(false, true, false)) {
                this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public final boolean isGlowing() {
        return this.glowing;
    }

    protected int getLightValue() {
        int baseLight = this.glowing ? ConfigView.Server.INSTANCE.getGlowstoneLightLevel() : 0;
        return Math.max(baseLight, ((CamoContent)this.camoContainer.getContent()).getLightEmission());
    }

    public void setIntangible(boolean intangible) {
        if (this.intangible != intangible) {
            this.intangible = intangible;
            this.setChangedWithoutSignalUpdate();
            if (!this.updateDynamicStates(true, false, false)) {
                this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public boolean isIntangible(@Nullable CollisionContext ctx) {
        EntityCollisionContext ectx;
        Entity entity;
        if (!ConfigView.Server.INSTANCE.enableIntangibility() || !this.intangible) {
            return false;
        }
        if (ctx instanceof EntityCollisionContext && (entity = (ectx = (EntityCollisionContext)ctx).getEntity()) instanceof Player) {
            Player player = (Player)entity;
            ItemStack mainItem = player.getMainHandItem();
            if (mainItem.isEmpty()) {
                return true;
            }
            if (mainItem.is(Utils.DISABLE_INTANGIBLE) || Utils.isWrenchRotationTool(mainItem) || Utils.isConfigurationTool(mainItem)) {
                return false;
            }
            return !this.isValidRemovalToolForAnyCamo(mainItem);
        }
        return true;
    }

    protected boolean isValidRemovalToolForAnyCamo(ItemStack stack) {
        return CamoContainerHelper.isValidRemovalTool(this.camoContainer, stack);
    }

    public void setReinforced(boolean reinforced) {
        if (this.reinforced != reinforced) {
            this.reinforced = reinforced;
            this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChangedWithoutSignalUpdate();
        }
    }

    public boolean isReinforced() {
        return this.reinforced;
    }

    protected final void doLightUpdate() {
        AuxiliaryLightManager lightManager = this.level().getAuxLightManager(this.worldPosition);
        if (lightManager != null) {
            lightManager.setLightAt(this.worldPosition, this.getLightValue());
        }
    }

    public IFramedBlock getBlock() {
        return (IFramedBlock)this.getBlockState().getBlock();
    }

    public final IBlockType getBlockType() {
        return this.getBlock().getBlockType();
    }

    protected final Level level() {
        return Objects.requireNonNull(this.level, "BlockEntity#level accessed before it was set");
    }

    protected final void setChangedWithoutSignalUpdate() {
        this.level().blockEntityChanged(this.worldPosition);
    }

    protected StateCache getStateCache() {
        return this.stateCache;
    }

    public boolean canAutoApplyCamoOnPlacement() {
        return true;
    }

    public boolean canTriviallyDropAllCamos() {
        return this.camoContainer.canTriviallyConvertToItemStack();
    }

    public void addAdditionalDrops(List<ItemStack> drops, boolean dropCamo) {
        if (dropCamo && this.canTriviallyDropAllCamos()) {
            this.addCamoDrops(drops);
        }
        if (this.reinforced) {
            drops.add(new ItemStack((ItemLike)Utils.FRAMED_REINFORCEMENT.value()));
        }
    }

    protected void addCamoDrops(List<ItemStack> drops) {
        ItemStack stack;
        if (!this.camoContainer.isEmpty() && !(stack = CamoContainerHelper.dropCamo(this.camoContainer)).isEmpty()) {
            drops.add(stack);
        }
    }

    public MapColor getMapColor() {
        return this.camoContainer.getMapColor((BlockGetter)this.level(), this.worldPosition);
    }

    public Integer getCamoBeaconColorMultiplier(LevelReader level, BlockPos pos, BlockPos beaconPos) {
        return this.camoContainer.getBeaconColorMultiplier(level, pos, beaconPos);
    }

    public boolean shouldCamoDisplayFluidOverlay(BlockAndTintGetter level, BlockPos pos, FluidState fluid) {
        return ((CamoContent)this.camoContainer.getContent()).shouldDisplayFluidOverlay(level, pos, fluid);
    }

    public float getCamoFriction(BlockState state, @Nullable Entity entity, float frameFriction) {
        return ((CamoContent)this.camoContainer.getContent()).getFriction((LevelReader)this.level(), this.worldPosition, entity, frameFriction);
    }

    public TriState canCamoSustainPlant(Direction side, BlockState plant) {
        return ((CamoContent)this.camoContainer.getContent()).canSustainPlant((BlockGetter)this.level(), this.worldPosition, side, plant);
    }

    public boolean canEntityDestroyCamo(Entity entity) {
        if (this.reinforced && !Blocks.OBSIDIAN.defaultBlockState().canEntityDestroy((BlockGetter)this.level(), this.worldPosition, entity)) {
            return false;
        }
        return ((CamoContent)this.camoContainer.getContent()).canEntityDestroy((BlockGetter)this.level(), this.worldPosition, entity);
    }

    public void onLoad() {
        if (!this.level().isClientSide()) {
            if (this.recheckStates) {
                this.checkCamoSolid();
            }
            if (this.forceLightUpdate) {
                this.doLightUpdate();
            }
        }
        super.onLoad();
    }

    public void setBlockState(BlockState state) {
        super.setBlockState(state);
        this.stateCache = ((IFramedBlock)state.getBlock()).getCache(state);
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (be, registryAccess) -> {
            CompoundTag tag = new CompoundTag();
            ((FramedBlockEntity)((Object)be)).writeToDataPacket(tag, (HolderLookup.Provider)registryAccess);
            return tag;
        });
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        CompoundTag nbt = pkt.getTag();
        if (!nbt.isEmpty() && this.readFromDataPacket(nbt, lookupProvider)) {
            this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.requestModelDataUpdate();
        }
    }

    protected void writeToDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        nbt.put("camo", (Tag)CamoContainerHelper.writeToNetwork(this.camoContainer));
        nbt.putByte("flags", this.writeFlags());
    }

    protected boolean readFromDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        boolean newReinforced;
        boolean newIntangible;
        byte flags;
        boolean newGlow;
        boolean needUpdate = false;
        boolean needCullingUpdate = false;
        CamoContainer<?, ?> newCamo = CamoContainerHelper.readFromNetwork(nbt.getCompound("camo"));
        if (!newCamo.equals(this.camoContainer)) {
            int oldLight = this.getLightValue();
            this.camoContainer = newCamo;
            if (oldLight != this.getLightValue()) {
                this.doLightUpdate();
            }
            needUpdate = true;
            needCullingUpdate = true;
        }
        if ((newGlow = FramedBlockEntity.readFlag(flags = nbt.getByte("flags"), 1)) != this.glowing) {
            this.glowing = newGlow;
            needUpdate = true;
            this.doLightUpdate();
        }
        if ((newIntangible = FramedBlockEntity.readFlag(flags, 2)) != this.intangible) {
            this.intangible = newIntangible;
            needUpdate = true;
            needCullingUpdate = true;
        }
        if ((newReinforced = FramedBlockEntity.readFlag(flags, 4)) != this.reinforced) {
            this.reinforced = newReinforced;
            needUpdate = true;
        }
        if (needCullingUpdate) {
            this.updateCulling(true, false);
        }
        return needUpdate;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        nbt.put("camo", (Tag)CamoContainerHelper.writeToNetwork(this.camoContainer));
        nbt.putByte("flags", this.writeFlags());
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt, HolderLookup.Provider provider) {
        if (this.readCamoFromUpdateTag(nbt, provider)) {
            this.cullStateDirty = true;
        }
        byte flags = nbt.getByte("flags");
        this.glowing = FramedBlockEntity.readFlag(flags, 1);
        this.intangible = FramedBlockEntity.readFlag(flags, 2);
        boolean newReinforced = FramedBlockEntity.readFlag(flags, 4);
        if (newReinforced != this.reinforced) {
            this.reinforced = newReinforced;
        }
        this.requestModelDataUpdate();
    }

    protected boolean readCamoFromUpdateTag(CompoundTag nbt, HolderLookup.Provider provider) {
        CamoContainer<?, ?> newCamo = CamoContainerHelper.readFromNetwork(nbt.getCompound("camo"));
        if (!newCamo.equals(this.camoContainer)) {
            this.camoContainer = newCamo;
            return true;
        }
        return false;
    }

    private byte writeFlags() {
        byte flags = 0;
        if (this.glowing) {
            flags = (byte)(flags | 1);
        }
        if (this.intangible) {
            flags = (byte)(flags | 2);
        }
        if (this.reinforced) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    protected static boolean readFlag(byte flags, int flag) {
        return (flags & flag) != 0;
    }

    public final ModelData getModelData() {
        if (this.cullStateDirty) {
            this.updateCulling(false, false);
            this.cullStateDirty = false;
        }
        return this.getModelData(true);
    }

    public ModelData getModelData(boolean includeCullInfo) {
        boolean[] cullData = includeCullInfo ? this.culledFaces : FramedBlockData.NO_CULLED_FACES;
        FramedBlockData modelData = new FramedBlockData((CamoContent<?>)this.camoContainer.getContent(), cullData, false, this.isReinforced());
        ModelData.Builder builder = ModelData.builder().with(FramedBlockData.PROPERTY, (Object)modelData);
        this.attachAdditionalModelData(builder);
        return builder.build();
    }

    protected void attachAdditionalModelData(ModelData.Builder builder) {
    }

    public final BlueprintData writeToBlueprint() {
        return new BlueprintData(this.getBlockState().getBlock(), this.collectCamosForBlueprint(), this.glowing, this.intangible, this.reinforced, this.collectAuxBlueprintData());
    }

    protected CamoList collectCamosForBlueprint() {
        return CamoList.of(this.camoContainer);
    }

    protected Optional<AuxBlueprintData<?>> collectAuxBlueprintData() {
        return Optional.empty();
    }

    public final void applyBlueprintData(BlueprintData blueprintData) {
        this.applyCamosFromBlueprint(blueprintData);
        this.setGlowing(blueprintData.glowing());
        this.setIntangible(blueprintData.intangible());
        this.setReinforced(blueprintData.reinforced());
        blueprintData.auxData().ifPresent(this::applyAuxDataFromBlueprint);
    }

    protected void applyCamosFromBlueprint(BlueprintData blueprintData) {
        this.setCamo(blueprintData.camos().getCamo(0), false);
    }

    protected void applyAuxDataFromBlueprint(AuxBlueprintData<?> auxData) {
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("camo");
        tag.remove("glowing");
        tag.remove("intangible");
        tag.remove("reinforced");
        tag.remove("updated");
    }

    protected final void collectImplicitComponents(DataComponentMap.Builder builder) {
        this.collectCamoComponents(builder);
        this.collectMiscComponents(builder);
        FrameConfig cfg = new FrameConfig(this.glowing, this.intangible, this.reinforced);
        if (!cfg.equals(FrameConfig.DEFAULT)) {
            builder.set(Utils.DC_TYPE_FRAME_CONFIG, (Object)cfg);
        }
    }

    protected void collectCamoComponents(DataComponentMap.Builder builder) {
        builder.set(Utils.DC_TYPE_CAMO_LIST, (Object)CamoList.of(this.camoContainer));
    }

    protected void collectMiscComponents(DataComponentMap.Builder builder) {
    }

    protected final void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        this.applyCamoComponents(input);
        this.applyMiscComponents(input);
        ((FrameConfig)input.getOrDefault(Utils.DC_TYPE_FRAME_CONFIG, (Object)FrameConfig.DEFAULT)).apply(this);
    }

    protected void applyCamoComponents(BlockEntity.DataComponentInput input) {
        this.setCamo(((CamoList)input.getOrDefault(Utils.DC_TYPE_CAMO_LIST, (Object)CamoList.EMPTY)).getCamo(0), false);
    }

    protected void applyMiscComponents(BlockEntity.DataComponentInput input) {
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.put("camo", CamoContainerHelper.writeToDisk(this.camoContainer));
        nbt.putBoolean("glowing", this.glowing);
        nbt.putBoolean("intangible", this.intangible);
        nbt.putBoolean("reinforced", this.reinforced);
        nbt.putByte("updated", (byte)3);
        super.saveAdditional(nbt, provider);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.camoContainer = this.loadAndValidateCamo(nbt, "camo");
        this.glowing = nbt.getBoolean("glowing");
        this.intangible = nbt.getBoolean("intangible");
        this.reinforced = nbt.getBoolean("reinforced");
        if (this.glowing) {
            this.forceLightUpdate = true;
            this.recheckStates = true;
        }
    }

    protected final CamoContainer<?, ?> loadAndValidateCamo(CompoundTag tag, String key) {
        CamoContainer<?, ?> camo = CamoContainerHelper.readFromDisk(tag.getCompound(key));
        if (!CamoContainerHelper.validateCamo(camo)) {
            this.recheckStates = true;
            LOGGER.warn("Framed Block of type \"{}\" at position {} contains an invalid camo of type \"{}\" containing \"{}\", removing camo! This might be caused by a config or tag change!", new Object[]{BuiltInRegistries.BLOCK.getKey((Object)this.getBlockState().getBlock()), this.worldPosition, FramedBlocksAPI.INSTANCE.getCamoContainerFactoryRegistry().getKey(camo.getFactory()), ((CamoContent)camo.getContent()).getCamoId()});
            return EmptyCamoContainer.EMPTY;
        }
        this.forceLightUpdate |= ((CamoContent)camo.getContent()).getLightEmission() > 0;
        this.recheckStates |= tag.getByte("updated") < 3;
        return camo;
    }
}

