/*
 * Decompiled with CFR 0.152.
 */
package net.sashiro.compressedblocks.util;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;

public class Compression {
    private static final String[] BLOCK_COUNTS_LESSER = new String[]{"4", "16", "64", "256", "1.024", "4.096", "16.384", "65.536", "262.144", "1.048.576"};
    private static final String[] BLOCK_COUNTS = new String[]{"9", "81", "729", "6.561", "59.049", "531.441", "4.782.969", "43.046.721", "387.420.489", "3.486.784.401"};
    private static final ChatFormatting[] STYLES = new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.GREEN, ChatFormatting.AQUA, ChatFormatting.BLUE, ChatFormatting.DARK_BLUE, ChatFormatting.YELLOW, ChatFormatting.GOLD, ChatFormatting.LIGHT_PURPLE, ChatFormatting.DARK_PURPLE, ChatFormatting.DARK_RED};
    private String blockCount;
    private Style style = Style.EMPTY;
    private boolean isLesser;
    private int compressionLevel;

    public void setCompressionLevel(int compressionLevel, boolean isLesser) {
        this.isLesser = isLesser;
        this.compressionLevel = compressionLevel;
        if (compressionLevel < 0) {
            compressionLevel = 0;
        }
        if (compressionLevel > 9) {
            compressionLevel = 9;
        }
        this.blockCount = isLesser ? BLOCK_COUNTS_LESSER[compressionLevel] : BLOCK_COUNTS[compressionLevel];
        this.style = this.style.applyFormat(STYLES[compressionLevel]);
    }

    public String getBlockCount() {
        return this.blockCount;
    }

    public boolean isLesser() {
        return this.isLesser;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.setCompressionLevel(compressionLevel, false);
    }

    public Style getStyle() {
        return this.style;
    }
}

