/*
 * Decompiled with CFR 0.152.
 */
package net.sashiro.compressedblocks.util;

import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.NotNull;

public class CommonUtils {
    private CommonUtils() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static String stringFormat(String formatString) {
        formatString = formatString.replace("_", " ");
        String[] words = formatString.split("\\s");
        StringBuilder stringFormat = new StringBuilder();
        for (String str : words) {
            String first = str.substring(0, 1);
            String afterFirst = str.substring(1);
            stringFormat.append(first.toUpperCase()).append(afterFirst).append(" ");
        }
        return stringFormat.toString().trim();
    }

    public static String removeCompressionName(String name) {
        for (int i = 0; i < 10; ++i) {
            if (!name.contains("c" + i)) continue;
            name = name.replace("c" + i + "_", "");
        }
        return name;
    }

    public static String getCratePrefix(int index) {
        return switch (index) {
            case 0 -> "crated_";
            case 1 -> "double_crated_";
            case 2 -> "triple_crated_";
            case 3 -> "quadruple_crated_";
            case 4 -> "quintuple_crated_";
            case 5 -> "sextuple_crated_";
            case 6 -> "septuple_crated_";
            case 7 -> "octuple_crated_";
            case 8 -> "mega_crated_";
            case 9 -> "giga_crated_";
            default -> "";
        };
    }

    public static ResourceLocation getOverlay(String blockName) {
        blockName = blockName.replace("block.compressedblocks.", "");
        Object overlay = "";
        String[] crateLevels = new String[]{"crated_", "double_crated_", "triple_crated_", "quadruple_crated_", "quintuple_crated_", "sextuple_crated_", "septuple_crated_", "octuple_crated_", "mega_crated_", "giga_crated_"};
        if (blockName.contains("crated")) {
            for (int i = 0; i < crateLevels.length; ++i) {
                if (!blockName.startsWith(crateLevels[i])) continue;
                overlay = "level_" + i;
                break;
            }
        } else if (blockName.startsWith("c")) {
            for (int i = 0; i < 10; ++i) {
                if (!blockName.contains("c" + i)) continue;
                overlay = "compression_level_" + i;
                break;
            }
        } else {
            overlay = "null";
        }
        return ResourceLocation.fromNamespaceAndPath((String)"compressedblocks", (String)("block/" + (String)overlay));
    }

    @NotNull
    public static ResourceLocation getResourceLocation(String mc_name) {
        ResourceLocation location = ResourceLocation.withDefaultNamespace((String)("item/" + mc_name));
        if (mc_name.contains("rail") || mc_name.contains("torch") || mc_name.contains("lightning_rod") || mc_name.contains("end_rod") || mc_name.contains("anvil") || mc_name.contains("sapling") || mc_name.contains("mushroom") || mc_name.contains("fungus") || mc_name.contains("dandelion") || mc_name.contains("poppy") || mc_name.contains("orchid") || mc_name.contains("allium") || mc_name.contains("bluet") || mc_name.contains("tulip") || mc_name.contains("daisy") || mc_name.contains("cornflower") || mc_name.contains("valley") || mc_name.contains("rose") || mc_name.contains("turtle") || mc_name.contains("cobweb") || mc_name.contains("vein") || mc_name.contains("vine") || mc_name.contains("lichen")) {
            location = ResourceLocation.withDefaultNamespace((String)("block/" + mc_name));
        }
        if (mc_name.contains("sunflower")) {
            location = ResourceLocation.withDefaultNamespace((String)"block/sunflower_front");
        }
        if (mc_name.contains("lilac")) {
            location = ResourceLocation.withDefaultNamespace((String)"block/lilac_top");
        }
        if (mc_name.contains("rose_bush")) {
            location = ResourceLocation.withDefaultNamespace((String)"block/rose_bush_top");
        }
        if (mc_name.contains("peony")) {
            location = ResourceLocation.withDefaultNamespace((String)"block/peony_top");
        }
        if (mc_name.contains("carpet")) {
            location = ResourceLocation.withDefaultNamespace((String)("block/" + mc_name.replace("carpet", "wool")));
        }
        if (mc_name.contains("scute")) {
            location = ResourceLocation.withDefaultNamespace((String)("item/" + mc_name));
        }
        return location;
    }

    public static String getMCName(String crateName) {
        crateName = crateName.replace("item.compressedblocks.", "");
        if ((crateName = crateName.replace("block.compressedblocks.", "")).startsWith("crated_")) {
            crateName = crateName.replace("crated_", "");
        } else if (crateName.startsWith("double_crated_")) {
            crateName = crateName.replace("double_crated_", "");
        } else if (crateName.startsWith("triple_crated_")) {
            crateName = crateName.replace("triple_crated_", "");
        } else if (crateName.startsWith("quadruple_crated_")) {
            crateName = crateName.replace("quadruple_crated_", "");
        } else if (crateName.startsWith("quintuple_crated_")) {
            crateName = crateName.replace("quintuple_crated_", "");
        } else if (crateName.startsWith("sextuple_crated_")) {
            crateName = crateName.replace("sextuple_crated_", "");
        } else if (crateName.startsWith("septuple_crated_")) {
            crateName = crateName.replace("septuple_crated_", "");
        } else if (crateName.startsWith("octuple_crated_")) {
            crateName = crateName.replace("octuple_crated_", "");
        } else if (crateName.startsWith("mega_crated_")) {
            crateName = crateName.replace("mega_crated_", "");
        } else if (crateName.startsWith("giga_crated_")) {
            crateName = crateName.replace("giga_crated_", "");
        }
        return crateName;
    }

    public static ResourceLocation getActualResourceLocation(String resourceLocation) {
        String blockName = resourceLocation.replace("block.compressedblocks.", "");
        if ((blockName = CommonUtils.removeCompressionName(blockName)).contains("cut")) {
            if (blockName.contains("exposed_cut_copper")) {
                blockName = "exposed_cut_copper";
            } else if (blockName.contains("oxidized_cut_copper")) {
                blockName = "oxidized_cut_copper";
            } else if (blockName.contains("weathered_cut_copper")) {
                blockName = "weathered_cut_copper";
            } else if (blockName.contains("cut_copper")) {
                blockName = "cut_copper";
            }
        } else if (blockName.contains("copper_block") && !blockName.contains("raw")) {
            blockName = "copper_block";
        } else if (blockName.contains("exposed_copper")) {
            blockName = "exposed_copper";
        } else if (blockName.contains("oxidized_copper")) {
            blockName = "oxidized_copper";
        } else if (blockName.contains("weathered_copper")) {
            blockName = "weathered_copper";
        }
        if (blockName.contains("magma_block")) {
            blockName = "magma";
        }
        if (blockName.contains("snow_block")) {
            blockName = "snow";
        }
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("block/" + blockName));
    }

    public static String compressionLevel(String registryName) {
        String str;
        return switch (str = registryName.substring(0, 2)) {
            case "c0" -> "Compressed ";
            case "c1" -> "Double Compressed ";
            case "c2" -> "Triple Compressed ";
            case "c3" -> "Quadruple Compressed ";
            case "c4" -> "Quintuple Compressed ";
            case "c5" -> "Sextuple Compressed ";
            case "c6" -> "Septuple Compressed ";
            case "c7" -> "Octuple Compressed ";
            case "c8" -> "Mega Compressed ";
            case "c9" -> "Giga Compressed ";
            default -> "";
        };
    }

    public static String getCleanName(String resourceLocation) {
        String blockName = resourceLocation.replace("block.compressedblocks.", "");
        blockName = CommonUtils.removeCompressionName(blockName);
        return "block/" + blockName;
    }

    public static boolean isBlock(String blockName) {
        for (String s : Arrays.asList("honey_block", "basalt", "bone_block", "sandstone", "tnt", "smooth_quartz", "quartz_block", "kelp")) {
            if (!blockName.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRotational(String blockName) {
        for (String s : Arrays.asList("log", "pillar", "stem", "stripped", "hyphae", "bamboo_block", "froglight", "melon", "pumpkin", "hay")) {
            if (!blockName.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static Item.Properties setRarity(Item.Properties properties, int i) {
        switch (i) {
            case 4: 
            case 5: {
                properties = properties.rarity(Rarity.UNCOMMON);
                break;
            }
            case 6: 
            case 7: {
                properties = properties.rarity(Rarity.RARE);
                break;
            }
            case 8: 
            case 9: {
                properties = properties.rarity(Rarity.EPIC);
                break;
            }
            default: {
                properties = properties.rarity(Rarity.COMMON);
            }
        }
        return properties;
    }
}

