/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.serializer;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.network.CompoundSerializableDataHandler;
import com.mojang.serialization.MapCodec;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class GenericSerializer<T extends Recipe<?>>
implements RecipeSerializer<T> {
    private final Class<T> recipeClass;
    private final Supplier<RecipeType<?>> recipeTypeSupplier;
    private final MapCodec<T> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.ofMember((value, output) -> this.toNetwork((RegistryFriendlyByteBuf)output, (T)value), this::fromNetwork);

    public GenericSerializer(Class<T> recipeClass, Supplier<RecipeType<?>> recipeTypeSupplier, MapCodec<T> codec) {
        this.recipeClass = recipeClass;
        this.recipeTypeSupplier = recipeTypeSupplier;
        this.codec = codec;
    }

    @ParametersAreNonnullByDefault
    public T fromNetwork(RegistryFriendlyByteBuf buffer) {
        try {
            Recipe recipe = (Recipe)this.recipeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : this.recipeClass.getFields()) {
                if (!CompoundSerializableDataHandler.acceptField(field, field.getType())) continue;
                CompoundSerializableDataHandler.readField(field, field.getType(), buffer, recipe);
            }
            return (T)recipe;
        }
        catch (Exception e) {
            Titanium.LOGGER.catching((Throwable)e);
            return null;
        }
    }

    @ParametersAreNonnullByDefault
    public void toNetwork(RegistryFriendlyByteBuf buffer, T recipe) {
        try {
            for (Field field : this.recipeClass.getFields()) {
                if (!CompoundSerializableDataHandler.acceptField(field, field.getType())) continue;
                CompoundSerializableDataHandler.writeField(field, field.getType(), buffer, recipe);
            }
        }
        catch (Exception e) {
            Titanium.LOGGER.catching((Throwable)e);
        }
    }

    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    public MapCodec<T> codec() {
        return this.codec;
    }
}

