/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.event.handler;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.common.NeoForge;

public class EventManager {
    public static <T extends Event> FilteredEventManager<T> forge(Class<T> clazz) {
        return EventManager.create(clazz, EventPriority.NORMAL, Bus.FORGE);
    }

    public static <T extends Event> FilteredEventManager<T> mod(Class<T> clazz) {
        return EventManager.create(clazz, EventPriority.NORMAL, Bus.MOD);
    }

    public static <T extends Event> FilteredEventManager<T> mod(Class<T> clazz, EventPriority priority) {
        return EventManager.create(clazz, priority, Bus.MOD);
    }

    public static <T extends Event> FilteredEventManager<T> forge(Class<T> clazz, EventPriority priority) {
        return EventManager.create(clazz, priority, Bus.FORGE);
    }

    public static <T extends Event> FilteredEventManager<T> create(Class<T> clazz, Bus bus) {
        return EventManager.create(clazz, EventPriority.NORMAL, bus);
    }

    public static <T extends Event> FilteredEventManager<T> create(Class<T> clazz, EventPriority priority, Bus bus) {
        return new FilteredEventManager<T>(clazz, bus, priority);
    }

    public static enum Bus {
        FORGE(() -> NeoForge.EVENT_BUS),
        MOD(() -> ModLoadingContext.get().getActiveContainer().getEventBus());

        private final Supplier<IEventBus> busSupplier;

        private Bus(Supplier<IEventBus> eventBusSupplier) {
            this.busSupplier = eventBusSupplier;
        }

        public IEventBus bus() {
            return this.busSupplier.get();
        }
    }

    public static class FilteredEventManager<T extends Event>
    implements ISubscribe {
        private Predicate<T> filter;
        private Consumer<T> process;
        private Class<T> event;
        private boolean cancel;
        private Bus bus;
        private EventPriority priority;

        public FilteredEventManager(Class<T> clazz, Bus bus, EventPriority priority) {
            this.event = clazz;
            this.filter = t -> true;
            this.process = t -> {};
            this.bus = bus;
            this.priority = priority;
        }

        @Override
        public void subscribe() {
            this.bus.bus().addListener(this.priority, false, this.event, event -> {
                if (event.getClass().isAssignableFrom(this.event) && this.filter.test((Event)event)) {
                    ICancellableEvent cancellableEvent;
                    if (this.cancel && event instanceof ICancellableEvent && !(cancellableEvent = (ICancellableEvent)event).isCanceled()) {
                        cancellableEvent.setCanceled(true);
                    }
                    this.process.accept((Event)event);
                }
            });
        }

        public FilteredEventManager<T> filter(Predicate<T> predicateFilter) {
            this.filter = this.filter.and(predicateFilter);
            return this;
        }

        public FilteredEventManager<T> process(Consumer<T> process) {
            this.process = this.process.andThen(process);
            return this;
        }

        public FilteredEventManager<T> cancel() {
            this.cancel = true;
            return this;
        }
    }

    public static interface ISubscribe {
        public void subscribe();
    }
}

