/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import java.util.Optional;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModTags;
import mob_grinding_utils.blocks.BlockXPTap;
import mob_grinding_utils.entity.EntityXPOrbFalling;
import mob_grinding_utils.network.TapParticlePacket;
import mob_grinding_utils.util.CapHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class TileEntityXPTap
extends BlockEntity {
    public boolean active;

    public TileEntityXPTap(BlockPos pos, BlockState state) {
        super(ModBlocks.XP_TAP.getTileEntityType(), pos, state);
    }

    public static <T extends BlockEntity> void serverTick(Level world, BlockPos worldPosition, BlockState blockState, T t) {
        if (t instanceof TileEntityXPTap) {
            BlockPos blockPos;
            BlockEntity tileentity;
            TileEntityXPTap tileEntityXPTap = (TileEntityXPTap)t;
            if (tileEntityXPTap.active && (tileentity = world.getBlockEntity(blockPos = worldPosition.relative(((Direction)world.getBlockState(worldPosition).getValue((Property)BlockXPTap.FACING)).getOpposite()))) != null) {
                Optional<IFluidHandler> fluidHandler = CapHelper.getFluidHandler(world, blockPos, (Direction)world.getBlockState(worldPosition).getValue((Property)BlockXPTap.FACING));
                fluidHandler.ifPresent(handler -> {
                    int xpAmount;
                    if (handler.getTanks() > 0 && handler.getFluidInTank(0).getAmount() >= 20 && handler.getFluidInTank(0).getFluid().is(ModTags.Fluids.EXPERIENCE) && world.getGameTime() % 3L == 0L && !handler.drain((xpAmount = EntityXPOrbFalling.getExperienceValue((int)Math.min(20, handler.getFluidInTank(0).getAmount() / 20))) * 20, IFluidHandler.FluidAction.EXECUTE).isEmpty()) {
                        tileEntityXPTap.spawnXP(world, worldPosition, xpAmount, tileentity);
                        PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)world), null, (double)t.getBlockPos().getX(), (double)t.getBlockPos().getY(), (double)t.getBlockPos().getZ(), (double)30.0, (CustomPacketPayload)new TapParticlePacket(worldPosition), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                });
            }
        }
    }

    public void spawnXP(Level world, BlockPos pos, int xp, BlockEntity tankTile) {
        tankTile.setChanged();
        EntityXPOrbFalling orb = new EntityXPOrbFalling(world, (double)pos.getX() + 0.5, (double)pos.getY() - 0.125, (double)pos.getZ() + 0.5, xp);
        world.addFreshEntity((Entity)orb);
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
        this.getLevel().sendBlockUpdated(this.worldPosition, this.getLevel().getBlockState(this.worldPosition), this.getLevel().getBlockState(this.worldPosition), 3);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putBoolean("active", this.active);
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.active = nbt.getBoolean("active");
    }

    public CompoundTag getUpdateTag(@Nonnull HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, registries);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, (HolderLookup.Provider)this.level.registryAccess());
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(@Nonnull Connection net, ClientboundBlockEntityDataPacket packet, @Nonnull HolderLookup.Provider registries) {
        if (packet.getTag() != null) {
            this.loadAdditional(packet.getTag(), registries);
        }
    }
}

