/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import io.netty.buffer.Unpooled;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.blocks.BlockSaw;
import mob_grinding_utils.components.MGUComponents;
import mob_grinding_utils.inventory.server.ContainerSaw;
import mob_grinding_utils.items.ItemSawUpgrade;
import mob_grinding_utils.tile.TileEntityInventoryHelper;
import mob_grinding_utils.util.FakePlayerHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.FakePlayer;

public class TileEntitySaw
extends TileEntityInventoryHelper
implements MenuProvider {
    public boolean active;
    public int animationTicks;
    public int prevAnimationTicks;
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5};
    private UUID placer = null;
    private WeakReference<FakePlayer> fakePlayer = new WeakReference<Object>(null);

    public TileEntitySaw(BlockPos pos, BlockState state) {
        super(ModBlocks.SAW.getTileEntityType(), 6, pos, state);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (t instanceof TileEntitySaw) {
            TileEntitySaw tile = (TileEntitySaw)t;
            if (tile.active) {
                tile.prevAnimationTicks = tile.animationTicks;
                if (tile.animationTicks < 360) {
                    tile.animationTicks += 18;
                }
                if (tile.animationTicks >= 360) {
                    tile.animationTicks -= 360;
                    tile.prevAnimationTicks -= 360;
                }
            } else {
                tile.animationTicks = 0;
                tile.prevAnimationTicks = 0;
            }
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (t instanceof TileEntitySaw) {
            TileEntitySaw tile = (TileEntitySaw)t;
            if (level.getGameTime() % 10L == 0L && level.getBlockState(blockPos).getBlock() instanceof BlockSaw && ((Boolean)level.getBlockState(blockPos).getValue((Property)BlockSaw.POWERED)).booleanValue()) {
                tile.activateBlock();
            }
        }
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
        this.getLevel().sendBlockUpdated(this.worldPosition, this.getLevel().getBlockState(this.worldPosition), this.getLevel().getBlockState(this.worldPosition), 3);
    }

    protected void activateBlock() {
        List list = this.getLevel().getEntitiesOfClass(LivingEntity.class, new AABB((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (double)this.worldPosition.getX() + 1.0, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 1.0).inflate(0.0625, 0.0625, 0.0625));
        if (list.isEmpty() || this.level == null) {
            return;
        }
        this.fakePlayer = FakePlayerHandler.get(this.fakePlayer, (ServerLevel)this.getLevel(), this.placer, this.worldPosition.atY(-100));
        FakePlayer fakePlayer = (FakePlayer)this.fakePlayer.get();
        if (fakePlayer == null) {
            return;
        }
        ItemStack tempSword = new ItemStack((ItemLike)ModItems.NULL_SWORD.get(), 1);
        if (this.hasSharpnessUpgrade()) {
            tempSword.enchant(this.level.holderOrThrow(Enchantments.SHARPNESS), ((ItemStack)this.getItems().get(0)).getCount() * 10);
        }
        if (this.hasLootingUpgrade()) {
            tempSword.enchant(this.level.holderOrThrow(Enchantments.LOOTING), ((ItemStack)this.getItems().get(1)).getCount());
        }
        if (this.hasFlameUpgrade()) {
            tempSword.enchant(this.level.holderOrThrow(Enchantments.FIRE_ASPECT), ((ItemStack)this.getItems().get(2)).getCount());
        }
        if (this.hasSmiteUpgrade()) {
            tempSword.enchant(this.level.holderOrThrow(Enchantments.SMITE), ((ItemStack)this.getItems().get(3)).getCount() * 10);
        }
        if (this.hasArthropodUpgrade()) {
            tempSword.enchant(this.level.holderOrThrow(Enchantments.BANE_OF_ARTHROPODS), ((ItemStack)this.getItems().get(4)).getCount() * 10);
        }
        if (this.hasBeheadingUpgrade()) {
            tempSword.set(MGUComponents.BEHEADING, (Object)((ItemStack)this.getItems().get(5)).getCount());
        }
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, tempSword);
        fakePlayer.detectEquipmentUpdates();
        for (Entity entity : list) {
            if (entity == null || !(entity instanceof LivingEntity)) continue;
            fakePlayer.attack(entity);
            fakePlayer.attackStrengthTicker = 100;
        }
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
    }

    private boolean hasSharpnessUpgrade() {
        return !((ItemStack)this.getItems().get(0)).isEmpty() && ((ItemStack)this.getItems().get(0)).getItem() == ModItems.SAW_UPGRADE_SHARPNESS.get();
    }

    private boolean hasLootingUpgrade() {
        return !((ItemStack)this.getItems().get(1)).isEmpty() && ((ItemStack)this.getItems().get(1)).getItem() == ModItems.SAW_UPGRADE_LOOTING.get();
    }

    private boolean hasFlameUpgrade() {
        return !((ItemStack)this.getItems().get(2)).isEmpty() && ((ItemStack)this.getItems().get(2)).getItem() == ModItems.SAW_UPGRADE_FIRE.get();
    }

    private boolean hasSmiteUpgrade() {
        return !((ItemStack)this.getItems().get(3)).isEmpty() && ((ItemStack)this.getItems().get(3)).getItem() == ModItems.SAW_UPGRADE_SMITE.get();
    }

    private boolean hasArthropodUpgrade() {
        return !((ItemStack)this.getItems().get(4)).isEmpty() && ((ItemStack)this.getItems().get(4)).getItem() == ModItems.SAW_UPGRADE_ARTHROPOD.get();
    }

    private boolean hasBeheadingUpgrade() {
        return !((ItemStack)this.getItems().get(5)).isEmpty() && ((ItemStack)this.getItems().get(5)).getItem() == ModItems.SAW_UPGRADE_BEHEADING.get();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.active = nbt.getBoolean("active");
        this.placer = nbt.hasUUID("placer") ? nbt.getUUID("placer") : null;
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putBoolean("active", this.active);
        if (this.placer != null) {
            nbt.putUUID("placer", this.placer);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(net, packet, registries);
        this.loadAdditional(packet.getTag(), registries);
        if (!this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 3);
        }
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (stack.getItem() instanceof ItemSawUpgrade) {
            switch (slot) {
                case 0: {
                    if (stack.getItem() == ModItems.SAW_UPGRADE_SHARPNESS.get()) {
                        return true;
                    }
                }
                case 1: {
                    if (stack.getItem() == ModItems.SAW_UPGRADE_LOOTING.get()) {
                        return true;
                    }
                }
                case 2: {
                    if (stack.getItem() == ModItems.SAW_UPGRADE_FIRE.get()) {
                        return true;
                    }
                }
                case 3: {
                    if (stack.getItem() == ModItems.SAW_UPGRADE_SMITE.get()) {
                        return true;
                    }
                }
                case 4: {
                    if (stack.getItem() == ModItems.SAW_UPGRADE_ARTHROPOD.get()) {
                        return true;
                    }
                }
                case 5: {
                    if (stack.getItem() != ModItems.SAW_UPGRADE_BEHEADING.get()) break;
                    return true;
                }
            }
        }
        return false;
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.getItems(), (int)index);
    }

    @Override
    public int getMaxStackSize() {
        return 10;
    }

    public int[] getSlotsForFace(Direction side) {
        return SLOTS;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction direction) {
        return this.canPlaceItem(slot, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public AbstractContainerMenu createMenu(int windowID, Inventory playerInventory, Player player) {
        return new ContainerSaw(windowID, playerInventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.translatable((String)"block.mob_grinding_utils.saw");
    }

    public void setPlacer(Player player) {
        this.placer = player.getUUID();
    }
}

