/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.events;

import mob_grinding_utils.ModItems;
import mob_grinding_utils.components.MGUComponents;
import mob_grinding_utils.items.ItemGMChickenFeed;
import mob_grinding_utils.items.ItemMobSwab;
import mob_grinding_utils.network.ChickenSyncPacket;
import mob_grinding_utils.util.RL;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class EntityInteractionEvent {
    @SubscribeEvent
    public void clickOnEntity(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (entity2 instanceof WanderingTrader && !event.getItemStack().isEmpty() && event.getItemStack().getItem() instanceof ItemMobSwab) {
                event.getItemStack().interactLivingEntity(event.getEntity(), entity2, event.getHand());
                return;
            }
            if (entity2 instanceof Chicken && !entity2.isBaby()) {
                Level world = entity2.getCommandSenderWorld();
                ItemStack eventItem = event.getItemStack();
                if (!eventItem.isEmpty() && eventItem.getItem() instanceof ItemGMChickenFeed && !world.isClientSide) {
                    CompoundTag nbt = entity2.getPersistentData();
                    if (!nbt.contains("shouldExplode")) {
                        entity2.setInvulnerable(true);
                        nbt.putBoolean("shouldExplode", true);
                        nbt.putInt("countDown", 0);
                        if (eventItem.has(MGUComponents.MOB_DNA)) {
                            nbt.putString("mguMobName", ((ResourceLocation)eventItem.getOrDefault(MGUComponents.MOB_DNA, (Object)RL.mc("chicken"))).toString());
                        }
                        if (eventItem.getItem() == ModItems.GM_CHICKEN_FEED_CURSED.get()) {
                            nbt.putBoolean("cursed", true);
                        }
                        if (eventItem.getItem() == ModItems.NUTRITIOUS_CHICKEN_FEED.get()) {
                            nbt.putBoolean("nutritious", true);
                        }
                        if (event.getEntity() instanceof ServerPlayer) {
                            PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)world), null, (double)entity2.getX(), (double)entity2.getY(), (double)entity2.getZ(), (double)32.0, (CustomPacketPayload)new ChickenSyncPacket(entity2, nbt), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                    }
                    Vec3 vec3d = entity2.getDeltaMovement();
                    entity2.setDeltaMovement(vec3d.x, 0.06, vec3d.z);
                    entity2.setNoGravity(true);
                    if (!event.getEntity().getAbilities().instabuild) {
                        event.getItemStack().shrink(1);
                    }
                }
            }
        }
    }
}

