/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.datagen;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MGULootTables
extends BlockLootSubProvider {
    protected MGULootTables(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    public static LootTableProvider getProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> future) {
        return new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(MGULootTables::new, LootContextParamSets.BLOCK)), future);
    }

    protected void generate() {
        this.dropSelf((Block)ModBlocks.ABSORPTION_HOPPER.getBlock());
        this.dropSelf(ModBlocks.DARK_OAK_STONE.getBlock());
        this.dropSelf(ModBlocks.DRAGON_MUFFLER.getBlock());
        this.dropSelf(ModBlocks.WITHER_MUFFLER.getBlock());
        this.dropSelf(ModBlocks.ENTITY_CONVEYOR.getBlock());
        this.dropSelf((Block)ModBlocks.FAN.getBlock());
        this.dropSelf((Block)ModBlocks.SAW.getBlock());
        this.dropSelf((Block)ModBlocks.SPIKES.getBlock());
        this.dropSelf((Block)ModBlocks.XP_TAP.getBlock());
        this.dropSelf(ModBlocks.ENDER_INHIBITOR_ON.getBlock());
        this.dropOther(ModBlocks.ENDER_INHIBITOR_OFF.getBlock(), (ItemLike)ModBlocks.ENDER_INHIBITOR_ON.getItem());
        this.dropSelf(ModBlocks.TINTED_GLASS.getBlock());
        this.add(ModBlocks.DREADFUL_DIRT.getBlock(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.DIRT));
        this.add(ModBlocks.DELIGHTFUL_DIRT.getBlock(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.DIRT));
        this.dropSelf((Block)ModBlocks.SOLID_XP_BLOCK.getBlock());
        this.dropSelf(ModBlocks.ENTITY_SPAWNER.getBlock());
    }

    @Nonnull
    protected Iterable<Block> getKnownBlocks() {
        ImmutableSet ignoreList = ImmutableSet.of((Object)((Object)ModBlocks.TANK.getBlock()), (Object)((Object)ModBlocks.TANK_SINK.getBlock()), (Object)((Object)ModBlocks.JUMBO_TANK.getBlock()), (Object)((Object)ModBlocks.XPSOLIDIFIER.getBlock()), (Object)((Block)ModBlocks.FLUID_XP_BLOCK.get()));
        return ModBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(arg_0 -> MGULootTables.lambda$getKnownBlocks$2((Set)ignoreList, arg_0)).collect(Collectors.toList());
    }

    private static /* synthetic */ boolean lambda$getKnownBlocks$2(Set ignoreList, Block e) {
        return !ignoreList.contains(e);
    }
}

