/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.components.MGUComponents;
import mob_grinding_utils.tile.TileEntityTank;
import mob_grinding_utils.util.CapHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class BlockTank
extends BaseEntityBlock {
    public static final MapCodec<BlockTank> CODEC = BlockTank.simpleCodec(BlockTank::new);

    public BlockTank(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nonnull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileEntityTank(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, @Nonnull BlockState pState, @Nonnull BlockEntityType<T> pBlockEntityType) {
        return pLevel.isClientSide ? null : TileEntityTank::serverTick;
    }

    @Nonnull
    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nonnull
    public BlockState playerWillDestroy(Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        BlockEntity blockEntity;
        if (!world.isClientSide && !player.getAbilities().instabuild && (blockEntity = world.getBlockEntity(pos)) instanceof TileEntityTank) {
            TileEntityTank entityTank = (TileEntityTank)blockEntity;
            ItemStack stack = new ItemStack((ItemLike)Item.byBlock((Block)this), 1);
            if (entityTank.tank.getFluidAmount() > 0) {
                stack.set(MGUComponents.FLUID, (Object)entityTank.tank.getFluid());
            }
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            world.removeBlockEntity(pos);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void setPlacedBy(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(world, pos, state, placer, stack);
        if (!world.isClientSide && stack.has(MGUComponents.FLUID) && (blockEntity = world.getBlockEntity(pos)) instanceof TileEntityTank) {
            FluidStack fluid = (FluidStack)stack.getOrDefault(MGUComponents.FLUID, (Object)FluidStack.EMPTY);
            ((TileEntityTank)blockEntity).tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Nonnull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof TileEntityTank) {
            Optional<IFluidHandler> fluidHandler = CapHelper.getFluidHandler(world, pos, hit.getDirection());
            fluidHandler.ifPresent(handler -> {
                if (player.getItemInHand(hand).isEmpty() || !FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)world, (BlockPos)pos, (Direction)hit.getDirection())) {
                    if (!handler.getFluidInTank(0).isEmpty()) {
                        player.displayClientMessage((Component)Component.literal((String)(handler.getFluidInTank(0).getHoverName().getString() + ": " + handler.getFluidInTank(0).getAmount() + "/" + handler.getTankCapacity(0))), true);
                    } else {
                        player.displayClientMessage((Component)Component.literal((String)("Empty: 0/" + handler.getTankCapacity(0))), true);
                    }
                }
            });
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

