/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;

public class Command {
    public LiteralArgumentBuilder<CommandSourceStack> build(CommandBuildContext buildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"structureessentials").then(Commands.literal((String)"getBiomeTags").then(Commands.argument((String)"biome", (ArgumentType)ResourceOrTagArgument.resourceOrTag((CommandBuildContext)buildContext, (ResourceKey)Registries.BIOME)).executes(context -> {
            ResourceKey biome = ((Holder.Reference)ResourceOrTagArgument.getResourceOrTag((CommandContext)context, (String)"biome", (ResourceKey)Registries.BIOME).unwrap().left().get()).key();
            List biomeTags = ((Holder.Reference)((Registry)((CommandSourceStack)context.getSource()).registryAccess().registry(Registries.BIOME).get()).getHolder(biome).get()).tags().collect(Collectors.toList());
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Biome tags for: " + String.valueOf(biome.location()))).withStyle(ChatFormatting.GOLD));
            for (TagKey biomeTag : biomeTags) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("#" + String.valueOf(biomeTag.location()))));
            }
            return 1;
        })))).then(Commands.literal((String)"getBiomesForTag").then(Commands.argument((String)"biome", (ArgumentType)ResourceOrTagArgument.resourceOrTag((CommandBuildContext)buildContext, (ResourceKey)Registries.BIOME)).executes(context -> {
            TagKey biomeTag = ((HolderSet.Named)ResourceOrTagArgument.getResourceOrTag((CommandContext)context, (String)"biome", (ResourceKey)Registries.BIOME).unwrap().right().get()).key();
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Biomes for tag: " + String.valueOf(biomeTag.location()))).withStyle(ChatFormatting.GOLD));
            for (Holder biomeHolder : ((Registry)((CommandSourceStack)context.getSource()).registryAccess().registry(Registries.BIOME).get()).asHolderIdMap()) {
                if (!biomeHolder.is(biomeTag)) continue;
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Biome: " + String.valueOf(((ResourceKey)biomeHolder.unwrapKey().get()).location()))));
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"getStructuresNearby").requires(stack -> stack.hasPermission(2))).executes(context -> {
            ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
            HashMap<Structure, LongSet> structures = new HashMap<Structure, LongSet>();
            ChunkPos start = new ChunkPos(BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition()));
            for (int x = -5; x < 5; ++x) {
                for (int z = -5; z < 5; ++z) {
                    for (Map.Entry entry : world.structureManager().getAllStructuresAt(new BlockPos(start.x + x << 4, 0, start.z + z << 4)).entrySet()) {
                        structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
                    }
                }
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"Structures nearby: ").withStyle(ChatFormatting.GOLD));
            HashMap structurePositions = new HashMap();
            for (Map.Entry structureEntry : structures.entrySet()) {
                world.structureManager().fillStartsForStructure((Structure)structureEntry.getKey(), (LongSet)structureEntry.getValue(), structureStart -> structurePositions.put(structureStart.getBoundingBox().getCenter(), ((Registry)((CommandSourceStack)context.getSource()).registryAccess().registry(Registries.STRUCTURE).get()).getKey((Object)((Structure)structureEntry.getKey())).toString()));
            }
            ArrayList sortedStructures = new ArrayList(structurePositions.entrySet());
            sortedStructures.sort(Comparator.comparingDouble(p -> ((BlockPos)p.getKey()).distSqr((Vec3i)BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition()))));
            for (Map.Entry structureEntry : sortedStructures) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)((String)structureEntry.getValue())).append((Component)Component.literal((String)(" " + String.valueOf(structureEntry.getKey()))).withStyle(ChatFormatting.YELLOW).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + ((BlockPos)structureEntry.getKey()).getX() + " " + ((BlockPos)structureEntry.getKey()).getY() + " " + ((BlockPos)structureEntry.getKey()).getZ())))));
            }
            return 1;
        }))).then(Commands.literal((String)"getSimilarForBiome").then(Commands.argument((String)"biome", (ArgumentType)ResourceOrTagArgument.resourceOrTag((CommandBuildContext)buildContext, (ResourceKey)Registries.BIOME)).executes(context -> {
            int i;
            ResourceKey biome = ((Holder.Reference)ResourceOrTagArgument.getResourceOrTag((CommandContext)context, (String)"biome", (ResourceKey)Registries.BIOME).unwrap().left().get()).key();
            List biomeTags = ((Holder.Reference)((Registry)((CommandSourceStack)context.getSource()).registryAccess().registry(Registries.BIOME).get()).getHolder(biome).get()).tags().collect(Collectors.toList());
            ArrayList<Object> similarBiomes = new ArrayList<Object>();
            for (Object currentBiome : ((Registry)((CommandSourceStack)context.getSource()).registryAccess().registry(Registries.BIOME).get()).asHolderIdMap()) {
                for (Object tag : biomeTags) {
                    if (!currentBiome.is((TagKey)tag)) continue;
                    similarBiomes.add(currentBiome);
                }
            }
            HashMap<Holder, Integer> countMap = new HashMap<Holder, Integer>();
            for (Holder holder : similarBiomes) {
                for (TagKey similarBiomeTagKey : holder.tags().toList()) {
                    if (biomeTags.contains(similarBiomeTagKey)) {
                        countMap.put(holder, countMap.getOrDefault(holder, 0) + 2);
                        continue;
                    }
                    countMap.put(holder, countMap.getOrDefault(holder, 0) - 1);
                }
            }
            ArrayList sortedBiomeHolders = new ArrayList(countMap.entrySet());
            sortedBiomeHolders.sort(Comparator.comparingInt(e -> (Integer)((Map.Entry)e).getValue()).reversed());
            HashMap<TagKey, Double> hashMap = new HashMap<TagKey, Double>();
            for (i = 0; i < sortedBiomeHolders.size(); ++i) {
                double weight = ((double)sortedBiomeHolders.size() / 6.0 - (double)i) / ((double)sortedBiomeHolders.size() / 6.0);
                if ((double)i > (double)sortedBiomeHolders.size() / 6.0) {
                    weight = -((double)i - (double)sortedBiomeHolders.size() * 0.16666666666666666) / ((double)sortedBiomeHolders.size() * 0.8333333333333334);
                }
                Map.Entry biomeHolderEntry = (Map.Entry)sortedBiomeHolders.get(i);
                for (TagKey biomeHolderEntryTag : ((Holder)biomeHolderEntry.getKey()).tags().toList()) {
                    if (!biomeTags.contains(biomeHolderEntryTag)) continue;
                    hashMap.put(biomeHolderEntryTag, hashMap.getOrDefault(biomeHolderEntryTag, 0.0) + 1.0 * weight);
                }
            }
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Similar biomes for: " + String.valueOf(biome.location()))).withStyle(ChatFormatting.GOLD));
            for (i = 0; i < sortedBiomeHolders.size() && i < 10; ++i) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Weight:" + String.valueOf(((Map.Entry)sortedBiomeHolders.get(i)).getValue()) + " Biome: " + String.valueOf(((ResourceKey)((Holder)((Map.Entry)sortedBiomeHolders.get(i)).getKey()).unwrap().left().get()).location()))));
            }
            ArrayList sortedBiomeTagKeys = new ArrayList(hashMap.entrySet());
            sortedBiomeTagKeys.sort(Comparator.comparingDouble(e -> (Double)((Map.Entry)e).getValue()).reversed());
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Similar biome tags for: " + String.valueOf(biome.location()))).withStyle(ChatFormatting.GOLD));
            for (Map.Entry entry : sortedBiomeTagKeys) {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Weight:" + Math.round((Double)entry.getValue()) + " Tag: #" + String.valueOf(((TagKey)entry.getKey()).location()))));
            }
            return 1;
        })));
    }
}

