/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import commoble.bagofyurting.BagOfYurtingData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record CompressedBagOfYurtingData(List<BlockState> states, List<CompressedStateData> data) {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Codec<CompressedBagOfYurtingData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockState.CODEC.listOf().fieldOf("states").forGetter(CompressedBagOfYurtingData::states), (App)CompressedStateData.CODEC.listOf().fieldOf("data").forGetter(CompressedBagOfYurtingData::data)).apply((Applicative)builder, CompressedBagOfYurtingData::new));

    public BagOfYurtingData uncompress() {
        HashMap<BlockPos, BagOfYurtingData.StateData> map = new HashMap<BlockPos, BagOfYurtingData.StateData>();
        this.data.forEach(compressedData -> {
            BlockPos pos = compressedData.pos;
            int index = compressedData.stateIndex;
            BlockState state = this.states.get(index);
            CompoundTag nbt = compressedData.getNBT().orElseGet(CompoundTag::new);
            BagOfYurtingData.StateData data = new BagOfYurtingData.StateData(state, nbt);
            map.put(pos, data);
        });
        return new BagOfYurtingData(map);
    }

    public CompoundTag toNBT() {
        return (CompoundTag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(CompoundTag::new);
    }

    public static CompressedBagOfYurtingData fromNBT(CompoundTag nbt) {
        return CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(() -> new CompressedBagOfYurtingData(new ArrayList<BlockState>(), new ArrayList<CompressedStateData>()));
    }

    public static class CompressedStateData {
        public static final Codec<CompressedStateData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(CompressedStateData::getPos), (App)Codec.INT.fieldOf("state").forGetter(CompressedStateData::getStateIndex), (App)CompoundTag.CODEC.optionalFieldOf("nbt").forGetter(CompressedStateData::getNBT)).apply((Applicative)builder, CompressedStateData::new));
        private final BlockPos pos;
        private final int stateIndex;
        private final Optional<CompoundTag> nbt;

        public BlockPos getPos() {
            return this.pos;
        }

        public int getStateIndex() {
            return this.stateIndex;
        }

        public Optional<CompoundTag> getNBT() {
            return this.nbt;
        }

        public CompressedStateData(BlockPos pos, int stateIndex, Optional<CompoundTag> nbt) {
            this.pos = pos;
            this.stateIndex = stateIndex;
            this.nbt = nbt;
        }
    }
}

