/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting;

import commoble.bagofyurting.BagOfYurtingMod;
import commoble.bagofyurting.BlockRemovalSorter;
import commoble.bagofyurting.BlockUnloadSorter;
import commoble.bagofyurting.CompressedBagOfYurtingData;
import commoble.bagofyurting.OptionalSpawnParticlesPacket;
import commoble.bagofyurting.TransientPlayerData;
import commoble.bagofyurting.util.RotationUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3f;

public class BagOfYurtingData {
    public static final String NBT_KEY = "yurtdata";
    public static final Direction BASE_DIRECTION = Direction.SOUTH;
    private final Map<BlockPos, StateData> map;
    public static final AABB EMPTY_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BagOfYurtingData(Map<BlockPos, StateData> map) {
        this.map = map;
    }

    public static BagOfYurtingData yurtBlocksAndConvertToData(UseOnContext context, int radius) {
        Player player = context.getPlayer();
        boolean canPlayerOverrideSafetyLists = BagOfYurtingData.canPlayerOverrideSafetyLists(player);
        BlockPos origin = context.getClickedPos();
        Direction orientation = context.getHorizontalDirection();
        Level level = context.getLevel();
        Rotation rotation = RotationUtil.getTransformRotation(orientation);
        BlockPos minYurt = origin.offset(-radius, 0, -radius);
        BlockPos maxYurt = origin.offset(radius, 2 * radius, radius);
        List<Pair> transformPairs = BlockPos.betweenClosedStream((BlockPos)minYurt, (BlockPos)maxYurt).filter(pos -> BagOfYurtingData.canBlockBeStored(canPlayerOverrideSafetyLists, context, pos)).map(BlockPos::immutable).sorted(new BlockRemovalSorter(level)).map(pos -> BagOfYurtingData.getTransformedPosAndStateData((LevelAccessor)level, pos, rotation, minYurt, maxYurt, origin)).collect(Collectors.toList());
        BlockState air = Blocks.AIR.defaultBlockState();
        transformPairs.forEach(pair -> {
            BlockPos pos = (BlockPos)pair.getLeft();
            level.removeBlockEntity(pos);
            level.setBlock(pos, air, 0);
        });
        List<BlockPos> removedPositions = transformPairs.stream().map(Pair::getLeft).collect(Collectors.toList());
        Map<BlockPos, StateData> transformedData = transformPairs.stream().map(Pair::getRight).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        if (transformPairs.size() > 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BagOfYurtingData.doPoofEffects(serverLevel, removedPositions);
            for (Pair entry : transformPairs) {
                BlockPos pos2 = (BlockPos)entry.getKey();
                BlockState oldState = ((StateData)((Pair)entry.getValue()).getRight()).state;
                BagOfYurtingData.sendBlockUpdateAfterRemoval(level, pos2, oldState);
            }
        }
        return new BagOfYurtingData(transformedData);
    }

    private static void sendBlockUpdateAfterRemoval(Level level, BlockPos pos, BlockState oldState) {
        level.sendBlockUpdated(pos, oldState, Blocks.AIR.defaultBlockState(), 3);
        level.updateNeighborsAt(pos, oldState.getBlock());
    }

    public boolean attemptUnloadIntoLevel(UseOnContext context, int radius) {
        boolean success;
        BlockPos hitPos;
        Level level = context.getLevel();
        boolean hitBlockReplaceable = level.getBlockState(hitPos = context.getClickedPos()).canBeReplaced();
        BlockPos origin = hitBlockReplaceable ? hitPos : hitPos.relative(context.getClickedFace());
        Direction orientation = context.getHorizontalDirection();
        Rotation unrotation = RotationUtil.getUntransformRotation(orientation);
        Player player = context.getPlayer();
        boolean canPlayerOverrideSafetyLists = BagOfYurtingData.canPlayerOverrideSafetyLists(player);
        Map<BlockPos, StateData> LevelPositions = this.map.entrySet().stream().collect(Collectors.toMap(entry -> RotationUtil.untransformBlockPos(unrotation, (BlockPos)entry.getKey(), origin), entry -> (StateData)entry.getValue()));
        boolean bl = success = LevelPositions.entrySet().stream().allMatch(entry -> BagOfYurtingData.canBlockBeUnloadedAt(canPlayerOverrideSafetyLists, (BlockPos)entry.getKey(), level)) && BagOfYurtingData.doesPlaceEventSucceed(context, level, player, LevelPositions);
        if (success) {
            BlockPos minYurt = origin.offset(-radius, 0, -radius);
            BlockPos maxYurt = origin.offset(radius, 2 * radius, radius);
            List<Map.Entry> LevelPositionList = LevelPositions.entrySet().stream().sorted(BlockUnloadSorter.INSTANCE).collect(Collectors.toList());
            LevelPositionList.forEach(entry -> ((StateData)entry.getValue()).setBlockIntoLevel(level, (BlockPos)entry.getKey(), unrotation));
            LevelPositionList.forEach(entry -> ((StateData)entry.getValue()).setBlockEntityData(level, (BlockPos)entry.getKey(), unrotation, minYurt, maxYurt, origin));
            if (level instanceof ServerLevel) {
                BagOfYurtingData.doPoofEffects((ServerLevel)level, LevelPositions.keySet());
            }
        }
        return success;
    }

    private static void doPoofEffects(ServerLevel Level2, Collection<BlockPos> changedPositions) {
        AABB aabb = changedPositions.stream().map(AABB::new).reduce(AABB::minmax).orElse(EMPTY_AABB);
        if (aabb.getSize() > 0.5) {
            Vec3 center = aabb.getCenter();
            double xRadius = aabb.getXsize() * 0.5;
            double yRadius = aabb.getYsize() * 0.5;
            double zRadius = aabb.getZsize() * 0.5;
            double volume = xRadius * yRadius * zRadius * 8.0;
            int particles = Math.max(5000, (int)volume * 5);
            Level2.playSound(null, new BlockPos((int)center.x, (int)center.y, (int)center.z), SoundEvents.EVOKER_CAST_SPELL, SoundSource.PLAYERS, 1.0f, 1.0f);
            OptionalSpawnParticlesPacket.spawnParticlesFromServer(Level2, (ParticleOptions)ParticleTypes.EXPLOSION, center, new Vector3f((float)xRadius, (float)yRadius, (float)zRadius), particles);
        }
    }

    private static boolean canPlayerOverrideSafetyLists(@Nullable Player player) {
        if (player != null && (player.isCreative() || player.hasPermissions(((Integer)BagOfYurtingMod.get().serverConfig().minPermissionToYurtUnyurtableBlocks().get()).intValue()))) {
            return TransientPlayerData.isPlayerOverridingSafetyList(player.getUUID());
        }
        return false;
    }

    private static boolean canBlockBeStored(boolean canPlayerOverrideSafetyLists, UseOnContext context, BlockPos pos) {
        Level Level2 = context.getLevel();
        BlockState state = Level2.getBlockState(pos);
        Player player = context.getPlayer();
        return !state.isAir() && !Level2.isOutsideBuildHeight(pos) && BagOfYurtingData.isBlockYurtingAllowedByTags(canPlayerOverrideSafetyLists, state, pos) && BagOfYurtingData.doesBreakEventSucceed(Level2, pos, state, player);
    }

    private static boolean isBlockYurtingAllowedByTags(boolean canPlayerOverrideSafetyLists, BlockState state, BlockPos pos) {
        if (canPlayerOverrideSafetyLists) {
            return true;
        }
        return !state.is(BagOfYurtingMod.Tags.Blocks.BLACKLIST) && (BuiltInRegistries.BLOCK.getOrCreateTag(BagOfYurtingMod.Tags.Blocks.WHITELIST).size() == 0 || state.is(BagOfYurtingMod.Tags.Blocks.WHITELIST));
    }

    private static boolean doesBreakEventSucceed(Level Level2, BlockPos pos, BlockState state, Player player) {
        if (!(Level2 instanceof ServerLevel)) {
            return false;
        }
        Player eventPlayer = player != null ? player : FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)Level2));
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(Level2, pos, state, eventPlayer);
        NeoForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    private static boolean doesPlaceEventSucceed(UseOnContext context, Level level, Player player, Map<BlockPos, StateData> levelPositions) {
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        Player eventPlayer = player != null ? player : FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)level));
        List snapshots = levelPositions.keySet().stream().map(pos -> BlockSnapshot.create((ResourceKey)level.dimension(), (LevelAccessor)level, (BlockPos)pos)).collect(Collectors.toList());
        BlockState statePlacedAgainst = level.getBlockState(context.getClickedPos());
        BlockEvent.EntityMultiPlaceEvent event = new BlockEvent.EntityMultiPlaceEvent(snapshots, statePlacedAgainst, (Entity)eventPlayer);
        NeoForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    private static Pair<BlockPos, Pair<BlockPos, StateData>> getTransformedPosAndStateData(LevelAccessor Level2, BlockPos absolutePos, Rotation rotation, BlockPos minYurt, BlockPos maxYurt, BlockPos origin) {
        BlockPos transformedPos = RotationUtil.transformBlockPos(rotation, absolutePos, origin);
        StateData stateData = BagOfYurtingData.getYurtedStateData(Level2, absolutePos, rotation, minYurt, maxYurt, origin, transformedPos);
        return Pair.of((Object)absolutePos, (Object)Pair.of((Object)transformedPos, (Object)stateData));
    }

    private static StateData getYurtedStateData(LevelAccessor Level2, BlockPos pos, Rotation rotation, BlockPos minYurt, BlockPos maxYurt, BlockPos origin, BlockPos transformedPos) {
        BlockState state = Level2.getBlockState(pos);
        BlockState rotatedState = state.rotate(Level2, pos, rotation);
        BlockEntity te = Level2.getBlockEntity(pos);
        CompoundTag nbt = te == null ? new CompoundTag() : te.saveWithoutMetadata((HolderLookup.Provider)Level2.registryAccess());
        return new StateData(rotatedState, nbt);
    }

    private static boolean canBlockBeUnloadedAt(boolean canPlayerOverrideSafetyLists, BlockPos pos, Level Level2) {
        if (canPlayerOverrideSafetyLists) {
            return true;
        }
        BlockState oldState = Level2.getBlockState(pos);
        return oldState.isAir() || oldState.canBeReplaced() || oldState.is(BagOfYurtingMod.Tags.Blocks.REPLACEABLE);
    }

    public static boolean doesNBTContainYurtData(CompoundTag nbt) {
        return !nbt.getList(NBT_KEY, 10).isEmpty();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public CompressedBagOfYurtingData compress() {
        Object2IntOpenHashMap indexMap = new Object2IntOpenHashMap();
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        ArrayList<CompressedBagOfYurtingData.CompressedStateData> data = new ArrayList<CompressedBagOfYurtingData.CompressedStateData>();
        this.map.forEach((arg_0, arg_1) -> BagOfYurtingData.lambda$compress$10((Object2IntMap)indexMap, states, data, arg_0, arg_1));
        return new CompressedBagOfYurtingData(states, data);
    }

    private static /* synthetic */ void lambda$compress$10(Object2IntMap indexMap, List states, List data, BlockPos pos, StateData stateData) {
        BlockState state = stateData.state;
        CompoundTag nbt = stateData.blockEntityData;
        Optional<CompoundTag> optionalNBT = nbt == null || nbt.isEmpty() ? Optional.empty() : Optional.of(nbt);
        int index = indexMap.computeIfAbsent((Object)state, newState -> {
            int newIndex = states.size();
            states.add(state);
            return newIndex;
        });
        CompressedBagOfYurtingData.CompressedStateData compressedData = new CompressedBagOfYurtingData.CompressedStateData(pos, index, optionalNBT);
        data.add(compressedData);
    }

    public static class StateData {
        public static final String BLOCKSTATE = "state";
        public static final String TILE = "data";
        @Nonnull
        private final BlockState state;
        @Nonnull
        private final CompoundTag blockEntityData;

        public StateData(@Nonnull BlockState state, @Nonnull CompoundTag BlockEntityData) {
            this.state = state;
            this.blockEntityData = BlockEntityData;
        }

        public BlockState getState() {
            return this.state;
        }

        public void setBlockIntoLevel(Level level, BlockPos pos, Rotation unrotation) {
            level.setBlockAndUpdate(pos, this.state.rotate((LevelAccessor)level, pos, unrotation));
        }

        public void setBlockEntityData(Level level, BlockPos pos, Rotation unrotation, BlockPos minYurt, BlockPos maxYurt, BlockPos origin) {
            BlockEntity te;
            if (!this.blockEntityData.isEmpty() && (te = level.getBlockEntity(pos)) != null) {
                te.loadWithComponents(this.blockEntityData, (HolderLookup.Provider)level.registryAccess());
            }
        }
    }
}

