/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.loader.neoforge.config;

import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.config.ConfigHandler;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class ConfigHandlerNeoForge
extends ConfigHandler {
    private IdentityHashMap<ConfigBase.Category.Entry, ModConfigSpec.ConfigValue> entryToValues;
    private ModConfig modConfig;

    private static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        ConfigHandlerNeoForge.onServerConnect();
    }

    private static void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        ConfigHandlerNeoForge.onServerDisconnect();
    }

    public ConfigHandlerNeoForge(ConfigBase config, IEventBus bus) {
        super(config);
        this.registerListeners(bus);
    }

    @Override
    public void init() {
        this.entryToValues = new IdentityHashMap();
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        boolean inCat = false;
        for (ConfigBase.Category cat : this.config.categories) {
            if (inCat) {
                builder.pop();
            }
            inCat = true;
            if (cat.comment != null) {
                builder.comment(cat.comment);
            }
            if (cat.commentKey != null) {
                builder.translation(cat.commentKey);
            }
            builder.push(cat.name);
            for (ConfigBase.Category.Entry e : cat.getEntries()) {
                Prop prop;
                if (e.prop.skip()) continue;
                if (e.comment != null) {
                    builder.comment(e.comment);
                }
                if (e.commentKey != null) {
                    builder.translation(e.commentKey);
                }
                if ((prop = e.prop).needsRestart()) {
                    builder.worldRestart();
                }
                ModConfigSpec.BooleanValue value = null;
                Class<?> clz = e.field.getType();
                String fieldName = e.field.getName();
                try {
                    Object o = e.field.get(this.config);
                    if (clz == Integer.TYPE) {
                        value = builder.defineInRange(fieldName, ((Integer)o).intValue(), prop.intBool() ? 0 : (prop.min() == -1.7976931348623157E308 ? Integer.MIN_VALUE : (int)prop.min()), prop.intBool() ? 1 : (prop.max() == Double.MAX_VALUE ? Integer.MAX_VALUE : (int)prop.max()));
                    } else if (clz == Double.TYPE) {
                        value = builder.defineInRange(fieldName, ((Double)o).doubleValue(), prop.min(), prop.max());
                    } else if (clz == Boolean.TYPE) {
                        value = builder.define(fieldName, ((Boolean)o).booleanValue());
                    } else if (clz == String.class) {
                        if (prop.values().length != 1 || !prop.values()[0].isEmpty()) {
                            value = builder.defineInList(fieldName, (Object)((String)o), Arrays.asList(prop.values()));
                        } else if (prop.validator().equals("undefined") || prop.validator().isEmpty()) {
                            value = builder.define(fieldName, (Object)((String)o));
                        } else {
                            method = this.config.getValidatorMethod(prop.validator());
                            value = builder.define(fieldName, (Object)((String)o), x -> this.config.validate(method, x));
                        }
                    } else if (clz.isEnum()) {
                        value = builder.defineEnum(fieldName, (Enum)o);
                    } else if (o instanceof List) {
                        if (prop.validator().equals("undefined") || prop.validator().isEmpty()) {
                            value = builder.defineList(fieldName, (List)o, x -> true);
                        } else {
                            method = this.config.getValidatorMethod(prop.validator());
                            value = builder.defineList(fieldName, (List)o, x -> this.config.validate(method, x));
                        }
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    iChunUtil.LOGGER.error("Error with creating field {} for config {}", new Object[]{fieldName, this.config.getFileName(), ex});
                }
                if (value != null) {
                    this.entryToValues.put(e, (ModConfigSpec.ConfigValue)value);
                    continue;
                }
                throw new RuntimeException("Value should never be null");
            }
        }
        if (!this.config.categories.isEmpty()) {
            builder.pop();
        }
        ModConfigSpec spec = builder.build();
        ModLoadingContext.get().getActiveContainer().registerConfig(this.config.getConfigType() == ConfigBase.Type.COMMON ? ModConfig.Type.COMMON : (this.config.getConfigType() == ConfigBase.Type.CLIENT ? ModConfig.Type.CLIENT : ModConfig.Type.SERVER), (IConfigSpec)spec, this.config.getFileName());
        this.config.setSaveMethod(() -> {
            if (spec.isLoaded() && this.updateConfigValuesFromFields()) {
                spec.save();
            }
        });
    }

    private void registerListeners(IEventBus bus) {
        bus.addListener(this::onConfigLoad);
        bus.addListener(this::onConfigReload);
    }

    private void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getFileName().equals(this.config.getFileName())) {
            this.checkForChangesFromFile(false);
            this.config.onConfigLoaded();
        }
    }

    private void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getFileName().equals(this.config.getFileName())) {
            this.checkForChangesFromFile(true);
        }
    }

    @Override
    protected void checkForChangesFromFile(boolean reload) {
        for (ConfigBase.Category cat : this.config.categories) {
            for (ConfigBase.Category.Entry e : cat.getEntries()) {
                if (e.prop.skip()) continue;
                ModConfigSpec.ConfigValue configValue = this.entryToValues.get(e);
                Object o = configValue.get();
                try {
                    e.field.setAccessible(true);
                    Object oldObj = e.field.get(this.config);
                    if (o.equals(oldObj)) continue;
                    e.field.set(this.config, o);
                    if (!reload) continue;
                    this.config.onPropertyChanged(true, e.field.getName(), e.field, oldObj, o);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    iChunUtil.LOGGER.error("Error with updating field {} for config value {} for config {}", new Object[]{e.field.getName(), o, this.config.getFileName(), ex});
                }
            }
        }
    }

    private boolean updateConfigValuesFromFields() {
        boolean dirty = false;
        for (ConfigBase.Category cat : this.config.categories) {
            for (ConfigBase.Category.Entry e : cat.getEntries()) {
                if (e.prop.skip()) continue;
                ModConfigSpec.ConfigValue configValue = this.entryToValues.get(e);
                Object o = configValue.get();
                try {
                    e.field.setAccessible(true);
                    Object oldObj = e.field.get(this.config);
                    if (o.equals(oldObj)) continue;
                    configValue.set(oldObj);
                    dirty = true;
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    iChunUtil.LOGGER.error("Error with updating field {} for config value {} for config {}", new Object[]{e.field.getName(), o, this.config.getFileName(), ex});
                }
            }
        }
        return dirty;
    }

    static {
        if (iChunUtil.d().getSide().isClient()) {
            NeoForge.EVENT_BUS.addListener(ConfigHandlerNeoForge::onPlayerLoggedInEvent);
            NeoForge.EVENT_BUS.addListener(ConfigHandlerNeoForge::onPlayerLoggedOutEvent);
        }
    }
}

