/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public final class StringUtil {
    public static final Gson GSON = new Gson();
    public static final Gson GSON_PRETTY = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Random RAND = new Random();
    public static final Random SEEDED_RAND = new Random();
    public static final int IDENTIFIER_LENGTH = 20;
    private static final HashMap<Class<?>, Function<Object, List<String>>> OBJECT_INTERPRETER = (HashMap)Util.make(new HashMap(), m -> {
        m.put(File.class, o -> {
            File file = (File)o;
            ArrayList<String> info = new ArrayList<String>();
            info.add(file.getName());
            info.add(new SimpleDateFormat().format(new Date(file.lastModified())));
            info.add(StringUtil.readableFileSize(file.length()));
            return info;
        });
        m.put(Path.class, o -> {
            Path path = (Path)o;
            if (Files.isDirectory(path, new LinkOption[0])) {
                ArrayList<String> info = new ArrayList<String>();
                info.add(path.getFileName().toString());
                info.add("Folder");
                return info;
            }
            return StringUtil.getInterpretedInfo(path.toFile());
        });
        m.put(Theme.class, o -> Collections.singletonList(((Theme)o).name + " - " + ((Theme)o).author));
        m.put(Entity.class, o -> Collections.singletonList(((Entity)o).getDisplayName().getString()));
        m.put(Class.class, o -> Collections.singletonList(((Class)o).getSimpleName()));
    });

    @NotNull
    public static List<String> getInterpretedInfo(Object o) {
        Map.Entry<Class<?>, Function<Object, List<String>>> lastEntryUsed = null;
        List<String> infos = null;
        for (Map.Entry<Class<?>, Function<Object, List<String>>> e : OBJECT_INTERPRETER.entrySet()) {
            if (!e.getKey().isInstance(o) || lastEntryUsed != null && e.getKey().isAssignableFrom(lastEntryUsed.getKey())) continue;
            lastEntryUsed = e;
            infos = e.getValue().apply(o);
        }
        if (infos == null) {
            infos = new ArrayList<String>();
            infos.add(o.toString());
        }
        return infos;
    }

    public static void registerObjectInterpreter(Class<?> clz, Function<Object, List<String>> function) {
        OBJECT_INTERPRETER.put(clz, function);
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB", "PB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static int getRandomColourForName(String s) {
        if (s.equalsIgnoreCase("System")) {
            return 0xFFCC00;
        }
        return Math.abs(s.hashCode()) & 0xFFFFFF;
    }

    public static ChatFormatting getRandomTextFormattingColorForName(String s) {
        if (s.equalsIgnoreCase("System")) {
            return ChatFormatting.RED;
        }
        ArrayList<ChatFormatting> formats = new ArrayList<ChatFormatting>();
        for (int i = 1; i < 15; ++i) {
            if (i == 12) continue;
            formats.add(ChatFormatting.values()[i]);
        }
        SEEDED_RAND.setSeed(Math.abs(s.hashCode()));
        return (ChatFormatting)formats.get(SEEDED_RAND.nextInt(formats.size()));
    }
}

