/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementTextField
extends Element<Fragment<?>> {
    public static final Predicate<String> INTEGERS = s -> {
        if (s.isEmpty() || s.equals("-")) {
            return true;
        }
        try {
            if (s.contains(".")) {
                return false;
            }
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    public static final Predicate<String> NUMBERS = s -> {
        if (s.isEmpty() || s.equals("-")) {
            return true;
        }
        try {
            if (s.contains("f") || s.contains("d") || s.contains("F") || s.contains("D")) {
                return false;
            }
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    public static final Predicate<String> FILE_SAFE = s -> {
        String[] invalidChars;
        if (s.isEmpty()) {
            return true;
        }
        for (String c : invalidChars = new String[]{"\\", "/", ":", "*", "?", "\"", "<", ">", "|"}) {
            if (!s.contains(c)) continue;
            return false;
        }
        return !s.startsWith(".");
    };
    protected EditBox widget;
    private String defaultText = "";
    private int maxStringLength = Short.MAX_VALUE;
    private Predicate<String> validator = s -> true;
    private BiFunction<String, Integer, FormattedCharSequence> textFormatter = (s, cursorPos) -> FormattedCharSequence.forward((String)s, (Style)Style.EMPTY);
    @Nullable
    private Consumer<String> responder;
    @Nullable
    private Consumer<String> enterResponder;
    private int lastLeft;
    private int lastTop;

    public ElementTextField(@NotNull Fragment parent) {
        super(parent);
    }

    public <T extends ElementTextField> T setDefaultText(String s) {
        this.defaultText = s;
        return (T)this;
    }

    public <T extends ElementTextField> T setValidator(Predicate<String> validator) {
        this.validator = validator;
        return (T)this;
    }

    public Predicate<String> getValidator() {
        return this.validator;
    }

    public <T extends ElementTextField> T setResponder(Consumer<String> responder) {
        this.responder = responder;
        return (T)this;
    }

    public Consumer<String> getResponder() {
        return this.responder;
    }

    public <T extends ElementTextField> T setEnterResponder(Consumer<String> responder) {
        this.enterResponder = responder;
        return (T)this;
    }

    public <T extends ElementTextField> T setMaxStringLength(int i) {
        this.maxStringLength = i;
        return (T)this;
    }

    public <T extends ElementTextField> T setTextFormatter(BiFunction<String, Integer, FormattedCharSequence> textFormatter) {
        this.textFormatter = textFormatter;
        return (T)this;
    }

    @Override
    public void init() {
        super.init();
        this.widget = new EditBox(this.getFontRenderer(), this.getLeft(), this.getTop(), this.width, this.height, (Component)Component.literal((String)"Text Field"));
        this.widget.setMaxLength(this.maxStringLength);
        this.widget.setValue(this.defaultText);
        this.widget.setFilter(this.validator);
        this.widget.setResponder(this.responder);
        this.widget.setFormatter(this.textFormatter);
        this.adjustWidget();
        this.lastLeft = this.getLeft();
        this.lastTop = this.getTop();
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ((Workspace)this.getWorkspace()).cursorState = Workspace.CURSOR_IBEAM;
        }
        if (this.lastLeft != this.getLeft() || this.lastTop != this.getTop()) {
            this.adjustWidget();
            this.lastLeft = this.getLeft();
            this.lastTop = this.getTop();
        }
        this.drawTextBox(graphics, mouseX, mouseY, partialTick);
    }

    public void drawTextBox(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.renderMinecraftStyle() > 0) {
            this.widget.setBordered(true);
            this.widget.render(graphics, mouseX, mouseY, partialTick);
        } else {
            PoseStack stack = graphics.pose();
            int[] colour = this.isMouseOver(mouseX, mouseY) ? this.getTheme().elementInputBackgroundHover : this.getTheme().elementInputBackgroundInactive;
            this.fill(graphics, this.getTheme().elementInputBorder, 0);
            this.fill(graphics, colour, 1);
            this.widget.setBordered(false);
            this.widget.render(graphics, mouseX, mouseY, partialTick);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void resize(Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        this.adjustWidget();
    }

    public void adjustWidget() {
        if (this.widget != null) {
            if (this.renderMinecraftStyle() > 0) {
                this.widget.setX(this.getLeft() + 1);
                this.widget.setY(this.getTop() + 1);
                this.widget.setWidth(this.width - 2);
                this.widget.setHeight(this.height - 2);
            } else {
                this.widget.setX(this.getLeft() + 5);
                int n = this.getTop() + 1;
                Objects.requireNonNull(this.getFontRenderer());
                this.widget.setY(n + (this.height - 9) / 2);
                this.widget.setWidth(this.width - 6);
                this.widget.setHeight(this.height - 2);
            }
        }
    }

    public boolean keyPressed(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        boolean flag = super.keyPressed(keyCode, p_keyPressed_2_, p_keyPressed_3_);
        if ((keyCode == 257 || keyCode == 335) && this.enterResponder != null) {
            this.enterResponder.accept(this.getText());
        }
        return flag;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.setFocused((GuiEventListener)this.widget);
            this.widget.setFocused(true);
            if (button == 1) {
                this.widget.setValue("");
            } else if (button == 2) {
                this.widget.insertText(Minecraft.getInstance().keyboardHandler.getClipboard());
            }
            this.widget.mouseClicked(mouseX, mouseY, button);
            return true;
        }
        return false;
    }

    @Override
    public void unfocus(@Nullable GuiEventListener guiReplacing) {
        super.unfocus(guiReplacing);
        this.widget.setFocused(false);
        this.setFocused(null);
    }

    @Override
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        if (((Fragment)this.parent).getFocused() != this) {
            this.setFocused((GuiEventListener)this.widget);
            this.widget.setFocused(true);
            return super.nextFocusPath(event);
        }
        return null;
    }

    public void setText(@NotNull String s) {
        if (this.widget == null) {
            iChunUtil.LOGGER.error("You're trying to set a text field widget whilst it is still null. Use setDefaultText instead");
            return;
        }
        this.widget.setValue(s);
    }

    public String getText() {
        return this.widget.getValue();
    }

    public EditBox getTextField() {
        return this.widget;
    }

    @Override
    public int getMinHeight() {
        return 12;
    }
}

