/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Consumer;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementClickable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementButton<T extends ElementButton>
extends ElementClickable<T> {
    @NotNull
    public String text;
    public boolean renderBackground = true;

    public ElementButton(@NotNull Fragment parent, String s, Consumer<T> callback) {
        super(parent, callback);
        this.text = I18n.get((String)s, (Object[])new Object[0]);
    }

    public ElementButton<T> disableBackground() {
        this.renderBackground = false;
        return this;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.renderBackground) {
            PoseStack stack = graphics.pose();
            if (this.renderMinecraftStyle() > 0) {
                this.renderMinecraftStyleButton(stack, this.getLeft(), this.getTop(), this.width, this.height, this.disabled || ((Fragment)this.parent).isDragging() && ((Fragment)this.parent).getFocused() == this ? Element.ButtonState.CLICK : (this.hover ? Element.ButtonState.HOVER : Element.ButtonState.IDLE));
            } else {
                this.fill(graphics, this.getTheme().elementButtonBorder, 0);
                int[] colour = this.disabled ? this.getTheme().elementButtonBackgroundInactive : (((Fragment)this.parent).isDragging() && ((Fragment)this.parent).getFocused() == this ? this.getTheme().elementButtonClick : (this.hover ? this.getTheme().elementButtonBackgroundHover : this.getTheme().elementButtonBackgroundActive));
                this.fill(graphics, colour, 1);
            }
        }
        this.renderText(graphics);
    }

    public void renderText(GuiGraphics graphics) {
        if (!this.text.isEmpty()) {
            String s = this.reString(this.text, this.width - 4);
            float f = (float)this.getLeft() + (float)(this.width - this.getFontRenderer().width(s)) / 2.0f;
            float f2 = this.getTop();
            Objects.requireNonNull(this.getFontRenderer());
            this.drawString(graphics, s, f, f2 + (float)(this.height - 9) / 2.0f + 1.0f);
        }
    }

    @Override
    @Nullable
    public String tooltip(double mouseX, double mouseY) {
        String s;
        if (!this.text.isEmpty() && !(s = this.reString(this.text, this.width - 4)).equals(this.text)) {
            String tooltip = super.tooltip(mouseX, mouseY);
            if (tooltip != null) {
                return this.text + " - " + tooltip;
            }
            return this.text;
        }
        return super.tooltip(mouseX, mouseY);
    }

    @Override
    public void onClickRelease() {
    }

    @Override
    public int getMinWidth() {
        return 14;
    }

    @Override
    public int getMinHeight() {
        return 14;
    }
}

