/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.mixin;

import dev.kosmx.playerAnim.core.impl.AnimationProcessor;
import dev.kosmx.playerAnim.core.util.SetableSupplier;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.IMutableModel;
import dev.kosmx.playerAnim.impl.IPlayerModel;
import dev.kosmx.playerAnim.impl.IUpperPartHelper;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import dev.kosmx.playerAnim.impl.animation.IBendHelper;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class}, priority=2000)
public class PlayerModelMixin<T extends LivingEntity>
extends HumanoidModel<T>
implements IPlayerModel {
    @Shadow
    @Final
    public ModelPart jacket;
    @Shadow
    @Final
    public ModelPart rightSleeve;
    @Shadow
    @Final
    public ModelPart leftSleeve;
    @Shadow
    @Final
    public ModelPart rightPants;
    @Shadow
    @Final
    public ModelPart leftPants;
    @Unique
    private final SetableSupplier<AnimationProcessor> emoteSupplier = new SetableSupplier();
    @Unique
    private boolean firstPersonNext = false;

    public PlayerModelMixin(ModelPart modelPart, Function<ResourceLocation, RenderType> function) {
        super(modelPart, function);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/model/geom/ModelPart;Z)V"}, at={@At(value="RETURN")})
    private void initBendableStuff(ModelPart modelPart, boolean bl, CallbackInfo ci) {
        IMutableModel thisWithMixin = (IMutableModel)((Object)this);
        this.emoteSupplier.set(null);
        thisWithMixin.setEmoteSupplier(this.emoteSupplier);
        this.addBendMutator(this.jacket, Direction.DOWN);
        this.addBendMutator(this.rightPants, Direction.UP);
        this.addBendMutator(this.rightSleeve, Direction.UP);
        this.addBendMutator(this.leftPants, Direction.UP);
        this.addBendMutator(this.leftSleeve, Direction.UP);
        ((IUpperPartHelper)this.rightSleeve).setUpperPart(true);
        ((IUpperPartHelper)this.leftSleeve).setUpperPart(true);
    }

    @Unique
    private void addBendMutator(ModelPart part, Direction d) {
        IBendHelper.INSTANCE.initBend(part, d);
    }

    @Unique
    private void setDefaultPivot() {
        this.leftLeg.setPos(1.9f, 12.0f, 0.0f);
        this.rightLeg.setPos(-1.9f, 12.0f, 0.0f);
        this.head.setPos(0.0f, 0.0f, 0.0f);
        this.rightArm.z = 0.0f;
        this.rightArm.x = -5.0f;
        this.leftArm.z = 0.0f;
        this.leftArm.x = 5.0f;
        this.body.xRot = 0.0f;
        this.rightLeg.z = 0.1f;
        this.leftLeg.z = 0.1f;
        this.rightLeg.y = 12.0f;
        this.leftLeg.y = 12.0f;
        this.head.y = 0.0f;
        this.head.zRot = 0.0f;
        this.body.y = 0.0f;
        this.body.x = 0.0f;
        this.body.z = 0.0f;
        this.body.yRot = 0.0f;
        this.body.zRot = 0.0f;
        this.head.xScale = 1.0f;
        this.head.yScale = 1.0f;
        this.head.zScale = 1.0f;
        this.body.xScale = 1.0f;
        this.body.yScale = 1.0f;
        this.body.zScale = 1.0f;
        this.rightArm.xScale = 1.0f;
        this.rightArm.yScale = 1.0f;
        this.rightArm.zScale = 1.0f;
        this.leftArm.xScale = 1.0f;
        this.leftArm.yScale = 1.0f;
        this.leftArm.zScale = 1.0f;
        this.rightLeg.xScale = 1.0f;
        this.rightLeg.yScale = 1.0f;
        this.rightLeg.zScale = 1.0f;
        this.leftLeg.xScale = 1.0f;
        this.leftLeg.yScale = 1.0f;
        this.leftLeg.zScale = 1.0f;
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="HEAD")})
    private void setDefaultBeforeRender(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        this.setDefaultPivot();
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/geom/ModelPart;copyFrom(Lnet/minecraft/client/model/geom/ModelPart;)V", ordinal=0)})
    private void setEmote(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        if (!this.firstPersonNext && livingEntity instanceof AbstractClientPlayer && ((IAnimatedPlayer)livingEntity).playerAnimator_getAnimation().isActive()) {
            AnimationApplier emote = ((IAnimatedPlayer)livingEntity).playerAnimator_getAnimation();
            this.emoteSupplier.set(emote);
            emote.updatePart("head", this.head);
            this.hat.copyFrom(this.head);
            emote.updatePart("leftArm", this.leftArm);
            emote.updatePart("rightArm", this.rightArm);
            emote.updatePart("leftLeg", this.leftLeg);
            emote.updatePart("rightLeg", this.rightLeg);
            emote.updatePart("torso", this.body);
        } else {
            this.firstPersonNext = false;
            this.emoteSupplier.set(null);
            PlayerModelMixin.resetBend(this.body);
            PlayerModelMixin.resetBend(this.leftArm);
            PlayerModelMixin.resetBend(this.rightArm);
            PlayerModelMixin.resetBend(this.leftLeg);
            PlayerModelMixin.resetBend(this.rightLeg);
        }
    }

    @Unique
    private static void resetBend(ModelPart part) {
        IBendHelper.INSTANCE.bend(part, null);
    }

    @Override
    public void playerAnimator_prepForFirstPersonRender() {
        this.firstPersonNext = true;
    }
}

