/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.minecraftApi;

import dev.kosmx.playerAnim.api.IPlayable;
import dev.kosmx.playerAnim.minecraftApi.codec.AnimationCodecs;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
public final class PlayerAnimationRegistry {
    private static final HashMap<ResourceLocation, IPlayable> animations = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(PlayerAnimationRegistry.class);

    @Nullable
    public static IPlayable getAnimation(@NotNull ResourceLocation identifier) {
        return animations.get(identifier);
    }

    @NotNull
    public static Optional<IPlayable> getAnimationOptional(@NotNull ResourceLocation identifier) {
        return Optional.ofNullable(PlayerAnimationRegistry.getAnimation(identifier));
    }

    public static Map<ResourceLocation, IPlayable> getAnimations() {
        return Map.copyOf(animations);
    }

    @NotNull
    public static Map<String, IPlayable> getModAnimations(@NotNull String modid) {
        HashMap<String, IPlayable> map = new HashMap<String, IPlayable>();
        for (Map.Entry<ResourceLocation, IPlayable> entry : animations.entrySet()) {
            if (!entry.getKey().getNamespace().equals(modid)) continue;
            map.put(entry.getKey().getPath(), entry.getValue());
        }
        return map;
    }

    @ApiStatus.Internal
    public static void resourceLoaderCallback(@NotNull ResourceManager manager) {
        Collection<IPlayable> a;
        String extension;
        animations.clear();
        for (Map.Entry resource : manager.listResources("player_animations", ignore -> true).entrySet()) {
            extension = AnimationCodecs.getExtension(((ResourceLocation)resource.getKey()).getPath());
            if (extension == null) continue;
            a = AnimationCodecs.deserialize(extension, () -> {
                try {
                    return ((Resource)resource.getValue()).open();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            for (IPlayable animation : a) {
                animations.put(ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)resource.getKey()).getNamespace(), (String)PlayerAnimationRegistry.serializeTextToString(animation.getName())), animation);
            }
        }
        for (Map.Entry resource : manager.listResources("player_animation", ignore -> true).entrySet()) {
            extension = AnimationCodecs.getExtension(((ResourceLocation)resource.getKey()).getPath());
            if (extension == null) continue;
            logger.warn("Animation {} is in wrong directory: \"player_animation\", please place it in \"player_animations\".", (Object)((ResourceLocation)resource.getKey()).getPath());
            a = AnimationCodecs.deserialize(extension, () -> {
                try {
                    return ((Resource)resource.getValue()).open();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            for (IPlayable animation : a) {
                animations.put(ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)resource.getKey()).getNamespace(), (String)PlayerAnimationRegistry.serializeTextToString(animation.getName())), animation);
            }
        }
    }

    public static String serializeTextToString(String arg) {
        try {
            MutableComponent component = Component.Serializer.fromJson((String)arg, (HolderLookup.Provider)RegistryAccess.EMPTY);
            if (component != null) {
                return component.getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arg.replace("\"", "");
    }
}

