/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.core.data.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import dev.kosmx.playerAnim.core.data.AnimationFormat;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Easing;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;

public class AnimationJson
implements JsonDeserializer<List<KeyframeAnimation>>,
JsonSerializer<KeyframeAnimation> {
    private static final int modVersion = 3;
    @ApiStatus.Internal
    public static final Gson GSON;

    @Deprecated
    @ApiStatus.Internal
    public static Type getListedTypeToken() {
        return new TypeToken<List<KeyframeAnimation>>(){}.getType();
    }

    public List<KeyframeAnimation> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject node = json.getAsJsonObject();
        if (!node.has("emote")) {
            throw new JsonParseException("not an emotecraft animation");
        }
        int version = 1;
        if (node.has("version")) {
            version = node.get("version").getAsInt();
        }
        KeyframeAnimation.AnimationBuilder emote = this.emoteDeserializer(node.getAsJsonObject("emote"), version);
        for (Map.Entry entry : node.entrySet()) {
            JsonElement value;
            String string = (String)entry.getKey();
            if (string.equals("uuid") || string.equals("comment") || string.equals("version") || !(value = (JsonElement)entry.getValue()).isJsonPrimitive()) continue;
            JsonPrimitive p = value.getAsJsonPrimitive();
            if (p.isBoolean()) {
                emote.extraData.put(string, p.getAsBoolean());
                continue;
            }
            if (p.isString()) {
                emote.extraData.put(string, p.getAsString());
                continue;
            }
            if (p.isNumber()) {
                emote.extraData.put(string, p.getAsDouble());
                continue;
            }
            emote.extraData.put(string, p.toString());
        }
        emote.name = node.get("name").toString();
        if (node.has("author")) {
            emote.author = node.get("author").toString();
        }
        if (node.has("description")) {
            emote.description = node.get("description").toString();
        }
        if (3 < version) {
            throw new JsonParseException(emote.name + " is version " + version + ". PlayerAnimator library can only process version 3.");
        }
        if (node.has("uuid")) {
            emote.uuid = UUID.fromString(node.get("uuid").getAsString());
        }
        emote.optimizeEmote();
        ArrayList<KeyframeAnimation> list = new ArrayList<KeyframeAnimation>();
        list.add(emote.build());
        return list;
    }

    private KeyframeAnimation.AnimationBuilder emoteDeserializer(JsonObject node, int version) throws JsonParseException {
        boolean degrees;
        KeyframeAnimation.AnimationBuilder builder = new KeyframeAnimation.AnimationBuilder(AnimationFormat.JSON_EMOTECRAFT);
        if (node.has("beginTick")) {
            builder.beginTick = node.get("beginTick").getAsInt();
        }
        builder.endTick = node.get("endTick").getAsInt();
        if (builder.endTick <= 0) {
            throw new JsonParseException("endTick must be bigger than 0");
        }
        if (node.has("isLoop") && node.has("returnTick")) {
            builder.isLooped = node.get("isLoop").getAsBoolean();
            builder.returnTick = node.get("returnTick").getAsInt();
            if (builder.isLooped && (builder.returnTick > builder.endTick || builder.returnTick < 0)) {
                throw new JsonParseException("return tick have to be smaller than endTick and not smaller than 0");
            }
        }
        if (node.has("nsfw")) {
            builder.nsfw = node.get("nsfw").getAsBoolean();
        }
        builder.stopTick = node.has("stopTick") ? node.get("stopTick").getAsInt() : builder.endTick;
        boolean bl = degrees = !node.has("degrees") || node.get("degrees").getAsBoolean();
        if (node.has("easeBeforeKeyframe")) {
            builder.isEasingBefore = node.get("easeBeforeKeyframe").getAsBoolean();
        }
        this.moveDeserializer(builder, node.getAsJsonArray("moves"), degrees, version);
        return builder;
    }

    private void moveDeserializer(KeyframeAnimation.AnimationBuilder emote, JsonArray node, boolean degrees, int version) {
        for (JsonElement n : node) {
            JsonObject obj = n.getAsJsonObject();
            int tick = obj.get("tick").getAsInt();
            String easing = obj.has("easing") ? obj.get("easing").getAsString() : "linear";
            int turn = obj.has("turn") ? obj.get("turn").getAsInt() : 0;
            for (Map.Entry entry : obj.entrySet()) {
                if (((String)entry.getKey()).equals("tick") || ((String)entry.getKey()).equals("comment") || ((String)entry.getKey()).equals("easing") || ((String)entry.getKey()).equals("turn")) continue;
                this.addBodyPartIfExists(emote, (String)entry.getKey(), (JsonElement)entry.getValue(), degrees, tick, easing, turn, version);
            }
        }
    }

    private void addBodyPartIfExists(KeyframeAnimation.AnimationBuilder emote, String name, JsonElement node, boolean degrees, int tick, String easing, int turn, int version) {
        if (version < 3 && name.equals("torso")) {
            name = "body";
        }
        KeyframeAnimation.StateCollection part = emote.getOrCreatePart(name);
        JsonObject partNode = node.getAsJsonObject();
        this.addPartIfExists(part.x, "x", partNode, degrees, tick, easing, turn);
        this.addPartIfExists(part.y, "y", partNode, degrees, tick, easing, turn);
        this.addPartIfExists(part.z, "z", partNode, degrees, tick, easing, turn);
        this.addPartIfExists(part.pitch, "pitch", partNode, degrees, tick, easing, turn);
        this.addPartIfExists(part.yaw, "yaw", partNode, degrees, tick, easing, turn);
        this.addPartIfExists(part.roll, "roll", partNode, degrees, tick, easing, turn);
        this.addPartIfExists(part.bend, "bend", partNode, degrees, tick, easing, turn);
        this.addPartIfExists(part.bendDirection, "axis", partNode, degrees, tick, easing, turn);
        this.addPartIfExists(part.scaleX, "scaleX", partNode, degrees, tick, easing, turn);
        this.addPartIfExists(part.scaleY, "scaleY", partNode, degrees, tick, easing, turn);
        this.addPartIfExists(part.scaleZ, "scaleZ", partNode, degrees, tick, easing, turn);
    }

    private void addPartIfExists(KeyframeAnimation.StateCollection.State part, String name, JsonObject node, boolean degrees, int tick, String easing, int turn) {
        if (node.has(name)) {
            part.addKeyFrame(tick, node.get(name).getAsFloat(), Easing.easeFromString(easing), turn, degrees);
        }
    }

    public JsonElement serialize(KeyframeAnimation emote, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject node = new JsonObject();
        KeyframeAnimation.StateCollection torso = emote.getPart("torso");
        if (torso != null && torso.isEnabled()) {
            node.addProperty("version", (Number)3);
        } else {
            node.addProperty("version", (Number)(emote.isEasingBefore ? 2 : 1));
        }
        emote.extraData.forEach((s, o) -> {
            if (o instanceof String) {
                String s1 = (String)o;
                try {
                    node.add(s, AnimationJson.asJson(s1));
                }
                catch (Throwable th) {
                    node.addProperty(s, s1);
                }
            } else if (o instanceof Number) {
                node.addProperty(s, (Number)o);
            } else if (o instanceof Boolean) {
                node.addProperty(s, Boolean.valueOf((Boolean)o));
            } else if (o instanceof JsonElement) {
                node.add(s, (JsonElement)o);
            }
        });
        node.add("emote", (JsonElement)AnimationJson.emoteSerializer(emote));
        return node;
    }

    public static JsonElement asJson(String str) {
        return JsonParser.parseString((String)str);
    }

    public static JsonObject emoteSerializer(KeyframeAnimation emote) {
        JsonObject node = new JsonObject();
        node.addProperty("beginTick", (Number)emote.beginTick);
        node.addProperty("endTick", (Number)emote.endTick);
        node.addProperty("stopTick", (Number)emote.stopTick);
        node.addProperty("isLoop", Boolean.valueOf(emote.isInfinite));
        node.addProperty("returnTick", (Number)emote.returnToTick);
        node.addProperty("nsfw", Boolean.valueOf(emote.nsfw));
        node.addProperty("degrees", Boolean.valueOf(false));
        if (emote.isEasingBefore) {
            node.addProperty("easeBeforeKeyframe", Boolean.valueOf(true));
        }
        node.add("moves", (JsonElement)AnimationJson.moveSerializer(emote));
        return node;
    }

    public static JsonArray moveSerializer(KeyframeAnimation emote) {
        JsonArray node = new JsonArray();
        emote.getBodyParts().forEach((s, stateCollection) -> AnimationJson.bodyPartSerializer(node, stateCollection, s));
        return node;
    }

    private static void bodyPartSerializer(JsonArray node, KeyframeAnimation.StateCollection bodyPart, String partName) {
        AnimationJson.partSerialize(node, bodyPart.x, partName);
        AnimationJson.partSerialize(node, bodyPart.y, partName);
        AnimationJson.partSerialize(node, bodyPart.z, partName);
        AnimationJson.partSerialize(node, bodyPart.pitch, partName);
        AnimationJson.partSerialize(node, bodyPart.yaw, partName);
        AnimationJson.partSerialize(node, bodyPart.roll, partName);
        if (bodyPart.isBendable) {
            AnimationJson.partSerialize(node, bodyPart.bend, partName);
            AnimationJson.partSerialize(node, bodyPart.bendDirection, partName);
        }
        if (bodyPart.isScalable) {
            AnimationJson.partSerialize(node, bodyPart.scaleX, partName);
            AnimationJson.partSerialize(node, bodyPart.scaleY, partName);
            AnimationJson.partSerialize(node, bodyPart.scaleZ, partName);
        }
    }

    private static void partSerialize(JsonArray array, KeyframeAnimation.StateCollection.State part, String partName) {
        for (KeyframeAnimation.KeyFrame keyFrame : part.getKeyFrames()) {
            JsonObject node = new JsonObject();
            node.addProperty("tick", (Number)keyFrame.tick);
            node.addProperty("easing", keyFrame.ease.toString());
            JsonObject jsonMove = new JsonObject();
            jsonMove.addProperty(part.name, (Number)Float.valueOf(keyFrame.value));
            node.add(partName, (JsonElement)jsonMove);
            array.add((JsonElement)node);
        }
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        AnimationJson animationJson = new AnimationJson();
        builder.registerTypeAdapter(AnimationJson.getListedTypeToken(), (Object)animationJson);
        builder.registerTypeAdapter(KeyframeAnimation.class, (Object)animationJson);
        GSON = builder.create();
    }
}

