/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EnchantmentUtil {
    private static final Map<ResourceKey<Enchantment>, Holder<Enchantment>> enchantmentCache = new HashMap<ResourceKey<Enchantment>, Holder<Enchantment>>();

    public static Holder<Enchantment> getEnchantmentHolder(RegistryAccess registryAccess, ResourceKey<Enchantment> resourceKey) {
        Optional enchantment;
        if (enchantmentCache.containsKey(resourceKey)) {
            return enchantmentCache.get(resourceKey);
        }
        Optional enchantmentRegistry = registryAccess.registry(Registries.ENCHANTMENT);
        if (enchantmentRegistry.isPresent() && (enchantment = ((Registry)enchantmentRegistry.get()).getHolder(resourceKey)).isPresent()) {
            enchantmentCache.put(resourceKey, (Holder<Enchantment>)((Holder)enchantment.get()));
            return (Holder)enchantment.get();
        }
        return null;
    }

    public static Holder<Enchantment> getEnchantmentHolder(Entity entity, ResourceKey<Enchantment> resourceKey) {
        return EnchantmentUtil.getEnchantmentHolder(entity.registryAccess(), resourceKey);
    }

    public static Holder<Enchantment> getEnchantmentHolder(Level level, ResourceKey<Enchantment> resourceKey) {
        return EnchantmentUtil.getEnchantmentHolder(level.registryAccess(), resourceKey);
    }

    public static Holder<Enchantment> getEnchantmentHolder(BlockEntity blockEntity, ResourceKey<Enchantment> resourceKey) {
        return EnchantmentUtil.getEnchantmentHolder(blockEntity.getLevel().registryAccess(), resourceKey);
    }

    public static void clearCache() {
        enchantmentCache.clear();
    }
}

