/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.block.blockentity;

import com.mrbysco.enchantableblocks.block.blockentity.AbstractEnchantedBlockEntity;
import com.mrbysco.enchantableblocks.block.blockentity.IEnchantable;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import com.mrbysco.enchantableblocks.registry.ModRegistry;
import com.mrbysco.enchantableblocks.registry.ModTags;
import com.mrbysco.enchantableblocks.util.EnchantmentUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantedChestBlockEntity
extends AbstractEnchantedBlockEntity
implements LidBlockEntity,
Container,
MenuProvider,
Nameable,
IEnchantable {
    @Nullable
    private Component name;
    public final ItemStackHandler handler = new ItemStackHandler(54){

        protected void onContentsChanged(int slot) {
            EnchantedChestBlockEntity.this.setChanged();
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (!EnchantedChestBlockEntity.this.isWithinRange(slot)) {
                return;
            }
            super.setStackInSlot(slot, stack);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!EnchantedChestBlockEntity.this.isWithinRange(slot)) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            if (!EnchantedChestBlockEntity.this.isWithinRange(slot)) {
                return ItemStack.EMPTY;
            }
            return super.getStackInSlot(slot);
        }

        public int getSlots() {
            int storingLevel = EnchantedChestBlockEntity.this.getEnchantmentLevel(ModTags.General.STORAGE_UPGRADE);
            if (storingLevel < 1) {
                return 27;
            }
            if (storingLevel == 1) {
                return 36;
            }
            if (storingLevel == 2) {
                return 45;
            }
            return super.getSlots();
        }
    };
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            EnchantedChestBlockEntity.playSound(level, pos, state, SoundEvents.CHEST_OPEN);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            EnchantedChestBlockEntity.playSound(level, pos, state, SoundEvents.CHEST_CLOSE);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int eventID, int eventParam) {
            EnchantedChestBlockEntity.this.signalOpenCount(level, pos, state, eventID, eventParam);
        }

        protected boolean isOwnContainer(Player player) {
            if (!(player.containerMenu instanceof ChestMenu)) {
                return false;
            }
            Container container = ((ChestMenu)player.containerMenu).getContainer();
            return container == EnchantedChestBlockEntity.this || container instanceof CompoundContainer && ((CompoundContainer)container).contains((Container)EnchantedChestBlockEntity.this);
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();

    public EnchantedChestBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public EnchantedChestBlockEntity(BlockPos pos, BlockState state) {
        super(ModRegistry.ENCHANTED_CHEST_BLOCK_ENTITY.get(), pos, state);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState state, EnchantedChestBlockEntity blockEntity) {
        blockEntity.chestLidController.tickLid();
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("CustomName", 8)) {
            this.name = EnchantedChestBlockEntity.parseCustomNameSafe((String)tag.getString("CustomName"), (HolderLookup.Provider)registries);
        }
        this.handler.deserializeNBT(registries, tag.getCompound("Items"));
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.name != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)registries));
        }
        tag.put("Items", (Tag)this.handler.serializeNBT(registries));
    }

    public void setCustomName(Component pName) {
        this.name = pName;
    }

    public Component getName() {
        return this.name != null ? this.name : Component.translatable((String)"container.chest");
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerID, Inventory playerInventory, Player player) {
        return null;
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.getOpenness(partialTicks);
    }

    public static int getOpenCount(BlockGetter pLevel, BlockPos pPos) {
        BlockEntity blockentity;
        BlockState blockstate = pLevel.getBlockState(pPos);
        if (blockstate.hasBlockEntity() && (blockentity = pLevel.getBlockEntity(pPos)) instanceof EnchantedChestBlockEntity) {
            return ((EnchantedChestBlockEntity)blockentity).openersCounter.getOpenerCount();
        }
        return 0;
    }

    private static void playSound(Level level, BlockPos pos, BlockState state, SoundEvent soundEvent) {
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + 0.5;
        double d2 = (double)pos.getZ() + 0.5;
        level.playSound((Player)null, d0, d1, d2, soundEvent, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int eventID, int eventParam) {
        Block block = state.getBlock();
        level.blockEvent(pos, block, 1, eventParam);
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.chestLidController.shouldBeOpen(type > 0);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public int getContainerSize() {
        return this.handler.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        if (!this.isWithinRange(slot)) {
            return ItemStack.EMPTY;
        }
        return this.handler.getStackInSlot(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = this.handler.extractItem(slot, amount, false);
        if (!this.isWithinRange(slot)) {
            return ItemStack.EMPTY;
        }
        if (!stack.isEmpty()) {
            this.setChanged();
        }
        return stack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        if (!this.isWithinRange(slot)) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = this.getItem(slot);
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.handler.setStackInSlot(slot, stack);
        return stack;
    }

    public void setItem(int slot, ItemStack stack) {
        if (!this.isWithinRange(slot)) {
            return;
        }
        this.handler.setStackInSlot(slot, stack);
    }

    private boolean isWithinRange(int slot) {
        int storingLevel = this.getEnchantmentLevel(EnchantmentUtil.getEnchantmentHolder(this, ModEnchantments.STORING));
        if (storingLevel < 1) {
            return slot < 27;
        }
        if (storingLevel == 1) {
            return slot < 36;
        }
        if (storingLevel == 2) {
            return slot < 45;
        }
        return slot < 54;
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i).isEmpty()) continue;
            this.handler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public ItemStackHandler getHandler(@Nullable Direction direction) {
        return this.handler;
    }
}

