/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.table;

import com.almostreliable.lootjs.core.entry.ItemLootEntry;
import com.almostreliable.lootjs.core.entry.SimpleLootEntry;
import com.almostreliable.lootjs.core.entry.TableReferenceLootEntry;
import com.almostreliable.lootjs.core.entry.TagLootEntry;
import com.almostreliable.lootjs.core.filters.IdFilter;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.world.item.Item;

public interface LootEntriesTransformer {
    public LootEntriesTransformer modifyEntry(UnaryOperator<SimpleLootEntry> var1, boolean var2);

    default public LootEntriesTransformer modifyEntry(UnaryOperator<SimpleLootEntry> onTransform) {
        this.modifyEntry(onTransform, true);
        return this;
    }

    default public LootEntriesTransformer modifyItemEntry(UnaryOperator<ItemLootEntry> onTransform) {
        this.modifyEntry(le -> {
            if (le instanceof ItemLootEntry) {
                ItemLootEntry ile = (ItemLootEntry)le;
                return (SimpleLootEntry)onTransform.apply(ile);
            }
            return le;
        });
        return this;
    }

    public LootEntriesTransformer removeEntry(Predicate<SimpleLootEntry> var1, boolean var2);

    default public LootEntriesTransformer removeEntry(Predicate<SimpleLootEntry> onRemove) {
        this.removeEntry(onRemove, true);
        return this;
    }

    default public LootEntriesTransformer removeItem(ItemFilter filter) {
        this.removeItem(filter, true);
        return this;
    }

    default public LootEntriesTransformer removeItem(ItemFilter filter, boolean deepRemove) {
        this.removeEntry(entry -> {
            ItemLootEntry ile;
            return entry instanceof ItemLootEntry && (ile = (ItemLootEntry)entry).test(filter);
        }, deepRemove);
        return this;
    }

    default public LootEntriesTransformer removeTag(String tag) {
        this.removeTag(tag, true);
        return this;
    }

    default public LootEntriesTransformer removeTag(String tag, boolean deepRemove) {
        this.removeEntry(entry -> {
            TagLootEntry tle;
            return entry instanceof TagLootEntry && (tle = (TagLootEntry)entry).isTag(tag);
        }, deepRemove);
        return this;
    }

    default public LootEntriesTransformer removeReference(IdFilter filter) {
        this.removeReference(filter, true);
        return this;
    }

    default public LootEntriesTransformer removeReference(IdFilter filter, boolean deepRemove) {
        this.removeEntry(entry -> {
            TableReferenceLootEntry d;
            return entry instanceof TableReferenceLootEntry && filter.test((d = (TableReferenceLootEntry)entry).getLocation());
        }, deepRemove);
        return this;
    }

    default public LootEntriesTransformer replaceItem(ItemFilter filter, Item item) {
        this.replaceItem(filter, item, true);
        return this;
    }

    default public LootEntriesTransformer replaceItem(ItemFilter filter, Item item, boolean deepReplace) {
        this.modifyEntry(entry -> {
            ItemLootEntry ile;
            if (entry instanceof ItemLootEntry && (ile = (ItemLootEntry)entry).test(filter)) {
                ile.setItem(item);
            }
            return entry;
        }, deepReplace);
        return this;
    }
}

