/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.LootJS;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.loot.condition.CustomParamPredicate;
import com.almostreliable.lootjs.loot.condition.IsLightLevel;
import com.almostreliable.lootjs.loot.condition.MatchAnyInventorySlot;
import com.almostreliable.lootjs.loot.condition.MatchBiome;
import com.almostreliable.lootjs.loot.condition.MatchDimension;
import com.almostreliable.lootjs.loot.condition.MatchEquipmentSlot;
import com.almostreliable.lootjs.loot.condition.MatchKillerDistance;
import com.almostreliable.lootjs.loot.condition.MatchPlayer;
import com.almostreliable.lootjs.loot.condition.MatchStructure;
import com.almostreliable.lootjs.loot.condition.PlayerParamPredicate;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.predicates.TimeCheck;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public interface LootConditionsContainer<C> {
    default public C matchTool(ItemPredicate predicate) {
        return this.addCondition((LootItemCondition)new MatchTool(Optional.of(predicate)));
    }

    default public C matchMainHand(ItemFilter filter) {
        return this.addCondition(new MatchEquipmentSlot(EquipmentSlot.MAINHAND, filter));
    }

    default public C matchOffHand(ItemFilter filter) {
        return this.addCondition(new MatchEquipmentSlot(EquipmentSlot.OFFHAND, filter));
    }

    default public C matchHead(ItemFilter filter) {
        return this.addCondition(new MatchEquipmentSlot(EquipmentSlot.HEAD, filter));
    }

    default public C matchChest(ItemFilter filter) {
        return this.addCondition(new MatchEquipmentSlot(EquipmentSlot.CHEST, filter));
    }

    default public C matchLegs(ItemFilter filter) {
        return this.addCondition(new MatchEquipmentSlot(EquipmentSlot.LEGS, filter));
    }

    default public C matchFeet(ItemFilter filter) {
        return this.addCondition(new MatchEquipmentSlot(EquipmentSlot.FEET, filter));
    }

    default public C matchEquip(EquipmentSlot slot, ItemFilter filter) {
        return this.addCondition(new MatchEquipmentSlot(slot, filter));
    }

    default public C matchAnyInventorySlot(ItemFilter filter) {
        return this.addCondition(new MatchAnyInventorySlot(filter, false));
    }

    default public C matchAnyHotbarSlot(ItemFilter filter) {
        return this.addCondition(new MatchAnyInventorySlot(filter, true));
    }

    default public C survivesExplosion() {
        return this.addCondition(ExplosionCondition.survivesExplosion().build());
    }

    default public C matchTime(long period, int min, int max) {
        return this.addCondition((LootItemCondition)new TimeCheck.Builder(IntRange.range((int)min, (int)max)).setPeriod(period).build());
    }

    default public C matchTime(int min, int max) {
        return this.matchTime(24000L, min, max);
    }

    default public C matchWeather(@Nullable Boolean raining, @Nullable Boolean thundering) {
        WeatherCheck.Builder builder = new WeatherCheck.Builder();
        if (raining != null) {
            builder.setRaining(raining.booleanValue());
        }
        if (thundering != null) {
            builder.setThundering(thundering.booleanValue());
        }
        return this.addCondition((LootItemCondition)builder.build());
    }

    default public C randomChance(NumberProvider value) {
        return this.addCondition(LootItemRandomChanceCondition.randomChance((NumberProvider)value).build());
    }

    default public C randomChanceWithEnchantment(Holder<Enchantment> enchantment, float[] chances) {
        Preconditions.checkArgument((chances.length > 0 ? 1 : 0) != 0, (Object)"There must be at least one chance");
        float first = chances[0];
        ArrayList<Float> enchantmentChances = new ArrayList<Float>();
        for (int i = 1; i < chances.length; ++i) {
            enchantmentChances.add(Float.valueOf(chances[i]));
        }
        LevelBasedValue.Lookup lookup = new LevelBasedValue.Lookup(enchantmentChances, (LevelBasedValue)new LevelBasedValue.Constant(0.0f));
        return this.addCondition((LootItemCondition)new LootItemRandomChanceWithEnchantedBonusCondition(first, (LevelBasedValue)lookup, enchantment));
    }

    default public C randomTableBonus(Holder<Enchantment> enchantment, float[] chances) {
        return this.addCondition(BonusLevelTableCondition.bonusLevelFlatChance(enchantment, (float[])chances).build());
    }

    default public C matchLocation(LocationPredicate predicate) {
        return this.matchLocation(BlockPos.ZERO, predicate);
    }

    default public C matchLocation(BlockPos offset, LocationPredicate predicate) {
        return this.addCondition((LootItemCondition)new LocationCheck(Optional.of(predicate), offset));
    }

    default public C matchBiome(HolderSet<Biome> biomes) {
        return this.addCondition(new MatchBiome(biomes));
    }

    default public C matchDimension(ResourceLocation ... dimensions) {
        return this.addCondition(new MatchDimension(dimensions));
    }

    default public C matchStructure(HolderSet<Structure> structures) {
        return this.addCondition(new MatchStructure(structures, true));
    }

    default public C matchStructure(HolderSet<Structure> structures, boolean exact) {
        return this.addCondition(new MatchStructure(structures, exact));
    }

    default public C isLightLevel(int min, int max) {
        return this.addCondition(new IsLightLevel(min, max));
    }

    default public C luck(MinMaxBounds.Doubles bounds) {
        return this.matchPlayerCustom(serverPlayer -> bounds.matches((double)serverPlayer.getLuck()));
    }

    default public C killedByPlayer() {
        return this.addCondition(LootItemKilledByPlayerCondition.killedByPlayer().build());
    }

    default public C matchBlock(Block block) {
        return this.addCondition((LootItemCondition)new LootItemBlockStatePropertyCondition((Holder)block.builtInRegistryHolder(), Optional.empty()));
    }

    default public C matchBlock(Block block, StatePropertiesPredicate properties) {
        return this.addCondition((LootItemCondition)new LootItemBlockStatePropertyCondition((Holder)block.builtInRegistryHolder(), Optional.of(properties)));
    }

    default public C matchEntity(EntityPredicate entityPredicate) {
        return this.addCondition(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate)entityPredicate).build());
    }

    default public C matchAttacker(EntityPredicate entityPredicate) {
        return this.addCondition(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.ATTACKER, (EntityPredicate)entityPredicate).build());
    }

    default public C matchDirectAttacker(EntityPredicate entityPredicate) {
        return this.addCondition(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.DIRECT_ATTACKER, (EntityPredicate)entityPredicate).build());
    }

    default public C matchPlayer(EntityPredicate entityPredicate) {
        return this.addCondition(new MatchPlayer(entityPredicate));
    }

    default public C matchDamageSource(DamageSourcePredicate predicate) {
        return this.addCondition((LootItemCondition)new DamageSourceCondition(Optional.of(predicate)));
    }

    default public C matchDistance(DistancePredicate distancePredicate) {
        return this.addCondition(new MatchKillerDistance(distancePredicate));
    }

    default public C matchPlayerCustom(Predicate<ServerPlayer> predicate) {
        return this.addCondition(new PlayerParamPredicate(predicate));
    }

    default public C matchEntityCustom(Predicate<Entity> predicate) {
        return this.addCondition(new CustomParamPredicate<Entity>(LootContextParams.THIS_ENTITY, predicate));
    }

    default public C matchAttackerCustom(Predicate<Entity> predicate) {
        return this.addCondition(new CustomParamPredicate<Entity>(LootContextParams.ATTACKING_ENTITY, predicate));
    }

    default public C matchDirectAttackerCustom(Predicate<Entity> predicate) {
        return this.addCondition(new CustomParamPredicate<Entity>(LootContextParams.DIRECT_ATTACKING_ENTITY, predicate));
    }

    default public C blockEntity(Predicate<BlockEntity> predicate) {
        return this.addCondition(new CustomParamPredicate<BlockEntity>(LootContextParams.BLOCK_ENTITY, predicate));
    }

    default public C hasAnyStage(String ... stages) {
        if (stages.length == 1) {
            String stage = stages[0];
            PlayerParamPredicate condition = new PlayerParamPredicate(player -> player.getTags().contains(stage));
            return this.addCondition(condition);
        }
        PlayerParamPredicate condition = new PlayerParamPredicate(player -> {
            for (String stage : stages) {
                if (!player.getTags().contains(stage)) continue;
                return true;
            }
            return false;
        });
        return this.addCondition(condition);
    }

    default public C matchAnyOf(LootItemCondition ... conditions) {
        return this.addCondition((LootItemCondition)new AnyOfCondition(Arrays.asList(conditions)));
    }

    default public C matchAllOf(LootItemCondition ... conditions) {
        return this.addCondition((LootItemCondition)new AllOfCondition(Arrays.asList(conditions)));
    }

    default public C matchCustomCondition(JsonObject json) {
        RegistryOps regOps = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)LootJS.lookup());
        LootItemCondition condition = (LootItemCondition)LootItemCondition.DIRECT_CODEC.parse((DynamicOps)regOps, (Object)json).getOrThrow();
        return this.addCondition(condition);
    }

    @HideFromJS
    public C addCondition(LootItemCondition var1);
}

