/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.data;

import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import io.github.projectet.ae2things.AE2Things;
import io.github.projectet.ae2things.item.AETItems;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredItem;

public class CraftingRecipeProvider
extends RecipeProvider {
    public CraftingRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        CraftingRecipeProvider.driveRecipes(output);
        this.housingRecipe(output);
    }

    private void housingRecipe(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, AETItems.DISK_HOUSING).pattern("aba").pattern("b b").pattern("ded").define(Character.valueOf('a'), (ItemLike)AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('d'), Tags.Items.INGOTS_NETHERITE).define(Character.valueOf('e'), Tags.Items.GEMS_AMETHYST).unlockedBy("has_netherite", CraftingRecipeProvider.has((TagKey)Tags.Items.INGOTS_NETHERITE)).save(output, AE2Things.id("disk_housing"));
    }

    private static void driveRecipes(RecipeOutput output) {
        Map<ItemDefinition, DeferredItem<Item>> componentsToDrive = Map.of(AEItems.CELL_COMPONENT_1K, AETItems.DISK_DRIVE_1K, AEItems.CELL_COMPONENT_4K, AETItems.DISK_DRIVE_4K, AEItems.CELL_COMPONENT_16K, AETItems.DISK_DRIVE_16K, AEItems.CELL_COMPONENT_64K, AETItems.DISK_DRIVE_64K, AEItems.CELL_COMPONENT_256K, AETItems.DISK_DRIVE_256K);
        for (Map.Entry<ItemDefinition, DeferredItem<Item>> entry : componentsToDrive.entrySet()) {
            ItemDefinition component = entry.getKey();
            DeferredItem<Item> drive = entry.getValue();
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)drive.get())).pattern("aba").pattern("bcb").pattern("ded").define(Character.valueOf('a'), (ItemLike)AEBlocks.QUARTZ_GLASS).define(Character.valueOf('b'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('c'), (ItemLike)component).define(Character.valueOf('d'), Tags.Items.INGOTS_NETHERITE).define(Character.valueOf('e'), Tags.Items.GEMS_AMETHYST).unlockedBy("has_netherite", CraftingRecipeProvider.has((TagKey)Tags.Items.INGOTS_NETHERITE)).save(output, drive.getId());
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)drive.get())).requires(AETItems.DISK_HOUSING).requires((ItemLike)component).unlockedBy("has_housing", CraftingRecipeProvider.has(AETItems.DISK_HOUSING)).unlockedBy("has_component", CraftingRecipeProvider.has((ItemLike)component)).save(output, drive.getId().withSuffix("_with_housing"));
        }
    }
}

