/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.horsingaround.handler;

import com.mrbysco.horsingaround.data.CallData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class SyncHandler {
    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide) {
            CallData callData = CallData.get(player.level());
            callData.syncData(player.getUUID());
        }
    }

    @SubscribeEvent
    public void onEntityTick(EntityTickEvent.Post event) {
        CallData callData;
        OwnableEntity ownableEntity;
        Entity entity = event.getEntity();
        if (!entity.level().isClientSide && entity.tickCount % 80 == 0 && entity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)entity).getOwnerUUID() != null && (callData = CallData.get(entity.level())).isKnown(entity.getUUID())) {
            callData.updateData(entity.getUUID(), entity);
        }
    }
}

