/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.mekanismcovers.mixin;

import dev.lucaargolo.mekanismcovers.mixed.TileEntityTransmitterMixed;
import dev.lucaargolo.mekanismcovers.mixin.EntityCollisionContextAccessor;
import mekanism.common.block.BlockMekanism;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.block.transmitter.BlockTransmitter;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockTransmitter.class})
public abstract class BlockTransmitterMixin
extends BlockMekanism
implements IStateFluidLoggable {
    @Shadow(remap=false)
    protected abstract VoxelShape getRealShape(BlockGetter var1, BlockPos var2);

    protected BlockTransmitterMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(at={@At(value="HEAD")}, method={"getShape"}, cancellable=true)
    public void getCorrectShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        EntityCollisionContextAccessor accessor;
        if (context instanceof EntityCollisionContextAccessor && (accessor = (EntityCollisionContextAccessor)context).getHeldItem() != null && accessor.getHeldItem().is((Item)MekanismItems.CONFIGURATOR.get()) && ((ItemConfigurator)MekanismItems.CONFIGURATOR.get()).getMode(accessor.getHeldItem()) == ItemConfigurator.ConfiguratorMode.WRENCH) {
            cir.setReturnValue((Object)this.getRealShape(world, pos));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getRealShape"}, cancellable=true, remap=false)
    public void getCoverShape(BlockGetter world, BlockPos pos, CallbackInfoReturnable<VoxelShape> cir) {
        TileEntityTransmitterMixed transmitter;
        TileEntityTransmitter tile = (TileEntityTransmitter)WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)world, (BlockPos)pos);
        if (tile instanceof TileEntityTransmitterMixed && (transmitter = (TileEntityTransmitterMixed)tile).mekanism_covers$getCoverState() != null) {
            cir.setReturnValue((Object)Shapes.block());
        }
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        TileEntityTransmitterMixed transmitter;
        BlockState coverState;
        TileEntityTransmitter tile;
        int ambientLight = super.getLightEmission(state, world, pos);
        if (ambientLight != 15 && (tile = (TileEntityTransmitter)WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)world, (BlockPos)pos)) instanceof TileEntityTransmitterMixed && (coverState = (transmitter = (TileEntityTransmitterMixed)tile).mekanism_covers$getCoverState()) != null) {
            ambientLight = Math.max(ambientLight, coverState.getLightEmission(world, pos));
        }
        return ambientLight;
    }

    public boolean hasDynamicShape() {
        return true;
    }
}

