/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.mekanismcovers;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import net.neoforged.fml.loading.FMLPaths;

public class ModConfig {
    private static final String CONFIG_PATH = FMLPaths.CONFIGDIR.get().toString() + "/mekanismcovers.json";
    private static ModConfig instance;
    private static final Gson GSON;
    private boolean disableAdvancedCoverRendering = false;

    public static ModConfig getInstance() {
        return instance;
    }

    public boolean isDisableAdvancedCoverRendering() {
        return this.disableAdvancedCoverRendering;
    }

    public void setDisableAdvancedCoverRendering(boolean disableAdvancedLayer) {
        this.disableAdvancedCoverRendering = disableAdvancedLayer;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(CONFIG_PATH);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void load() {
        try (FileReader reader = new FileReader(CONFIG_PATH);){
            Type mapType = new TypeToken<ModConfig>(){}.getType();
            instance = (ModConfig)GSON.fromJson((Reader)reader, mapType);
        }
        catch (FileNotFoundException e) {
            if (ModConfig.tryCreateFile(CONFIG_PATH)) {
                instance = new ModConfig();
                instance.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean tryCreateFile(String p) {
        Path filePath = Path.of(p, new String[0]);
        String[] ps = p.split("/");
        StringBuilder fs = new StringBuilder();
        for (int i = 0; i < ps.length - 1; ++i) {
            fs.append(ps[i]).append("/");
        }
        Path folderPath = Path.of(fs.toString(), new String[0]);
        try {
            folderPath.toFile().mkdirs();
            filePath.toFile().createNewFile();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    static {
        GSON = new Gson().newBuilder().setPrettyPrinting().create();
    }
}

