/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.mekanismcovers;

import dev.lucaargolo.mekanismcovers.CoverItem;
import dev.lucaargolo.mekanismcovers.MekanismCovers;
import dev.lucaargolo.mekanismcovers.ModConfig;
import dev.lucaargolo.mekanismcovers.mixed.TileEntityTransmitterMixed;
import mekanism.common.block.transmitter.BlockTransmitter;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@EventBusSubscriber(modid="mekanismcovers", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class MekanismCoversClient {
    public static final boolean ADVANCED_COVER_RENDERING = !ModConfig.getInstance().isDisableAdvancedCoverRendering();
    public static Short COVER_ENTITY_ID = null;
    private static boolean lastTransparency = false;
    public static final ModelResourceLocation COVER_MODEL = ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanismcovers", (String)"block/cover"));

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)new CoverItem.CoverItemExtensions(), new Item[]{(Item)MekanismCovers.COVER.get()});
    }

    @SubscribeEvent
    public static void registerCoverModel(ModelEvent.RegisterAdditional event) {
        event.register(COVER_MODEL);
    }

    @SubscribeEvent
    public static void blockColorsRegister(RegisterColorHandlersEvent.Block event) {
        Block[] transmitters = BuiltInRegistries.BLOCK.stream().filter(block -> block instanceof BlockTransmitter).toList().toArray(new Block[0]);
        event.register((pState, pLevel, pPos, pTintIndex) -> {
            TileEntityTransmitterMixed transmitter;
            BlockState coverState;
            TileEntityTransmitter tile;
            if (pTintIndex == 1337 && pPos != null && (tile = (TileEntityTransmitter)WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)pLevel, (BlockPos)pPos)) instanceof TileEntityTransmitterMixed && (coverState = (transmitter = (TileEntityTransmitterMixed)tile).mekanism_covers$getCoverState()) != null) {
                return event.getBlockColors().getColor(coverState, pLevel, pPos, pTintIndex);
            }
            return 0xFFFFFF;
        }, transmitters);
    }

    public static void updateCoverTransparency() {
        boolean transparency = MekanismCoversClient.isCoverTransparent();
        if (transparency != lastTransparency) {
            Minecraft client = Minecraft.getInstance();
            if (client.player == null || client.level == null) {
                return;
            }
            int viewDistance = (int)Math.ceil(client.levelRenderer.getLastViewDistance());
            ChunkPos.rangeClosed((ChunkPos)client.player.chunkPosition(), (int)viewDistance).forEach(chunkPos -> {
                LevelChunk chunk = client.level.getChunkSource().getChunkNow(chunkPos.x, chunkPos.z);
                if (chunk != null) {
                    for (int i = 0; i < chunk.getSectionsCount(); ++i) {
                        LevelChunkSection section = chunk.getSection(i);
                        if (!section.maybeHas(state -> state.getBlock() instanceof BlockTransmitter)) continue;
                        client.levelRenderer.setSectionDirty(chunkPos.x, chunk.getSectionYFromSectionIndex(i), chunkPos.z);
                    }
                }
            });
        }
        lastTransparency = transparency;
    }

    public static boolean isCoverTransparentFast() {
        return lastTransparency;
    }

    private static boolean isCoverTransparent() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            ItemStack mainStack = player.getMainHandItem();
            ItemStack offStack = player.getOffhandItem();
            ItemStack[] stacks = new ItemStack[]{mainStack, offStack};
            boolean transparent = false;
            for (ItemStack stack : stacks) {
                BlockItem blockItem;
                Block block;
                if (stack.is((Item)MekanismItems.CONFIGURATOR.get())) {
                    ItemConfigurator.ConfiguratorMode mode = (ItemConfigurator.ConfiguratorMode)((ItemConfigurator)MekanismItems.CONFIGURATOR.get()).getMode(mainStack);
                    if (mode == ItemConfigurator.ConfiguratorMode.WRENCH) continue;
                    transparent = true;
                    break;
                }
                Item item = stack.getItem();
                if (!(item instanceof BlockItem) || !((block = (blockItem = (BlockItem)item).getBlock()) instanceof BlockTransmitter)) continue;
                transparent = true;
                break;
            }
            return transparent;
        }
        return false;
    }

    public static String modifyIrisVertex(String source) {
        if (COVER_ENTITY_ID != null) {
            String[] lines = source.split("\n");
            StringBuilder modifiedSource = new StringBuilder();
            modifiedSource.append(lines[0]).append("\n");
            if (!source.contains("mc_Entity")) {
                modifiedSource.append("in uint mc_Entity;\n");
            }
            if (!source.contains("iris_Entity")) {
                modifiedSource.append("vec4 iris_Entity = vec4(int(mc_Entity >> 1u) - 1, mc_Entity & 1u, 0.0f, 1.0f);");
            }
            modifiedSource.append("flat out int mekanismCoverInjectMat;\n");
            for (int i = 1; i < lines.length - 1; ++i) {
                modifiedSource.append(lines[i]).append("\n");
            }
            modifiedSource.append("mekanismCoverInjectMat = int(iris_Entity.x + 0.5);\n");
            modifiedSource.append(lines[lines.length - 1]);
            return modifiedSource.toString();
        }
        return source;
    }

    public static String modifyIrisFragment(String source) {
        if (COVER_ENTITY_ID != null) {
            String[] lines = source.split("\n");
            StringBuilder modifiedSource = new StringBuilder();
            modifiedSource.append(lines[0]).append("\n");
            modifiedSource.append("flat in int mekanismCoverInjectMat;\n");
            modifiedSource.append("uniform float mkcv_CoverTransparency;\n");
            for (int i = 1; i < lines.length - 1; ++i) {
                modifiedSource.append(lines[i]).append("\n");
            }
            modifiedSource.append("if(mekanismCoverInjectMat == ").append(COVER_ENTITY_ID).append(") {\n");
            modifiedSource.append("    iris_FragData0.a *= mkcv_CoverTransparency;\n");
            modifiedSource.append("}\n");
            modifiedSource.append(lines[lines.length - 1]);
            return modifiedSource.toString();
        }
        return source;
    }
}

