/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.mekanismcovers;

import dev.lucaargolo.mekanismcovers.MekanismCovers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CoverRecipe
extends CustomRecipe {
    private static final Ingredient COVER_INGREDIENT = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MekanismCovers.COVER.get(), (ItemLike)MekanismCovers.EMPTY_COVER.get()});

    public CoverRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        int coverQnt = 0;
        boolean coverFull = false;
        int blockQnt = 0;
        for (int slot = 0; slot < input.size(); ++slot) {
            BlockItem blockItem;
            ItemStack stack = input.getItem(slot);
            if (stack.isEmpty()) continue;
            if (COVER_INGREDIENT.test(stack)) {
                ++coverQnt;
                coverFull = coverFull || stack.has(MekanismCovers.COVER_BLOCK);
                continue;
            }
            Item item = stack.getItem();
            if (item instanceof BlockItem && !((blockItem = (BlockItem)item).getBlock() instanceof EntityBlock)) {
                Block block = blockItem.getBlock();
                BlockState state = block.defaultBlockState();
                if (state.isCollisionShapeFullBlock((BlockGetter)level, BlockPos.ZERO)) {
                    ++blockQnt;
                    continue;
                }
                return false;
            }
            return false;
        }
        return coverQnt == 1 && (!coverFull && blockQnt == 1 || coverFull && blockQnt == 0);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        Block block = Blocks.AIR;
        boolean isCleanOperation = false;
        for (int slot = 0; slot < input.size(); ++slot) {
            BlockItem blockItem;
            ItemStack stack = input.getItem(slot);
            if (stack.isEmpty()) continue;
            if (COVER_INGREDIENT.test(stack)) {
                isCleanOperation = isCleanOperation || stack.has(MekanismCovers.COVER_BLOCK);
                continue;
            }
            Item item = stack.getItem();
            if (!(item instanceof BlockItem) || (blockItem = (BlockItem)item).getBlock() instanceof EntityBlock) continue;
            block = blockItem.getBlock();
        }
        if (isCleanOperation) {
            return new ItemStack((ItemLike)MekanismCovers.EMPTY_COVER.get());
        }
        if (block != Blocks.AIR) {
            ItemStack result = new ItemStack((ItemLike)MekanismCovers.COVER.get());
            result.set(MekanismCovers.COVER_BLOCK, (Object)MekanismCovers.getKey(block));
            return result;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingInput input) {
        NonNullList list = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = input.getItem(i);
            Block coverBlock = MekanismCovers.getBlock((ResourceLocation)stack.get(MekanismCovers.COVER_BLOCK));
            if (coverBlock == null) continue;
            list.set(i, (Object)coverBlock.asItem().getDefaultInstance());
        }
        return list;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return new ItemStack(MekanismCovers.COVER);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MekanismCovers.COVER_SERIALIZER.get();
    }
}

