/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.api.client.utils;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class AthenaUtils {
    public static final Logger LOGGER = LogUtils.getLogger();

    @Nullable
    public static RenderType renderTypeFromJson(JsonObject object) {
        return switch (GsonHelper.getAsString((JsonObject)object, (String)"render_type", (String)"")) {
            case "solid" -> RenderType.solid();
            case "cutout" -> RenderType.cutout();
            case "cutout_mipped" -> RenderType.cutoutMipped();
            case "translucent" -> RenderType.translucent();
            default -> null;
        };
    }

    public static boolean asBool(Direction.AxisDirection axisDir) {
        return axisDir == Direction.AxisDirection.POSITIVE;
    }

    public static <T> T ternary(Direction.AxisDirection axisDir, T first, T second) {
        return axisDir == Direction.AxisDirection.POSITIVE ? first : second;
    }

    public static Pair<Direction, Direction> getMinMax(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> Pair.of((Object)Direction.WEST, (Object)Direction.EAST);
            case Direction.Axis.Y -> Pair.of((Object)Direction.UP, (Object)Direction.DOWN);
            case Direction.Axis.Z -> Pair.of((Object)Direction.NORTH, (Object)Direction.SOUTH);
        };
    }

    public static BlockPos getFacingPos(BlockPos pos, Direction facing, UrMom urMom) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> {
                switch (urMom.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield pos.north();
                    }
                    case 1: {
                        yield pos.south();
                    }
                    case 2: {
                        yield pos.west();
                    }
                    case 3: 
                }
                yield pos.east();
            }
            case Direction.DOWN -> {
                switch (urMom.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield pos.south();
                    }
                    case 1: {
                        yield pos.north();
                    }
                    case 2: {
                        yield pos.west();
                    }
                    case 3: 
                }
                yield pos.east();
            }
            case Direction.NORTH -> {
                switch (urMom.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield pos.above();
                    }
                    case 1: {
                        yield pos.below();
                    }
                    case 2: {
                        yield pos.east();
                    }
                    case 3: 
                }
                yield pos.west();
            }
            case Direction.SOUTH -> {
                switch (urMom.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield pos.above();
                    }
                    case 1: {
                        yield pos.below();
                    }
                    case 2: {
                        yield pos.west();
                    }
                    case 3: 
                }
                yield pos.east();
            }
            case Direction.WEST -> {
                switch (urMom.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield pos.above();
                    }
                    case 1: {
                        yield pos.below();
                    }
                    case 2: {
                        yield pos.north();
                    }
                    case 3: 
                }
                yield pos.south();
            }
            case Direction.EAST -> {
                switch (urMom.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield pos.above();
                    }
                    case 1: {
                        yield pos.below();
                    }
                    case 2: {
                        yield pos.south();
                    }
                    case 3: 
                }
                yield pos.north();
            }
        };
    }

    public static boolean getFromDir(BlockState state, Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> (Boolean)state.getValue((Property)BlockStateProperties.UP);
            case Direction.DOWN -> (Boolean)state.getValue((Property)BlockStateProperties.DOWN);
            case Direction.NORTH -> (Boolean)state.getValue((Property)BlockStateProperties.NORTH);
            case Direction.SOUTH -> (Boolean)state.getValue((Property)BlockStateProperties.SOUTH);
            case Direction.WEST -> (Boolean)state.getValue((Property)BlockStateProperties.WEST);
            case Direction.EAST -> (Boolean)state.getValue((Property)BlockStateProperties.EAST);
        };
    }

    public static enum UrMom {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

