/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.network.packet.MultiloaderPacket;
import software.bernie.geckolib.util.GeckoLibUtil;

public record StopTriggeredSingletonAnimPacket(String syncableId, long instanceId, String controllerName, String animName) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<StopTriggeredSingletonAnimPacket> TYPE = new CustomPacketPayload.Type(GeckoLibConstants.id("stop_triggered_singleton_anim"));
    public static final StreamCodec<FriendlyByteBuf, StopTriggeredSingletonAnimPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, StopTriggeredSingletonAnimPacket::syncableId, (StreamCodec)ByteBufCodecs.VAR_LONG, StopTriggeredSingletonAnimPacket::instanceId, (StreamCodec)ByteBufCodecs.STRING_UTF8, StopTriggeredSingletonAnimPacket::controllerName, (StreamCodec)ByteBufCodecs.STRING_UTF8, StopTriggeredSingletonAnimPacket::animName, StopTriggeredSingletonAnimPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(@Nullable Player sender, Consumer<Runnable> workQueue) {
        workQueue.accept(() -> {
            AnimatableManager animatableManager;
            GeoAnimatable animatable = GeckoLibUtil.getSyncedAnimatable(this.syncableId);
            if (animatable != null && (animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(this.instanceId)) != null) {
                animatableManager.tryTriggerAnimation(this.controllerName.isEmpty() ? null : this.controllerName, this.animName.isEmpty() ? null : this.animName);
            }
        });
    }
}

