/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForge;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GetTraitsEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartList;
import net.silentchaos512.gear.api.property.TraitListPropertyValue;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.api.traits.TraitFunction;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.api.util.GearComponentInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.compat.curios.CuriosCompat;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.gear.trait.Trait;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public final class TraitHelper {
    private TraitHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> T activateTraits(ItemStack gear, T inputValue, TraitFunction<T> action) {
        if (!GearHelper.isGear(gear)) {
            SilentGear.LOGGER.error("Called activateTraits on non-gear item, {}", (Object)gear);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return inputValue;
        }
        TraitListPropertyValue traitListProperty = (TraitListPropertyValue)GearData.getProperties(gear).get(GearProperties.TRAITS.get());
        if (traitListProperty == null) {
            return inputValue;
        }
        List traits = (List)traitListProperty.value();
        T value = inputValue;
        for (TraitInstance trait : traits) {
            value = action.apply(trait, value);
        }
        return value;
    }

    public static int getTraitLevel(ItemStack gear, DataResource<Trait> trait) {
        if (GearHelper.isGear(gear)) {
            TraitListPropertyValue list = GearData.getProperties(gear).getOrDefault(GearProperties.TRAITS, TraitListPropertyValue.empty());
            for (TraitInstance traitInstance : (List)list.value()) {
                if (traitInstance.getTrait() != trait.get()) continue;
                return traitInstance.getLevel();
            }
        }
        return 0;
    }

    public static boolean hasTrait(ItemStack gear, DataResource<Trait> trait) {
        if (GearHelper.isGear(gear)) {
            TraitListPropertyValue list = GearData.getProperties(gear).getOrDefault(GearProperties.TRAITS, TraitListPropertyValue.empty());
            for (TraitInstance traitInstance : (List)list.value()) {
                if (traitInstance.getTrait() != trait.get()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasTrait(ItemStack gear, Trait trait) {
        if (GearHelper.isGear(gear)) {
            TraitListPropertyValue list = GearData.getProperties(gear).getOrDefault(GearProperties.TRAITS, TraitListPropertyValue.empty());
            for (TraitInstance traitInstance : (List)list.value()) {
                if (traitInstance.getTrait() != trait) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasTraitEffect(ItemStack gear, TraitEffectType<?> traitEffectType) {
        if (!GearHelper.isGear(gear)) {
            return false;
        }
        List traitList = (List)GearData.getProperties(gear).getOrDefault(GearProperties.TRAITS, TraitListPropertyValue.empty()).value();
        for (TraitInstance traitInstance : traitList) {
            for (TraitEffect effect : traitInstance.getTrait().getEffects()) {
                if (effect.type() != traitEffectType) continue;
                return true;
            }
        }
        return false;
    }

    public static int getHighestLevelEitherHand(Player player, DataResource<Trait> trait) {
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        return Math.max(TraitHelper.getTraitLevel(main, trait), TraitHelper.getTraitLevel(off, trait));
    }

    public static int getHighestLevelArmor(Player player, DataResource<Trait> trait) {
        int max = 0;
        for (ItemStack stack : player.getInventory().armor) {
            max = Math.max(max, TraitHelper.getTraitLevel(stack, trait));
        }
        return max;
    }

    public static int getHighestLevelCurio(LivingEntity entity, DataResource<Trait> trait) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.getHighestTraitLevel(entity, trait);
        }
        return 0;
    }

    public static int getHighestLevelArmorOrCurio(Player player, DataResource<Trait> trait) {
        return Math.max(TraitHelper.getHighestLevelArmor(player, trait), TraitHelper.getHighestLevelCurio((LivingEntity)player, trait));
    }

    public static boolean hasTraitEitherHand(Player player, DataResource<Trait> trait) {
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        return TraitHelper.hasTrait(main, trait) || TraitHelper.hasTrait(off, trait);
    }

    public static boolean hasTraitArmor(Player player, DataResource<Trait> trait) {
        for (ItemStack stack : player.getInventory().armor) {
            if (!TraitHelper.hasTrait(stack, trait)) continue;
            return true;
        }
        return false;
    }

    public static List<TraitInstance> getTraits(ItemStack gear) {
        if (!GearHelper.isGear(gear)) {
            return Collections.emptyList();
        }
        GearPropertiesData properties = GearData.getProperties(gear);
        TraitListPropertyValue traitList = (TraitListPropertyValue)properties.get(GearProperties.TRAITS);
        if (traitList != null) {
            return (List)traitList.value();
        }
        return Collections.emptyList();
    }

    public static Map<Trait, Integer> getTraitsFromParts(ItemStack gear, GearType gearType, PartList parts) {
        if (parts.isEmpty() || !gear.isEmpty() && GearHelper.isBroken(gear)) {
            return ImmutableMap.of();
        }
        LinkedHashMap<Trait, Integer> result = new LinkedHashMap<Trait, Integer>();
        for (PartInstance part : parts) {
            PartGearKey key = PartGearKey.of(gearType, part);
            for (TraitInstance inst : part.getTraits(key)) {
                if (!inst.conditionsMatch(key, parts)) continue;
                Trait trait = inst.getTrait();
                result.merge(trait, inst.getLevel(), Integer::max);
            }
        }
        Trait[] keys = result.keySet().toArray(new Trait[0]);
        TraitHelper.cancelTraits(result, keys);
        NeoForge.EVENT_BUS.post((Event)new GetTraitsEvent(gear, parts, result));
        return result;
    }

    @Deprecated
    public static List<TraitInstance> getTraitsFromComponents(List<? extends GearComponentInstance<?>> components, PartGearKey partKey) {
        Trait[] keys;
        if (components.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<Trait, Integer> map = new LinkedHashMap<Trait, Integer>();
        HashMap<Trait, Integer> countMatsWithTrait = new HashMap<Trait, Integer>();
        for (GearComponentInstance<?> gearComponentInstance : components) {
            for (TraitInstance inst : gearComponentInstance.getTraits(partKey)) {
                if (!inst.conditionsMatch(partKey, components)) continue;
                map.merge(inst.getTrait(), inst.getLevel(), Integer::sum);
                countMatsWithTrait.merge(inst.getTrait(), 1, Integer::sum);
            }
        }
        for (Trait trait2 : keys = map.keySet().toArray(new Trait[0])) {
            int matsWithTrait = (Integer)countMatsWithTrait.get(trait2);
            float divisor = Math.max((float)components.size() / 2.0f, (float)matsWithTrait);
            int value = Math.round((float)((Integer)map.get(trait2)).intValue() / divisor);
            map.put(trait2, Mth.clamp((int)value, (int)1, (int)trait2.getMaxLevel()));
        }
        TraitHelper.cancelTraits(map, keys);
        ArrayList<TraitInstance> arrayList = new ArrayList<TraitInstance>();
        map.forEach((trait, level) -> ret.add(TraitInstance.of(trait, (int)level, new ITraitCondition[0])));
        return arrayList;
    }

    private static void cancelTraits(Map<Trait, Integer> mapToModify, Trait[] keys) {
    }

    static void tickTraits(Level world, @Nullable Player player, ItemStack gear, boolean isEquipped) {
        TraitListPropertyValue traits = (TraitListPropertyValue)GearData.getProperties(gear, player).get(GearProperties.TRAITS);
        if (traits == null) {
            return;
        }
        for (TraitInstance trait : (List)traits.value()) {
            trait.getTrait().onUpdate(new TraitActionContext(player, trait, gear), isEquipped);
        }
    }
}

