/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import net.minecraft.client.renderer.entity.FishingHookRenderer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.client.renderer.entity.GearArrowRenderer;
import net.silentchaos512.gear.client.renderer.entity.RenderSlingshotProjectile;
import net.silentchaos512.gear.entity.GearFishingHook;
import net.silentchaos512.gear.entity.projectile.GearArrowEntity;
import net.silentchaos512.gear.entity.projectile.SlingshotProjectile;

public final class SgEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"silentgear");
    public static final DeferredHolder<EntityType<?>, EntityType<GearArrowEntity>> ARROW = SgEntities.register("arrow", GearArrowEntity::new, MobCategory.MISC);
    public static final DeferredHolder<EntityType<?>, EntityType<GearFishingHook>> FISHING_HOOK = SgEntities.register("fishing_hook", GearFishingHook::new, MobCategory.MISC);
    public static final DeferredHolder<EntityType<?>, EntityType<SlingshotProjectile>> SLINGSHOT_PROJECTILE = SgEntities.register("slingshot_projectile", SlingshotProjectile::new, MobCategory.MISC);

    private SgEntities() {
        throw new IllegalAccessError("Utility class");
    }

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String name, EntityType.EntityFactory<T> factory, MobCategory type) {
        return ENTITIES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)type).build(SilentGear.getId(name).toString()));
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="silentgear", bus=EventBusSubscriber.Bus.MOD)
    public static class Events {
        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)ARROW.get(), GearArrowRenderer::new);
            event.registerEntityRenderer((EntityType)FISHING_HOOK.get(), FishingHookRenderer::new);
            event.registerEntityRenderer((EntityType)SLINGSHOT_PROJECTILE.get(), RenderSlingshotProjectile::new);
        }
    }
}

