/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import net.silentchaos512.gear.api.item.GearTool;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import org.jetbrains.annotations.Nullable;

public class GearFishingRodItem
extends FishingRodItem
implements GearTool {
    private static final Supplier<Collection<PartType>> REQUIRED_PARTS = Suppliers.memoize(() -> ImmutableSet.of((Object)((PartType)PartTypes.MAIN.get()), (Object)((PartType)PartTypes.ROD.get()), (Object)((PartType)PartTypes.CORD.get())));
    private final Supplier<GearType> gearType;

    public GearFishingRodItem(Supplier<GearType> gearType) {
        super(GearHelper.getBaseItemProperties());
        this.gearType = gearType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType.get();
    }

    @Override
    public Collection<PartType> getRequiredParts() {
        return REQUIRED_PARTS.get();
    }

    @Override
    public int getDamageOnHitEntity(ItemStack gear, LivingEntity target, LivingEntity attacker) {
        return 0;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (GearHelper.isBroken(stack)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (player.fishing != null) {
            if (!level.isClientSide) {
                int i = player.fishing.retrieve(stack);
                ItemStack original = stack.copy();
                stack.hurtAndBreak(i, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                if (stack.isEmpty()) {
                    EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)original, (InteractionHand)hand);
                }
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                int j = (int)(EnchantmentHelper.getFishingTimeReduction((ServerLevel)serverlevel, (ItemStack)stack, (Entity)player) * 20.0f);
                int k = EnchantmentHelper.getFishingLuckBonus((ServerLevel)serverlevel, (ItemStack)stack, (Entity)player);
                level.addFreshEntity((Entity)new FishingHook(player, level, k, j));
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        GearClientHelper.addInformation(stack, tooltipContext, tooltip, flagIn);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        GearHelper.addAttributeModifiers(stack, builder);
        return builder.build();
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return GearHelper.getEnchantmentValue(stack);
    }

    public Component getName(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        GearHelper.setDamage(stack, damage, (x$0, x$1) -> super.setDamage(x$0, x$1));
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getProperties(stack).getNumberInt(this.getDurabilityStat());
    }

    public boolean isFoil(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return GearHelper.hurtEnemy(stack, target, attacker);
    }

    public boolean mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return GearHelper.onBlockDestroyed(stack, worldIn, state, pos, entityLiving);
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public InteractionResult useOn(UseOnContext context) {
        return GearHelper.onItemUse(context);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, onBroken);
    }

    public int getBarWidth(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColors() {
        return (stack, tintIndex) -> switch (tintIndex) {
            case 0 -> ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.ROD.get());
            case 1 -> ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.MAIN.get());
            case 3 -> ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.CORD.get());
            default -> -1;
        };
    }
}

